/*
 * Decompiled with CFR 0.152.
 */
package freak.core.graph;

import freak.core.graph.Finish;
import freak.core.graph.GraphSyntaxException;
import freak.core.graph.InPort;
import freak.core.graph.Operator;
import freak.core.graph.OutPort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class Port
implements Serializable {
    private int number;
    private String description;
    protected Operator operator;
    private ArrayList partner = new ArrayList();

    public Port(Operator operator, int number) {
        if (operator == null) {
            throw new NullPointerException("Port must belong to a operator => operator must not be null");
        }
        this.operator = operator;
        this.number = number;
    }

    protected void setNumber(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void addPartner(Port partner) {
        if (partner == null) {
            throw new NullPointerException("can't add 'null' as partner");
        }
        this.partner.add(partner);
        partner.partner.add(this);
    }

    public void removePartner(Port partner) {
        if (partner == null) {
            throw new NullPointerException("can't remove 'null' as partner");
        }
        this.partner.remove(partner);
        partner.partner.remove(this);
    }

    public Port getPartner(int i) {
        return (Port)this.partner.get(i);
    }

    protected Iterator getPartnerIterator() {
        return this.partner.listIterator();
    }

    public int getNumberOfPartners() {
        return this.partner.size();
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void checkSyntax() throws GraphSyntaxException {
    }

    public String toString() {
        if (this.operator instanceof Finish && this instanceof OutPort) {
            return "Finish population";
        }
        String arrow = " -> ";
        if (this instanceof InPort) {
            arrow = " <- ";
        }
        String partner = "[";
        Iterator iter = this.getPartnerIterator();
        while (iter.hasNext()) {
            Port port = (Port)iter.next();
            partner = String.valueOf(partner) + port.operator.getName();
            if (!iter.hasNext()) continue;
            partner = String.valueOf(partner) + ", ";
        }
        return String.valueOf(this.operator.getName()) + arrow + partner + "]";
    }
}

