/*
 * Decompiled with CFR 0.152.
 */
package freak.core.population;

import freak.core.control.Schedule;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.NoSuchIndividualException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Population
implements IndividualList {
    private Schedule schedule;
    private ArrayList delegate;

    public Population(Schedule schedule) {
        if (schedule == null) {
            throw new NullPointerException("Schedule is null.");
        }
        this.schedule = schedule;
        this.delegate = new ArrayList();
    }

    public Population(Schedule schedule, int initialCapacity) {
        if (schedule == null) {
            throw new NullPointerException("Schedule is null.");
        }
        this.schedule = schedule;
        this.delegate = new ArrayList(initialCapacity);
    }

    public Population(Schedule schedule, Individual individual) {
        if (schedule == null) {
            throw new NullPointerException("Back link to the schedule is null.");
        }
        this.schedule = schedule;
        this.delegate = new ArrayList();
        this.addIndividual(individual);
    }

    public Population(Schedule schedule, IndividualList individuals) {
        if (schedule == null) {
            throw new NullPointerException("Back link to the schedule is null.");
        }
        this.schedule = schedule;
        this.delegate = new ArrayList();
        this.addAllIndividuals(individuals);
    }

    public IndividualList getAllIndividualsWithRank(int rank) throws IllegalArgumentException, NoSuchIndividualException {
        if (!(this.schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedOperationException("This operation works on single objective fitness functions only.");
        }
        if (this.isEmpty()) {
            throw new NoSuchIndividualException("The population is empty!");
        }
        if (rank < 1 || rank > this.size()) {
            throw new IllegalArgumentException("rank has to be a number between 1 and the size of the population.");
        }
        if (rank == 1) {
            return this.getElitistsOrLoser(false);
        }
        if (rank == this.size()) {
            return this.getElitistsOrLoser(true);
        }
        HashMap<Individual, Double> fitnessMap = new HashMap<Individual, Double>();
        SingleObjectiveFitnessFunction fitness = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
        int i = 0;
        while (i < this.size()) {
            Individual individual = this.getIndividual(i);
            fitnessMap.put(individual, new Double(fitness.evaluate(individual, this)));
            ++i;
        }
        return this.quickselect(this, rank, fitnessMap);
    }

    public Individual getIndividualWithRank(int rank) throws IllegalArgumentException, NoSuchIndividualException {
        IndividualList all = this.getAllIndividualsWithRank(rank);
        return all.getIndividual(0);
    }

    public IndividualList getElitistsOrLoser(boolean worst) {
        double currentFitness;
        Individual individual;
        if (!(this.schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedOperationException("This operation works on single objective fitness functions only.");
        }
        Population elitists = new Population(this.schedule);
        Population loser = new Population(this.schedule);
        SingleObjectiveFitnessFunction fitness = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
        double bestFitness = 0.0;
        double worstFitness = 0.0;
        Iterator iter = this.iterator();
        if (iter.hasNext()) {
            individual = (Individual)iter.next();
            bestFitness = currentFitness = fitness.evaluate(individual, this);
            elitists.addIndividual(individual);
            worstFitness = currentFitness;
            loser.addIndividual(individual);
        }
        while (iter.hasNext()) {
            individual = (Individual)iter.next();
            currentFitness = fitness.evaluate(individual, this);
            if (!worst && currentFitness >= bestFitness) {
                if (currentFitness > bestFitness) {
                    elitists.clear();
                    bestFitness = currentFitness;
                }
                elitists.addIndividual(individual);
            }
            if (!worst || !(currentFitness <= worstFitness)) continue;
            if (currentFitness < worstFitness) {
                loser.clear();
                worstFitness = currentFitness;
            }
            loser.addIndividual(individual);
        }
        return worst ? loser : elitists;
    }

    private Population quickselect(IndividualList list, int rank, Map fitnessMap) throws NoSuchIndividualException {
        if (list.isEmpty()) {
            throw new NoSuchIndividualException();
        }
        Population small = new Population(this.getSchedule());
        Population equal = new Population(this.getSchedule());
        Population large = new Population(this.getSchedule());
        Individual pivot = list.getRandomIndividual();
        double fitnessOfPivot = (Double)fitnessMap.get(pivot);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Individual currentIndividual = (Individual)iter.next();
            double fitnessOfCurrentIndividual = (Double)fitnessMap.get(currentIndividual);
            if (fitnessOfPivot > fitnessOfCurrentIndividual) {
                small.addIndividual(currentIndividual);
            }
            if (fitnessOfPivot == fitnessOfCurrentIndividual) {
                equal.addIndividual(currentIndividual);
            }
            if (!(fitnessOfPivot < fitnessOfCurrentIndividual)) continue;
            large.addIndividual(currentIndividual);
        }
        if (rank - 1 >= large.size() + equal.size()) {
            return this.quickselect(small, rank - large.size() - equal.size(), fitnessMap);
        }
        if (rank - 1 < large.size()) {
            return this.quickselect(large, rank, fitnessMap);
        }
        return equal;
    }

    public Individual getRandomIndividual() throws NoSuchIndividualException {
        if (this.isEmpty()) {
            throw new NoSuchIndividualException("the population is empty!");
        }
        int randomNumber = this.schedule.getRandomElement().choose(0, this.size() - 1);
        return this.getIndividual(randomNumber);
    }

    public void addIndividual(int index, Individual individual) {
        this.delegate.add(index, individual);
    }

    public void addIndividual(Individual individual) {
        this.delegate.add(individual);
    }

    public boolean containsIndividual(Individual individual) {
        return this.delegate.contains(individual);
    }

    public Individual getIndividual(int index) {
        return (Individual)this.delegate.get(index);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public int size() {
        return this.delegate.size();
    }

    public Individual[] toArray() {
        return this.delegate.toArray(new Individual[this.size()]);
    }

    public void addAllIndividuals(IndividualList list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Individual individual = (Individual)iter.next();
            this.addIndividual(individual);
        }
    }

    public void removeIndividual(int i) {
        this.delegate.remove(i);
    }

    public void clear() {
        this.delegate.clear();
    }

    public int getIndividualMultiplicity(Individual individual) {
        int count = 0;
        int i = 0;
        while (i < this.size()) {
            if (this.getIndividual(i).equals(individual)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int indexOf(Individual individual) {
        return this.delegate.indexOf(individual);
    }

    public Object clone() {
        Population population = new Population(this.getSchedule());
        population.delegate = (ArrayList)this.delegate.clone();
        return population;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Population)) {
            return false;
        }
        return this.delegate.equals(((Population)o).delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public Iterator iterator() {
        return this.delegate.iterator();
    }

    public void replaceIndividual(int index, Individual individual) {
        this.delegate.set(index, individual);
    }

    public Schedule getSchedule() {
        return this.schedule;
    }
}

