/*
 * Decompiled with CFR 0.152.
 */
package freak.module.postprocessor.booleanfunction;

import freak.Freak;
import freak.core.control.Schedule;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.postprocessor.AbstractPostprocessor;
import freak.core.util.GraphViz;
import freak.module.searchspace.BooleanFunctionGenotype;
import freak.module.searchspace.logictree.AndNode;
import freak.module.searchspace.logictree.Data;
import freak.module.searchspace.logictree.OperatorNodeVector;
import freak.module.searchspace.logictree.StaticCompareNode;
import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Vector;

public class Count
extends AbstractPostprocessor {
    private static int outputNo = 0;
    private static int nodeIndex;
    public static int minCount;
    private static int minCasesFulfilled;
    public static double minPercent;
    private static int maxChildren;
    private static int maxDepth;
    public static String fileName;

    static {
        minCount = 2;
        minCasesFulfilled = 20;
        minPercent = 0.1;
        maxChildren = 3;
        maxDepth = 8;
        fileName = "count.dot";
    }

    public Count(Schedule schedule) {
        super(schedule);
    }

    public String getName() {
        return "Count literals in monomials";
    }

    public String getDescription() {
        return "Counts literals in monomials";
    }

    private OperatorNodeVector extractMonomials(IndividualList individuals) {
        OperatorNodeVector monomials = new OperatorNodeVector();
        Iterator iInd = individuals.iterator();
        while (iInd.hasNext()) {
            Individual individual = (Individual)iInd.next();
            if (individual.getGenotype() instanceof BooleanFunctionGenotype) {
                BooleanFunctionGenotype bfg = (BooleanFunctionGenotype)((BooleanFunctionGenotype)individual.getGenotype()).clone();
                OperatorNodeVector monomialsVector = bfg.getAllUsedAndNodes();
                Iterator iMon = monomialsVector.iterator();
                while (iMon.hasNext()) {
                    monomials.add((AndNode)iMon.next());
                }
            }
            Freak.debug(individual.getGenotype().toString(), 4);
        }
        return monomials;
    }

    private int[] determineFulfillment(OperatorNodeVector monomialsVector, BitSet fulfilledWithout) {
        int[] count = new int[Data.getNumCompareNodes()];
        Arrays.fill(count, -1);
        Iterator iMon = monomialsVector.iterator();
        while (iMon.hasNext()) {
            AndNode monomial = (AndNode)iMon.next();
            OperatorNodeVector literalVector = monomial.getChildren();
            Iterator iLit = literalVector.iterator();
            while (iLit.hasNext()) {
                StaticCompareNode scn = (StaticCompareNode)iLit.next();
                int index = Data.getIndexOfCompareNode(scn);
                if (count[index] != -1) continue;
                BitSet fulfillment = (BitSet)scn.getValueBitset().clone();
                fulfillment.and(fulfilledWithout);
                fulfillment.xor(Data.getResultBitSet());
                fulfillment.flip(0, Data.getNumRows());
                count[index] = fulfillment.cardinality();
            }
        }
        return count;
    }

    private void searchBestPredicting(OperatorNodeVector monomialsVector, countNode node, BitSet fulfilledWithout, int child, int depth) {
        Boolean orderByMCR = true;
        BitSet fulfilledWith = new BitSet(Data.getNumRows());
        fulfilledWith.set(0, Data.getNumRows());
        int[] count = this.countOccurences(monomialsVector);
        int[] fulfillment = this.determineFulfillment(monomialsVector, fulfilledWithout);
        int highestCount = 0;
        int highestFulfillment = 0;
        int indexChosen = 0;
        int i = 0;
        while (i < Data.getNumCompareNodes()) {
            if (orderByMCR.booleanValue() && fulfillment[i] > highestFulfillment || !orderByMCR.booleanValue() && count[i] > highestCount) {
                highestCount = count[i];
                highestFulfillment = fulfillment[i];
                indexChosen = i;
            }
            ++i;
        }
        minPercent = 0.01;
        if (highestCount >= minCount && (double)highestCount / (double)node.getCount() >= minPercent) {
            OperatorNodeVector monomialsWithMCL = new OperatorNodeVector();
            OperatorNodeVector monomialsWithoutMCL = new OperatorNodeVector();
            Iterator iMon = monomialsVector.iterator();
            while (iMon.hasNext()) {
                boolean withMCL = false;
                AndNode monomial = (AndNode)iMon.next();
                OperatorNodeVector literalVector = monomial.getChildren();
                Iterator iLit = literalVector.iterator();
                while (iLit.hasNext()) {
                    StaticCompareNode literal = (StaticCompareNode)iLit.next();
                    if (indexChosen != Data.getIndexOfCompareNode(literal)) continue;
                    fulfilledWith = (BitSet)literal.getValueBitset().clone();
                    fulfilledWith.and(fulfilledWithout);
                    withMCL = true;
                    iLit.remove();
                }
                if (withMCL) {
                    if (monomial.getNumberOfChildren() <= 0) continue;
                    monomialsWithMCL.add(monomial);
                    continue;
                }
                monomialsWithoutMCL.add(monomial);
            }
            int fulfilledControls = fulfilledWith.cardinality();
            BitSet fulfilledCasesBitSet = (BitSet)fulfilledWith.clone();
            fulfilledCasesBitSet.and(Data.getResultBitSet());
            int fulfilledCases = fulfilledCasesBitSet.cardinality();
            fulfilledControls -= fulfilledCases;
            if (fulfilledCases >= minCasesFulfilled) {
                BooleanFunctionGenotype newBfg = (BooleanFunctionGenotype)node.getGenotype().clone();
                newBfg.insertCompare(0, (StaticCompareNode)Data.getCompareNode(indexChosen).clone());
                if (node.label == 0) {
                    newBfg.deleteCompare(0, 0);
                }
                countNode newNode = new countNode(newBfg, highestCount, (double)highestCount / (double)node.getCount(), indexChosen);
                node.addChild(newNode);
                if (monomialsWithMCL.size() > 0 && depth < maxDepth) {
                    this.searchBestPredicting(monomialsWithMCL, newNode, fulfilledWith, 1, depth + 1);
                }
                if (monomialsWithoutMCL.size() > 0 && child < maxChildren) {
                    this.searchBestPredicting(monomialsWithoutMCL, node, fulfilledWithout, child + 1, depth);
                }
            }
        }
    }

    private int[] countOccurences(OperatorNodeVector monomialsVector) {
        int[] count = new int[Data.getNumCompareNodes()];
        Iterator iMon = monomialsVector.iterator();
        while (iMon.hasNext()) {
            AndNode monomial = (AndNode)iMon.next();
            OperatorNodeVector literalVector = monomial.getChildren();
            Iterator iLit = literalVector.iterator();
            while (iLit.hasNext()) {
                int n = Data.getIndexOfCompareNode((StaticCompareNode)iLit.next());
                count[n] = count[n] + 1;
            }
        }
        return count;
    }

    private void searchMostCommon(OperatorNodeVector monomialsVector, countNode node, int child, int depth) {
        int[] count = this.countOccurences(monomialsVector);
        int highestCount = 0;
        int indexChosen = 0;
        int i = 0;
        while (i < Data.getNumCompareNodes()) {
            if (count[i] > highestCount) {
                highestCount = count[i];
                indexChosen = i;
            }
            ++i;
        }
        if (highestCount >= minCount && (double)highestCount / (double)node.getCount() >= minPercent) {
            OperatorNodeVector monomialsWithMCL = new OperatorNodeVector();
            OperatorNodeVector monomialsWithoutMCL = new OperatorNodeVector();
            Iterator iMon = monomialsVector.iterator();
            while (iMon.hasNext()) {
                boolean withMCL = false;
                AndNode monomial = (AndNode)iMon.next();
                OperatorNodeVector literalVector = monomial.getChildren();
                Iterator iLit = literalVector.iterator();
                while (iLit.hasNext()) {
                    StaticCompareNode literal = (StaticCompareNode)iLit.next();
                    if (indexChosen != Data.getIndexOfCompareNode(literal)) continue;
                    withMCL = true;
                    iLit.remove();
                }
                if (withMCL) {
                    if (monomial.getNumberOfChildren() <= 0) continue;
                    monomialsWithMCL.add(monomial);
                    continue;
                }
                monomialsWithoutMCL.add(monomial);
            }
            BooleanFunctionGenotype newBfg = (BooleanFunctionGenotype)node.getGenotype().clone();
            newBfg.insertCompare(0, (StaticCompareNode)Data.getCompareNode(indexChosen).clone());
            if (node.label == 0) {
                newBfg.deleteCompare(0, 0);
            }
            countNode newNode = new countNode(newBfg, highestCount, (double)highestCount / (double)node.getCount(), indexChosen);
            node.addChild(newNode);
            if (monomialsWithMCL.size() > 0 && depth < maxDepth) {
                this.searchMostCommon(monomialsWithMCL, newNode, 1, depth + 1);
            }
            if (monomialsWithoutMCL.size() > 0 && child < maxChildren) {
                this.searchMostCommon(monomialsWithoutMCL, node, child + 1, depth);
            }
        }
    }

    public void analyse() {
        OperatorNodeVector monomials = this.extractMonomials(this.getIndividuals());
        Freak.debug("-------------------Monomials-----------------------", 3);
        if (monomials.size() > 0) {
            BooleanFunctionGenotype rootBfg = new BooleanFunctionGenotype(((BooleanFunctionGenotype)this.getIndividuals().getIndividual(0).getGenotype()).getInputFilePath(), ((BooleanFunctionGenotype)this.getIndividuals().getIndividual(0).getGenotype()).getSchedule());
            countTree result = new countTree(rootBfg, monomials.size());
            this.searchMostCommon(monomials, result.getRoot(), 1, 1);
            Freak.debug(result.getRoot().toString(), 5);
            Freak.debug("-------------------Graph Erzeugung-----------------------", 3);
            result.toGraphViz();
            Freak.debug("-------------------Graph Erzeugung erfolgreich-----------------------", 3);
        }
    }

    private class countNode {
        private Vector<countNode> children = new Vector();
        private BooleanFunctionGenotype bfg;
        private int count;
        private double percent;
        private int index;
        private int label;

        public countNode(BooleanFunctionGenotype bfg, int count2) {
            this.label = 0;
            nodeIndex = 1;
            this.bfg = bfg;
            this.count = count2;
        }

        public countNode(BooleanFunctionGenotype bfg, int count2, double percent, int index) {
            this.label = nodeIndex;
            nodeIndex = nodeIndex + 1;
            this.bfg = bfg;
            this.count = count2;
            this.percent = (double)new Double(percent * 10000.0).intValue() / 100.0;
            this.index = index;
        }

        public countNode() {
            this.label = nodeIndex;
            nodeIndex = nodeIndex + 1;
        }

        void addChild(countNode child) {
            if (child == null) {
                return;
            }
            this.children.add(child);
        }

        public String toString() {
            String rueckgabe = "";
            if (this.percent > 0.0) {
                rueckgabe = String.valueOf(rueckgabe) + ":" + this.count + "," + this.percent + "," + Data.getCompareNode(this.index).toString();
            }
            int i = 0;
            while (i < this.children.size()) {
                countNode kind = this.children.get(i);
                rueckgabe = String.valueOf(rueckgabe) + " " + kind.toString() + " ";
                ++i;
            }
            rueckgabe = String.valueOf(rueckgabe) + ";";
            return rueckgabe;
        }

        private String buildGraph(GraphViz gv) {
            String rueckgabe = new String();
            if (this.label != 0) {
                gv.addln(String.valueOf(this.getLabel()) + " [label=\"" + Data.getCompareNode(this.index).toString() + "\\n(" + this.bfg.evaluate1s() + "," + (Data.getNum0Rows() - this.bfg.evaluate0s()) + ")\\n" + this.count + " (" + this.percent + "%)\"];");
                rueckgabe = String.valueOf(rueckgabe) + this.bfg.toString();
            } else {
                gv.addln(String.valueOf(this.getLabel()) + " [style=invis];");
            }
            int i = 0;
            while (i < this.children.size()) {
                countNode kind = this.children.get(i);
                if (this.label != 0) {
                    gv.addln(String.valueOf(this.getLabel()) + " -> " + kind.getLabel() + ";");
                } else {
                    gv.addln(String.valueOf(this.getLabel()) + " -> " + kind.getLabel() + " [style=invis];");
                }
                rueckgabe = String.valueOf(rueckgabe) + kind.buildGraph(gv);
                ++i;
            }
            return rueckgabe;
        }

        public int getCount() {
            return this.count;
        }

        public String getLabel() {
            return new Integer(this.label).toString();
        }

        public BooleanFunctionGenotype getGenotype() {
            return this.bfg;
        }
    }

    private class countTree {
        private countNode root;

        public countTree(BooleanFunctionGenotype bfg, int count2) {
            this.root = new countNode(bfg, count2);
        }

        public countNode getRoot() {
            return this.root;
        }

        public void toGraphViz() {
            GraphViz gv = new GraphViz();
            gv.addln(gv.start_graph());
            String graphPopulation = this.root.buildGraph(gv);
            gv.addln(gv.end_graph());
            File graphDot = new File(fileName);
            try {
                FileWriter fout = new FileWriter(graphDot);
                fout.write(gv.getDotSource());
                fout.close();
            }
            catch (Exception e) {
                System.err.println("Error: I/O error while writing the dot source");
            }
        }
    }
}

