/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.services;

import edu.ucsb.cs.jicos.foundation.Command;
import edu.ucsb.cs.jicos.foundation.CommandSynchronous;
import edu.ucsb.cs.jicos.foundation.Department;
import edu.ucsb.cs.jicos.foundation.Proxy;
import edu.ucsb.cs.jicos.foundation.Q;
import edu.ucsb.cs.jicos.foundation.RemoteExceptionHandler;
import edu.ucsb.cs.jicos.foundation.Service;
import edu.ucsb.cs.jicos.foundation.ServiceImpl;
import edu.ucsb.cs.jicos.foundation.ServiceName;
import edu.ucsb.cs.jicos.services.Environment;
import edu.ucsb.cs.jicos.services.Host;
import edu.ucsb.cs.jicos.services.HostProxy;
import edu.ucsb.cs.jicos.services.HostProxyManager;
import edu.ucsb.cs.jicos.services.HostTaskStats;
import edu.ucsb.cs.jicos.services.HspAgent;
import edu.ucsb.cs.jicos.services.HspProxy;
import edu.ucsb.cs.jicos.services.JicosRemoteExceptionHandler;
import edu.ucsb.cs.jicos.services.JoinCounter;
import edu.ucsb.cs.jicos.services.NeighborManager;
import edu.ucsb.cs.jicos.services.Result;
import edu.ucsb.cs.jicos.services.ServiceTaskStats;
import edu.ucsb.cs.jicos.services.Session;
import edu.ucsb.cs.jicos.services.SessionInfo;
import edu.ucsb.cs.jicos.services.Shared;
import edu.ucsb.cs.jicos.services.Task;
import edu.ucsb.cs.jicos.services.TaskInfo;
import edu.ucsb.cs.jicos.services.TaskServer2HspReporter;
import edu.ucsb.cs.jicos.services.TaskServerProxy;
import edu.ucsb.cs.jicos.services.TaskServerServiceInfo;
import edu.ucsb.cs.jicos.services.commands.AddServiceTaskStats;
import edu.ucsb.cs.jicos.services.commands.ExecuteTask;
import edu.ucsb.cs.jicos.services.commands.GetServiceName;
import edu.ucsb.cs.jicos.services.commands.GetSession;
import edu.ucsb.cs.jicos.services.commands.LoginClient;
import edu.ucsb.cs.jicos.services.commands.LogoutClient;
import edu.ucsb.cs.jicos.services.commands.PutResult;
import edu.ucsb.cs.jicos.services.commands.ReceiveTasks;
import edu.ucsb.cs.jicos.services.commands.RegisterTaskServer;
import edu.ucsb.cs.jicos.services.commands.RequestTask;
import edu.ucsb.cs.jicos.services.commands.RequestTasks;
import edu.ucsb.cs.jicos.services.commands.UpdateShared;
import edu.ucsb.cs.jicos.utilities.PriorityQ;
import edu.ucsb.cs.jicos.utilities.Qu;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class TaskServer
extends ServiceImpl {
    private static final Command LOGOUT_COMMAND;
    private static final int REQUEST_TASKS_LEVEL = 0;
    private static final RemoteExceptionHandler REMOTE_EXCEPTION_HANDLER;
    private static final int $NEIGHBORS = 4;
    private final Command REQUEST_TASKS = new RequestTasks(this);
    private static final Class[][] command2DepartmentArray;
    private static final Class[][] command2PriorityMap;
    private Q q = new PriorityQ(1, command2PriorityMap);
    private Department taskRequests = new Department(this, this.q, 1);
    private Department[] departments = new Department[]{ServiceImpl.ASAP_DEPARTMENT, this.taskRequests};
    private Q taskRequestQ = new PriorityQ(1, command2PriorityMap);
    private Department requestTaskDepartment = new Department(this, this.taskRequestQ, 1);
    private Department internalCommandDepartment = new Department(this, new Qu(), 1);
    private Host internalHost;
    private TaskServerProxy myProxy = new TaskServerProxy(this.serviceName(), this, REMOTE_EXCEPTION_HANDLER);
    private TaskServerServiceInfo myTaskServerServiceInfo;
    private Collection subtree = Collections.synchronizedSet(new HashSet());
    private Service hsp;
    private HspProxy hspProxy;
    private TaskServer2HspReporter taskServer2HspReporter;
    private Proxy parentTaskServerProxy;
    private NeighborManager neighborManager;
    private HostProxyManager hostProxyManager = new HostProxyManager(this);
    private Session session;
    private ServiceTaskStats taskServerTaskStats = new ServiceTaskStats(this.serviceName());
    private ServiceTaskStats hspTaskStats = new ServiceTaskStats(this.serviceName());
    private JoinCounter clientRegistrationCoordinator = new JoinCounter();
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$AddServiceTaskStats;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$foundation$CommandList;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$LoginClient;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$LogoutClient;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$ProcessResult;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$ReceiveTasks;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$RegisterHost;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$RegisterNeighborTaskServer;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$SetArg;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$SetShared;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$Spawn;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$UpdateShared;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$RequestTask;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$commands$RequestTasks;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$TaskServer;

    public TaskServer(Service service, String string) throws RemoteException {
        super(command2DepartmentArray, string);
        super.setService(this);
        super.setDepartments(this.departments);
        this.hsp = service;
        this.myTaskServerServiceInfo = new TaskServerServiceInfo(this.serviceName());
        ServiceName serviceName = null;
        CommandSynchronous commandSynchronous = new GetServiceName();
        serviceName = (ServiceName)service.executeCommand(this, commandSynchronous);
        this.hspProxy = new HspProxy(serviceName, this, REMOTE_EXCEPTION_HANDLER);
        this.taskServer2HspReporter = new TaskServer2HspReporter(this);
        commandSynchronous = new RegisterTaskServer(this.serviceName());
        TaskServerServiceInfo[] taskServerServiceInfoArray = (TaskServerServiceInfo[])this.hspProxy.execute(commandSynchronous, REMOTE_EXCEPTION_HANDLER);
        this.neighborManager = new NeighborManager(taskServerServiceInfoArray, this, REMOTE_EXCEPTION_HANDLER);
        this.myTaskServerServiceInfo.point(this.neighborManager.point());
        this.parentTaskServerProxy = this.neighborManager.getParent();
        commandSynchronous = new GetSession();
        SessionInfo sessionInfo = (SessionInfo)this.hspProxy.execute(commandSynchronous, REMOTE_EXCEPTION_HANDLER);
        this.internalHost = new Host(service, "Internal Host", this);
        this.session = new Session(this, this.internalHost);
        if (sessionInfo != null) {
            this.session.loginClient(sessionInfo);
        }
        System.out.println("TaskServer: " + this.serviceName().stringName() + " ready.");
    }

    public void addServiceTaskStats(List list) {
        this.hspTaskStats.addAll(list);
        JoinCounter joinCounter = this.session.getJoinCounter();
        joinCounter.decr();
        if (joinCounter.isZero()) {
            this.sendStatistics2Parent();
        }
    }

    public void exceptionHandler(Exception exception) {
        Result result = new Result(null, exception, 0L);
        PutResult putResult = new PutResult(null, result);
        this.hspProxy.execute(putResult);
    }

    public SessionInfo getState() {
        return this.session.getSessionInfo();
    }

    HostProxyManager getHostProxyManager() {
        return this.hostProxyManager;
    }

    HspProxy hspProxy() {
        return this.hspProxy;
    }

    Department internalCommandDepartment() {
        return this.internalCommandDepartment;
    }

    Service internalHost() {
        return this.internalHost;
    }

    void issueRequestTasks() {
        Iterator iterator = this.neighborManager.iterator();
        while (iterator.hasNext()) {
            Proxy proxy = (Proxy)iterator.next();
            proxy.execute(this.REQUEST_TASKS);
        }
    }

    public synchronized void loginClient(SessionInfo sessionInfo) {
        if (!$assertionsDisabled && sessionInfo == null) {
            throw new AssertionError();
        }
        System.out.println("TaskServer:login: freeMemory: " + Runtime.getRuntime().freeMemory());
        this.taskServerTaskStats.clear();
        this.hspTaskStats.clear();
        this.session.loginClient(sessionInfo);
        LoginClient loginClient = new LoginClient(sessionInfo);
        Service service = null;
        if (this.parentTaskServerProxy != null) {
            service = this.parentTaskServerProxy.serviceName().service();
        }
        this.broadcast(loginClient, service, this.subtree);
    }

    public void logout() {
        this.hostProxyManager.logout(this.taskServerTaskStats);
        this.hspTaskStats.add(this.taskServerTaskStats);
        JoinCounter joinCounter = this.session.getJoinCounter();
        Iterator iterator = this.neighborManager.getChildren().iterator();
        while (iterator.hasNext()) {
            Proxy proxy = (Proxy)iterator.next();
            joinCounter.incr();
            proxy.execute(LOGOUT_COMMAND);
        }
        if (joinCounter.isZero()) {
            this.sendStatistics2Parent();
        }
    }

    public void processResult(TaskInfo taskInfo) {
        Service service = taskInfo.host();
        HostProxy hostProxy = (HostProxy)this.getProxy(service);
        hostProxy.processResult(taskInfo);
        this.session.processResult(taskInfo);
    }

    public void receiveTasks(Task[] taskArray, Service service) {
        this.session.receiveTasks(taskArray);
        TaskServerProxy taskServerProxy = (TaskServerProxy)this.getProxy(service);
        taskServerProxy.receiveTasks();
    }

    public SessionInfo registerHost(ServiceName serviceName, boolean bl) {
        if (!$assertionsDisabled && serviceName == null) {
            throw new AssertionError();
        }
        Service service = serviceName.service();
        super.register(service);
        TaskServer taskServer = this;
        if (bl) {
            taskServer = null;
        }
        HostProxy hostProxy = new HostProxy(serviceName, taskServer, REMOTE_EXCEPTION_HANDLER);
        this.addProxy(serviceName, hostProxy);
        this.hostProxyManager.add(hostProxy);
        this.subtree.add(hostProxy);
        SessionInfo sessionInfo = null;
        if (this.session != null) {
            sessionInfo = this.session.getSessionInfo();
        }
        System.out.println("TaskServer.registerHost: ServiceName: " + serviceName);
        return sessionInfo;
    }

    public void registerTaskServer(TaskServerServiceInfo taskServerServiceInfo, int n) {
        System.out.println("TaskServer.registerTaskServer: " + taskServerServiceInfo.point());
        TaskServerProxy taskServerProxy = this.neighborManager.setNeighbor(taskServerServiceInfo, n);
        this.addProxy(taskServerServiceInfo, taskServerProxy);
        int n2 = this.neighborManager.point().row();
        if (n == 1 || n2 == 0 && n == 2) {
            System.out.println("TaskServer.registerTaskServer: " + this.neighborManager.point() + " adding child: " + taskServerServiceInfo.point());
            this.subtree.add(taskServerProxy);
        }
    }

    public void requestTask(Service service) {
        Task task = this.session.requestTask(service);
        ExecuteTask executeTask = new ExecuteTask(task);
        Proxy proxy = this.getProxy(service);
        if (proxy == null) {
            this.session.unassign(task.getTaskId());
            return;
        }
        proxy.execute(executeTask);
    }

    public Department requestTaskDepartment() {
        return this.requestTaskDepartment;
    }

    public void requestTasks(Service service) {
        int n = ((PriorityQ)this.taskRequests.q()).size(0) + 2;
        Task[] taskArray = this.session.requestTasks(n);
        ReceiveTasks receiveTasks = new ReceiveTasks(taskArray, this);
        this.sendCommand(service, receiveTasks);
    }

    private void sendStatistics2Parent() {
        AddServiceTaskStats addServiceTaskStats = new AddServiceTaskStats(this.hspTaskStats);
        Proxy proxy = this.neighborManager.getParent();
        if (proxy == null) {
            this.hspProxy.execute(addServiceTaskStats);
        } else {
            proxy.execute(addServiceTaskStats);
        }
        this.session.clear();
        System.out.println("TaskServer.logout: Completed.");
    }

    public void setShared(Shared shared, Service service) {
        if (!$assertionsDisabled && shared == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && service == null) {
            throw new AssertionError();
        }
        SessionInfo sessionInfo = this.session.getSessionInfo();
        if (sessionInfo == null) {
            return;
        }
        Environment environment = sessionInfo.getEnvironment();
        if (shared.isNewerThan(environment.getShared())) {
            environment.setShared(shared);
            UpdateShared updateShared = new UpdateShared(shared, this);
            this.broadcast(updateShared, service);
        }
    }

    public Session session() {
        return this.session;
    }

    RemoteExceptionHandler remoteExceptionHandler() {
        return REMOTE_EXCEPTION_HANDLER;
    }

    ServiceTaskStats taskServerTaskStats() {
        return this.taskServerTaskStats;
    }

    synchronized void unregisterHost(Service service) {
        HostProxy hostProxy = (HostProxy)this.removeProxy(service);
        this.hostProxyManager.remove(hostProxy);
        this.subtree.remove(hostProxy);
        HostTaskStats hostTaskStats = hostProxy.hostTaskStats();
        this.taskServerTaskStats.add(hostTaskStats);
        this.unregister(service);
        System.out.println("TaskServer.unregisterHost: complete.");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Command line: <Hsp-domain-name> required");
            System.exit(1);
        }
        String string = stringArray[0];
        HspAgent hspAgent = new HspAgent(string);
        Service service = hspAgent.getHsp();
        String string2 = stringArray[0];
        if (stringArray.length == 3) {
            string2 = stringArray[2];
        }
        new TaskServer(service, string2);
        int n = 0;
        if (stringArray.length > 1) {
            n = Integer.parseInt(stringArray[1]);
        }
        int n2 = 0;
        while (n2 < n) {
            new Host(service, string2 + " " + n2, null);
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$edu$ucsb$cs$jicos$services$TaskServer == null ? (class$edu$ucsb$cs$jicos$services$TaskServer = TaskServer.class$("edu.ucsb.cs.jicos.services.TaskServer")) : class$edu$ucsb$cs$jicos$services$TaskServer).desiredAssertionStatus();
        LOGOUT_COMMAND = new LogoutClient();
        REMOTE_EXCEPTION_HANDLER = new JicosRemoteExceptionHandler();
        command2DepartmentArray = new Class[][]{{class$edu$ucsb$cs$jicos$services$commands$AddServiceTaskStats == null ? (class$edu$ucsb$cs$jicos$services$commands$AddServiceTaskStats = TaskServer.class$("edu.ucsb.cs.jicos.services.commands.AddServiceTaskStats")) : class$edu$ucsb$cs$jicos$services$commands$AddServiceTaskStats, class$edu$ucsb$cs$jicos$foundation$CommandList == null ? (class$edu$ucsb$cs$jicos$foundation$CommandList = TaskServer.class$("edu.ucsb.cs.jicos.foundation.CommandList")) : class$edu$ucsb$cs$jicos$foundation$CommandList, class$edu$ucsb$cs$jicos$services$commands$LoginClient == null ? (class$edu$ucsb$cs$jicos$services$commands$LoginClient = TaskServer.class$("edu.ucsb.cs.jicos.services.commands.LoginClient")) : class$edu$ucsb$cs$jicos$services$commands$LoginClient, class$edu$ucsb$cs$jicos$services$commands$LogoutClient == null ? (class$edu$ucsb$cs$jicos$services$commands$LogoutClient = TaskServer.class$("edu.ucsb.cs.jicos.services.commands.LogoutClient")) : class$edu$ucsb$cs$jicos$services$commands$LogoutClient, class$edu$ucsb$cs$jicos$services$commands$ProcessResult == null ? (class$edu$ucsb$cs$jicos$services$commands$ProcessResult = TaskServer.class$("edu.ucsb.cs.jicos.services.commands.ProcessResult")) : class$edu$ucsb$cs$jicos$services$commands$ProcessResult, class$edu$ucsb$cs$jicos$services$commands$ReceiveTasks == null ? (class$edu$ucsb$cs$jicos$services$commands$ReceiveTasks = TaskServer.class$("edu.ucsb.cs.jicos.services.commands.ReceiveTasks")) : class$edu$ucsb$cs$jicos$services$commands$ReceiveTasks, class$edu$ucsb$cs$jicos$services$commands$RegisterHost == null ? (class$edu$ucsb$cs$jicos$services$commands$RegisterHost = TaskServer.class$("edu.ucsb.cs.jicos.services.commands.RegisterHost")) : class$edu$ucsb$cs$jicos$services$commands$RegisterHost, class$edu$ucsb$cs$jicos$services$commands$RegisterNeighborTaskServer == null ? (class$edu$ucsb$cs$jicos$services$commands$RegisterNeighborTaskServer = TaskServer.class$("edu.ucsb.cs.jicos.services.commands.RegisterNeighborTaskServer")) : class$edu$ucsb$cs$jicos$services$commands$RegisterNeighborTaskServer, class$edu$ucsb$cs$jicos$services$commands$SetArg == null ? (class$edu$ucsb$cs$jicos$services$commands$SetArg = TaskServer.class$("edu.ucsb.cs.jicos.services.commands.SetArg")) : class$edu$ucsb$cs$jicos$services$commands$SetArg, class$edu$ucsb$cs$jicos$services$commands$SetShared == null ? (class$edu$ucsb$cs$jicos$services$commands$SetShared = TaskServer.class$("edu.ucsb.cs.jicos.services.commands.SetShared")) : class$edu$ucsb$cs$jicos$services$commands$SetShared, class$edu$ucsb$cs$jicos$services$commands$Spawn == null ? (class$edu$ucsb$cs$jicos$services$commands$Spawn = TaskServer.class$("edu.ucsb.cs.jicos.services.commands.Spawn")) : class$edu$ucsb$cs$jicos$services$commands$Spawn, class$edu$ucsb$cs$jicos$services$commands$UpdateShared == null ? (class$edu$ucsb$cs$jicos$services$commands$UpdateShared = TaskServer.class$("edu.ucsb.cs.jicos.services.commands.UpdateShared")) : class$edu$ucsb$cs$jicos$services$commands$UpdateShared}, {class$edu$ucsb$cs$jicos$services$commands$RequestTask == null ? (class$edu$ucsb$cs$jicos$services$commands$RequestTask = TaskServer.class$("edu.ucsb.cs.jicos.services.commands.RequestTask")) : class$edu$ucsb$cs$jicos$services$commands$RequestTask, class$edu$ucsb$cs$jicos$services$commands$RequestTasks == null ? (class$edu$ucsb$cs$jicos$services$commands$RequestTasks = TaskServer.class$("edu.ucsb.cs.jicos.services.commands.RequestTasks")) : class$edu$ucsb$cs$jicos$services$commands$RequestTasks}};
        command2PriorityMap = new Class[][]{{new RequestTask(null).getClass(), new RequestTasks(null).getClass()}};
    }
}

