/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Point;
import java.awt.Rectangle;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortRenderer;
import org.jgraph.graph.VertexView;

public class PortView
extends AbstractCellView {
    protected static int size = 6;
    public static PortRenderer renderer = new PortRenderer();
    protected transient CellView lastParent;

    public PortView(Object object, JGraph jGraph, CellMapper cellMapper) {
        super(object, jGraph, cellMapper);
    }

    public CellView getParentView() {
        CellView cellView = super.getParentView();
        if (cellView == null) {
            cellView = this.lastParent;
        } else {
            this.lastParent = cellView;
        }
        return cellView;
    }

    public Rectangle getBounds() {
        Rectangle rectangle = new Rectangle(this.getLocation(null));
        rectangle.x -= size / 2;
        rectangle.y -= size / 2;
        rectangle.width += size;
        rectangle.height += size;
        return rectangle;
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext graphContext) {
        return null;
    }

    public Point getLocation(EdgeView edgeView) {
        Port port = null;
        if (this.cell instanceof Port) {
            port = ((Port)this.cell).getAnchor();
        }
        PortView portView = (PortView)this.mapper.getMapping(port, false);
        Point point = null;
        boolean bl = GraphConstants.isAbsolute(this.allAttributes);
        Point point2 = GraphConstants.getOffset(this.allAttributes);
        VertexView vertexView = (VertexView)this.getParentView();
        if (vertexView != null) {
            if (edgeView == null && point2 == null) {
                point = vertexView.getCenterPoint();
            }
            if (point2 != null) {
                int n = point2.x;
                int n2 = point2.y;
                Rectangle rectangle = vertexView.getBounds();
                if (!bl) {
                    n = n * (rectangle.width - 1) / 1000;
                    n2 = n2 * (rectangle.height - 1) / 1000;
                }
                point = portView != null ? portView.getLocation(edgeView) : rectangle.getLocation();
                point = new Point(point.x + n, point.y + n2);
            } else if (edgeView != null) {
                Point point3 = this.getNextPoint(edgeView);
                if (point3 == null) {
                    return vertexView.getCenterPoint();
                }
                point = vertexView.getPerimeterPoint(point, point3);
            }
        }
        return point;
    }

    protected Point getNextPoint(EdgeView edgeView) {
        int n = edgeView.getPointCount();
        if (n > 1) {
            if (edgeView.getSource() == this) {
                return this.getEdgePoint(edgeView, 1);
            }
            if (edgeView.getTarget() == this) {
                return this.getEdgePoint(edgeView, n - 2);
            }
        }
        return null;
    }

    protected Point getEdgePoint(EdgeView edgeView, int n) {
        VertexView vertexView;
        Object e = edgeView.points.get(n);
        if (e instanceof Point) {
            return (Point)e;
        }
        if (e instanceof PortView && (vertexView = (VertexView)((CellView)e).getParentView()) != null) {
            return vertexView.getCenterPoint();
        }
        return null;
    }
}

