/*
 * Decompiled with CFR 0.152.
 */
package freak.core.control;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Batch;
import freak.core.control.BatchList;
import freak.core.control.EventController;
import freak.core.control.FreakClassComparator;
import freak.core.control.GenerationIndex;
import freak.core.control.RunIndex;
import freak.core.control.SimulationException;
import freak.core.control.TimeController;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.BatchEventSource;
import freak.core.event.EventSource;
import freak.core.event.GenerationEvent;
import freak.core.event.GenerationEventListener;
import freak.core.event.GenerationEventSource;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.event.RunEventSource;
import freak.core.event.ScheduleEvent;
import freak.core.event.ScheduleEventListener;
import freak.core.event.ScheduleEventSource;
import freak.core.fitness.FitnessFunction;
import freak.core.fitness.FitnessTransformer;
import freak.core.graph.FreakGraphModel;
import freak.core.graph.GraphException;
import freak.core.graph.Initialization;
import freak.core.graph.OperatorGraph;
import freak.core.mapper.Mapper;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Configuration;
import freak.core.modulesupport.Module;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.Observer;
import freak.core.observer.ObserverManager;
import freak.core.populationmanager.PopulationManager;
import freak.core.random.RandomElementFactory;
import freak.core.random.SimpleRandomElementFactory;
import freak.core.searchspace.SearchSpace;
import freak.core.stoppingcriterion.StoppingCriterion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Schedule
implements GenerationEventSource,
RunEventSource,
BatchEventSource,
ScheduleEventSource,
Serializable {
    private EventController eventController = new EventController();
    private FreakGraphModel graphModel;
    private Initialization initialization;
    private PopulationManager populationManager;
    private SearchSpace phenotypeSearchSpace;
    private Mapper searchspaceMapper;
    private FitnessFunction fitnessFunction;
    private RandomElementFactory randomElementFactory;
    private RandomElement randomElement;
    private BatchList batchList = new BatchList();
    private Batch defaultBatch;
    private ObserverManager observerManager = new ObserverManager();
    private StoppingCriterion[] stoppingCriteria;
    TimeController timeController = new TimeController();
    private Set generationEventListeners = new HashSet();
    private Set runEventListeners = new HashSet();
    private Set batchEventListeners = new HashSet();
    private Set scheduleEventListeners = new HashSet();
    private GenerationIndex currentTimeIndex = GenerationIndex.START;
    private GenerationIndex nextStepTimeIndex = GenerationIndex.FIRST;
    private GenerationIndex nextSkipTimeIndex = GenerationIndex.FIRST;
    private boolean stopRequestRecieved = true;
    private boolean aborted = false;
    private boolean callInitializeRunning = false;

    public Schedule() {
        this.randomElementFactory = new SimpleRandomElementFactory();
        this.randomElement = this.randomElementFactory.getRandomElement();
    }

    public FitnessFunction getRealFitnessFunction() {
        FitnessFunction result = this.getFitnessFunction();
        while (result instanceof FitnessTransformer) {
            result = ((FitnessTransformer)result).getFitnessFunction();
        }
        return result;
    }

    public OperatorGraph getOperatorGraph() {
        if (this.graphModel == null) {
            return null;
        }
        return this.graphModel.getOperatorGraph();
    }

    public void setInitialization(Initialization initialization) {
        this.initialization = initialization;
    }

    public Initialization getInitialization() {
        return this.initialization;
    }

    public PopulationManager getPopulationManager() {
        return this.populationManager;
    }

    public ObserverManager getObserverManager() {
        return this.observerManager;
    }

    public FitnessFunction getFitnessFunction() {
        return this.fitnessFunction;
    }

    public SearchSpace getGenotypeSearchSpace() {
        if (this.searchspaceMapper != null) {
            return this.searchspaceMapper.getGenotypeSearchSpace();
        }
        return this.phenotypeSearchSpace;
    }

    public void setPhenotypeSearchSpace(SearchSpace space) {
        this.phenotypeSearchSpace = space;
    }

    public SearchSpace getPhenotypeSearchSpace() {
        return this.phenotypeSearchSpace;
    }

    public void setMapper(Mapper mapper) {
        this.searchspaceMapper = mapper;
    }

    public Mapper getMapper() {
        return this.searchspaceMapper;
    }

    public void setFitnessFunction(FitnessFunction function) {
        this.fitnessFunction = function;
    }

    public void setRandomElementFactory(RandomElementFactory factory) {
        this.randomElementFactory = factory;
    }

    public RandomElementFactory getRandomElementFactory() {
        return this.randomElementFactory;
    }

    public RandomElement getRandomElement() {
        return this.randomElement;
    }

    public void setRandomElement(RandomElement element) {
        this.randomElement = element;
    }

    public void setPopulationManager(PopulationManager manager) {
        this.populationManager = manager;
    }

    public void setGraphModel(FreakGraphModel graphModel) {
        this.graphModel = graphModel;
    }

    public EventController getEventController() {
        return this.eventController;
    }

    public Object[] getPossibleEventSources() {
        ArrayList<EventSource> l = new ArrayList<EventSource>();
        if (this.populationManager != null) {
            l.add(this.populationManager);
        }
        l.add(this);
        if (this.graphModel != null) {
            Object[] ports = this.getOperatorGraph().getAllPossibleEventSources();
            l.addAll((Collection)Arrays.asList(ports));
        }
        return l.toArray();
    }

    public StoppingCriterion[] getStoppingCriteria() {
        return this.stoppingCriteria;
    }

    public void setStoppingCriteria(StoppingCriterion[] criteria) {
        this.stoppingCriteria = criteria;
    }

    public FreakGraphModel getFreakGraphModel() {
        return this.graphModel;
    }

    public BatchList getBatchList() {
        return this.batchList;
    }

    public Batch getDefaultBatch() {
        return this.defaultBatch;
    }

    public void setDefaultBatch(Batch batch) {
        this.defaultBatch = batch;
    }

    public Batch createBatchFromCurrentConfigurations() {
        Initialization init;
        FitnessFunction fitness;
        Batch batch = new Batch();
        SearchSpace ss = this.getPhenotypeSearchSpace();
        if (ss != null && ss instanceof Configurable) {
            Configuration conf = ((Configurable)((Object)ss)).getConfiguration();
            batch.putConfiguration((Configurable)((Object)ss), conf);
        }
        if ((fitness = this.getRealFitnessFunction()) != null && fitness instanceof Configurable) {
            Configuration conf = ((Configurable)((Object)fitness)).getConfiguration();
            batch.putConfiguration((Configurable)((Object)fitness), conf);
        }
        if ((init = this.getInitialization()) != null && init instanceof Configurable) {
            Configuration conf = init.getConfiguration();
            batch.putConfiguration(init, conf);
        }
        return batch;
    }

    public Set getAllModules() {
        HashSet<Module> modules = new HashSet<Module>();
        if (this.phenotypeSearchSpace != null) {
            modules.add(this.phenotypeSearchSpace);
        }
        if (this.fitnessFunction != null) {
            FitnessFunction fitness = this.fitnessFunction;
            while (fitness instanceof FitnessTransformer) {
                modules.add(fitness);
                fitness = ((FitnessTransformer)fitness).getFitnessFunction();
            }
            modules.add(fitness);
        }
        if (this.searchspaceMapper != null) {
            modules.add(this.searchspaceMapper);
            modules.add(this.getGenotypeSearchSpace());
        }
        if (this.getOperatorGraph() != null) {
            modules.add(this.getOperatorGraph());
            int i = 0;
            while (i < this.getOperatorGraph().getOperatorCount()) {
                modules.add(this.getOperatorGraph().getOperator(i));
                ++i;
            }
            modules.addAll(this.getOperatorGraph().getParameterControllers());
        }
        if (this.stoppingCriteria != null) {
            int i = 0;
            while (i < this.stoppingCriteria.length) {
                modules.add(this.stoppingCriteria[i]);
                ++i;
            }
        }
        if (this.populationManager != null) {
            modules.add(this.populationManager);
        }
        if (this.initialization != null) {
            modules.add(this.initialization);
        }
        for (Observer observer : this.observerManager.getActiveObservers()) {
            modules.add(observer);
            Iterator iter2 = observer.getViews().iterator();
            while (iter2.hasNext()) {
                modules.add((Module)iter2.next());
            }
        }
        return modules;
    }

    public String toString() {
        return "The Schedule itself";
    }

    public GenerationIndex getCurrentTimeIndex() {
        return this.currentTimeIndex;
    }

    public int getCurrentBatch() {
        return this.currentTimeIndex.batch;
    }

    public int getCurrentRun() {
        return this.currentTimeIndex.run;
    }

    public int getCurrentGeneration() {
        return this.currentTimeIndex.generation;
    }

    public boolean isFinished() {
        return this.nextStepTimeIndex == GenerationIndex.END;
    }

    public boolean isCurrentRunFinished() {
        return this.stopRequestRecieved;
    }

    public double getRunTime() {
        return this.timeController.getRuntime();
    }

    public void modulesEdited() {
        Batch b;
        this.fireScheduleEditedEvent();
        if (this.currentTimeIndex.batch != 0 && (b = this.batchList.get(this.currentTimeIndex.batch - 1)).getRuns() == this.currentTimeIndex.run && this.stopRequestRecieved && !b.isFinished()) {
            b.setFinished(true);
            this.fireBatchFinished();
        }
        this.computeNextStepTimeIndex();
    }

    public void triggerStopCriterion() {
        this.stopRequestRecieved = true;
        this.aborted = false;
    }

    public void triggerSkip() {
        if (!this.stopRequestRecieved) {
            this.aborted = true;
            this.stopRequestRecieved = true;
        }
    }

    GenerationIndex getNextStepTimeIndex() {
        return this.nextStepTimeIndex;
    }

    GenerationIndex nextSkipTimeIndex() {
        return this.nextSkipTimeIndex;
    }

    void skip() {
        if (!this.stopRequestRecieved) {
            this.aborted = true;
            this.stopRequestRecieved = true;
            this.afterStep();
        }
    }

    void step() throws SimulationException {
        if (this.currentTimeIndex.batch == 0) {
            this.stepSchedule();
        } else if (this.stopRequestRecieved && this.isLastRunInBatch()) {
            this.stepBatch();
        } else if (this.stopRequestRecieved) {
            this.stepRun();
        } else {
            this.stepGeneration();
        }
    }

    private void stepSchedule() throws SimulationException {
        this.fireScheduleStartedEvent();
        this.stepBatch();
    }

    private void stepBatch() throws SimulationException {
        this.currentTimeIndex = this.nextStepTimeIndex;
        this.stopRequestRecieved = false;
        this.aborted = false;
        this.randomElement = this.randomElementFactory.getRandomElement();
        Batch batch = this.batchList.get(this.currentTimeIndex.batch - 1);
        batch.applyAllConfigurations();
        batch.setStarted(true);
        this.callInitialize();
        this.fireBatchStarted();
        this.fireRunStartedEvent();
        this.populationManager.initPopulation(this.initialization);
        this.fireGenerationEvent();
        this.afterStep();
    }

    private void stepRun() throws SimulationException {
        this.currentTimeIndex = this.nextStepTimeIndex;
        this.stopRequestRecieved = false;
        this.aborted = false;
        this.randomElement = this.randomElementFactory.getRandomElement();
        this.fireRunStartedEvent();
        this.populationManager.initPopulation(this.initialization);
        this.fireGenerationEvent();
        this.afterStep();
    }

    private void stepGeneration() throws GraphException {
        this.currentTimeIndex = this.nextStepTimeIndex;
        this.populationManager.createNewGeneration();
        this.fireGenerationEvent();
        this.afterStep();
    }

    private void afterStep() {
        if (this.stopRequestRecieved) {
            if (this.aborted) {
                this.fireRunAborted();
            } else {
                this.fireRunCompleted();
            }
            this.fireRunFinalize();
            if (this.isLastRunInBatch()) {
                Batch currentBatch = this.getBatchList().get(this.currentTimeIndex.batch - 1);
                currentBatch.setFinished(true);
                this.fireBatchFinished();
            }
        }
        this.computeNextStepTimeIndex();
    }

    private void computeNextStepTimeIndex() {
        if (this.stopRequestRecieved) {
            if (this.currentTimeIndex.batch == 0) {
                this.nextStepTimeIndex = GenerationIndex.FIRST;
            }
            this.nextStepTimeIndex = this.isLastRunInBatch() ? (this.isLastBatch() ? GenerationIndex.END : this.currentTimeIndex.nextBatchStart()) : this.currentTimeIndex.nextRunStart();
        } else {
            this.nextStepTimeIndex = this.currentTimeIndex.nextGeneration();
        }
    }

    public boolean isLastRunInBatch() {
        if (this.currentTimeIndex.batch == 0) {
            return true;
        }
        return this.batchList.get(this.currentTimeIndex.batch - 1).getRuns() == this.currentTimeIndex.run;
    }

    public boolean isLastBatch() {
        return this.batchList.size() == this.currentTimeIndex.batch;
    }

    public void callInitialize() {
        if (!this.callInitializeRunning) {
            this.callInitializeRunning = true;
            Set moduleSet = this.getAllModules();
            Module[] modules = moduleSet.toArray(new Module[moduleSet.size()]);
            Arrays.sort(modules, new FreakClassComparator());
            try {
                int i = 0;
                while (i < modules.length) {
                    modules[i].testSchedule(this);
                    modules[i].initialize();
                    ++i;
                }
            }
            catch (UnsupportedEnvironmentException e) {
                this.callInitializeRunning = false;
                throw new SimulationException(e);
            }
            this.callInitializeRunning = false;
        }
    }

    public void addGenerationEventListener(GenerationEventListener l) {
        this.generationEventListeners.add(l);
    }

    public void removeGenerationEventListener(GenerationEventListener l) {
        this.generationEventListeners.remove(l);
    }

    private void fireGenerationEvent() {
        GenerationEvent evt = new GenerationEvent(this, this.currentTimeIndex.generation);
        for (GenerationEventListener l : this.generationEventListeners) {
            l.generation(evt);
        }
    }

    public void addRunEventListener(RunEventListener l) {
        this.runEventListeners.add(l);
    }

    public void removeRunEventListener(RunEventListener l) {
        this.runEventListeners.remove(l);
    }

    private void fireRunStartedEvent() {
        RunIndex run = this.currentTimeIndex.toRunIndex();
        RunEvent evt = new RunEvent(this, run);
        for (RunEventListener l : this.runEventListeners) {
            l.runStarted(evt);
        }
    }

    private void fireRunCompleted() {
        RunEvent evt = new RunEvent(this, this.currentTimeIndex.toRunIndex());
        for (RunEventListener l : this.runEventListeners) {
            l.runCompleted(evt);
        }
    }

    private void fireRunAborted() {
        RunEvent evt = new RunEvent(this, this.currentTimeIndex.toRunIndex());
        for (RunEventListener l : this.runEventListeners) {
            l.runAborted(evt);
        }
    }

    private void fireRunFinalize() {
        RunEvent evt = new RunEvent(this, this.currentTimeIndex.toRunIndex());
        for (RunEventListener l : this.runEventListeners) {
            l.runFinalize(evt);
        }
    }

    public void addBatchEventListener(BatchEventListener l) {
        this.batchEventListeners.add(l);
    }

    public void removeBatchEventListener(BatchEventListener l) {
        this.batchEventListeners.remove(l);
    }

    private void fireBatchStarted() {
        BatchEvent evt = new BatchEvent(this, this.currentTimeIndex.batch);
        for (BatchEventListener l : this.batchEventListeners) {
            l.batchStarted(evt);
        }
    }

    private void fireBatchFinished() {
        BatchEvent evt = new BatchEvent(this, this.currentTimeIndex.batch);
        for (BatchEventListener l : this.batchEventListeners) {
            l.batchFinished(evt);
        }
    }

    public void addScheduleEventListener(ScheduleEventListener l) {
        this.scheduleEventListeners.add(l);
    }

    public void removeScheduleEventListener(ScheduleEventListener l) {
        this.scheduleEventListeners.remove(l);
    }

    private void fireScheduleStartedEvent() {
        ScheduleEvent evt = new ScheduleEvent(this);
        for (ScheduleEventListener l : this.scheduleEventListeners) {
            l.scheduleStarted(evt);
        }
    }

    private void fireScheduleEditedEvent() {
        ScheduleEvent evt = new ScheduleEvent(this);
        for (ScheduleEventListener l : this.scheduleEventListeners) {
            l.scheduleEdited(evt);
        }
    }

    public FreakGraphModel getGraphModel() {
        return this.graphModel;
    }
}

