/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.crossover.common;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Recombination;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import freak.core.searchspace.HasDimension;
import freak.core.searchspace.SearchSpace;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;
import java.util.BitSet;
import java.util.Iterator;

public class GenepoolCrossover
extends Recombination
implements Configurable,
CompatibleWithDifferentSearchSpaces {
    protected int numChildren = 1;

    public GenepoolCrossover(OperatorGraph graph) {
        super(graph);
        super.addOutPort();
        super.addInPort();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        SearchSpace searchspace = schedule.getGenotypeSearchSpace();
        if (!(searchspace instanceof GeneralString) && !(searchspace instanceof BitString)) {
            throw new UnsupportedEnvironmentException("Wrong searchspace");
        }
    }

    public IndividualList[] process(IndividualList[] input) {
        SearchSpace searchspace = this.graph.getSchedule().getGenotypeSearchSpace();
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int dimension = ((HasDimension)((Object)searchspace)).getDimension();
        IndividualList[] output = new IndividualList[]{new Population(this.graph.getSchedule(), this.numChildren)};
        int sumInd = 0;
        if (searchspace instanceof BitString) {
            BitSet bs;
            int[] stats = new int[dimension];
            int i = 0;
            while (i < input.length) {
                Iterator it = input[i].iterator();
                while (it.hasNext()) {
                    ++sumInd;
                    Individual ind = (Individual)it.next();
                    bs = ((BitStringGenotype)ind.getGenotype()).getBitSet();
                    int j = 0;
                    while (j < dimension) {
                        if (bs.get(j)) {
                            int n = j;
                            stats[n] = stats[n] + 1;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            int j = 0;
            while (j < this.numChildren) {
                bs = new BitSet(dimension);
                int i2 = 0;
                while (i2 < dimension) {
                    if (re.choose(sumInd) <= stats[i2]) {
                        bs.set(i2);
                    }
                    ++i2;
                }
                output[0].addIndividual(new Individual(this.graph.getSchedule(), new BitStringGenotype(bs, dimension), new Individual[0]));
                ++j;
            }
        } else {
            int j;
            int[] genotype;
            int numChars = ((GeneralString)searchspace).getNumChars();
            int[][] stats = new int[dimension][numChars];
            int i = 0;
            while (i < input.length) {
                Iterator it = input[i].iterator();
                while (it.hasNext()) {
                    ++sumInd;
                    Individual ind = (Individual)it.next();
                    genotype = ((GeneralStringGenotype)ind.getGenotype()).getIntArray();
                    j = 0;
                    while (j < dimension) {
                        int[] nArray = stats[j];
                        int n = genotype[j];
                        nArray[n] = nArray[n] + 1;
                        ++j;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < dimension) {
                j = 0;
                while (j < numChars - 1) {
                    int[] nArray = stats[i];
                    int n = j + 1;
                    nArray[n] = nArray[n] + stats[i][j];
                    ++j;
                }
                ++i;
            }
            j = 0;
            while (j < this.numChildren) {
                genotype = new int[dimension];
                int i3 = 0;
                while (i3 < dimension) {
                    int v = re.choose(sumInd);
                    int b = 0;
                    while (b < numChars) {
                        if (v <= stats[i3][b]) {
                            genotype[i3] = b;
                            b = numChars;
                        }
                        ++b;
                    }
                    ++i3;
                }
                output[0].addIndividual(new Individual(this.graph.getSchedule(), new GeneralStringGenotype(genotype, numChars), new Individual[0]));
                ++j;
            }
        }
        return output;
    }

    public void setPropertyNumChildren(Integer num) {
        if (num >= 0) {
            this.numChildren = num;
        }
    }

    public Integer getPropertyNumChildren() {
        return new Integer(this.numChildren);
    }

    public String getShortDescriptionForNumChildren() {
        return "Created offsprings";
    }

    public String getLongDescriptionForNumChildren() {
        return "The number of offsprings to be created.";
    }

    public String getDescription() {
        if (this.graph.getSchedule().getGenotypeSearchSpace() instanceof BitString) {
            return "Takes a whole population as input and performs a genepool crossover to create the specified number of offsprings: the number k of ones at position i is counted and the i-th bit in each child is set to one with probability k/n if n is the number of incoming individuals.";
        }
        return "Takes a whole population as input and performs a genepool crossover to create the specified number of offsprings: the number k of every char at position i is counted and the i-th position in each child is set to a char with probability k/n if n is the number of incoming individuals.";
    }

    public String getName() {
        return "Gene Pool Crossover";
    }
}

