% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/custom-dims.R
\name{list_custom_dimensions}
\alias{list_custom_dimensions}
\title{Lists custom dimensions to which the user has access to}
\usage{
list_custom_dimensions(account.id, webproperty.id, start.index = NULL,
  max.results = NULL, token)
}
\arguments{
\item{account.id}{Account ID for the custom dimensions to retrieve.}

\item{webproperty.id}{Web property ID for the custom dimensions to retrieve.}

\item{start.index}{An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{The maximum number of custom dimensions to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
An Analytics custom dimension.
\item{id}{Custom dimension ID.}
\item{account.id}{Account ID.}
\item{webproperty.id}{Property ID.}
\item{name}{Name of the custom dimension.}
\item{index}{Index of the custom dimension.}
\item{scope}{Scope of the custom dimension: HIT, SESSION, USER or PRODUCT.}
\item{active}{Boolean indicating whether the custom dimension is active.}
\item{created}{Time the custom dimension was created.}
\item{updated}{Time the custom dimension was last modified.}
}
\description{
Lists custom dimensions to which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/customDimensions}{Google Management API - Custom Dimensions}
}
\seealso{
\code{\link{authorize}}

Other Management API: \code{\link{get_custom_dimension}};
  \code{\link{get_custom_metric}};
  \code{\link{get_experiment}}; \code{\link{get_filter}};
  \code{\link{get_goal}}; \code{\link{get_profile}};
  \code{\link{get_unsampled_report}};
  \code{\link{get_webproperty}};
  \code{\link{list_accounts}};
  \code{\link{list_custom_metrics}};
  \code{\link{list_custom_sources}};
  \code{\link{list_experiments}};
  \code{\link{list_filters}}; \code{\link{list_goals}};
  \code{\link{list_profiles}}; \code{\link{list_segments}};
  \code{\link{list_unsampled_reports}};
  \code{\link{list_webproperties}}
}

