% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{get_filter}
\alias{get_filter}
\title{Filters}
\usage{
get_filter(accountId, filterId, token)
}
\arguments{
\item{accountId}{character. Account ID to retrieve filters for.}

\item{filterId}{character. Filter ID to retrieve filters for.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
The Filters collection is a set of Filter resources, each of which describes a filter which can be applied to a View (profile).
\item{id}{Filter ID.}
\item{kind}{Resource type for Analytics filter.}
\item{accountId}{Account ID to which this filter belongs.}
\item{name}{Name of this filter.}
\item{type}{Type of this filter. Possible values are INCLUDE, EXCLUDE, LOWERCASE, UPPERCASE, SEARCH_AND_REPLACE and ADVANCED.}
\item{created}{Time this filter was created.}
\item{updated}{Time this filter was last modified.}
\item{includeDetails}{Details for the filter of the type INCLUDE.}
\item{excludeDetails}{Details for the filter of the type EXCLUDE.}
\item{lowercaseDetails}{Details for the filter of the type LOWER.}
\item{uppercaseDetails}{Details for the filter of the type UPPER.}
\item{searchAndReplaceDetails}{Details for the filter of the type SEARCH_AND_REPLACE.}
\item{advancedDetails}{Details for the filter of the type ADVANCED.}
\item{includeDetails.kind}{Kind value for filter expression}
\item{includeDetails.field}{Field to filter. Possible values:    Content and Traffic  PAGE_REQUEST_URI, PAGE_HOSTNAME, PAGE_TITLE, REFERRAL, COST_DATA_URI (Campaign target URL), HIT_TYPE, INTERNAL_SEARCH_TERM, INTERNAL_SEARCH_TYPE, SOURCE_PROPERTY_TRACKING_ID,     Campaign or AdGroup  CAMPAIGN_SOURCE, CAMPAIGN_MEDIUM, CAMPAIGN_NAME, CAMPAIGN_AD_GROUP, CAMPAIGN_TERM, CAMPAIGN_CONTENT, CAMPAIGN_CODE, CAMPAIGN_REFERRAL_PATH,     E-Commerce  TRANSACTION_COUNTRY, TRANSACTION_REGION, TRANSACTION_CITY, TRANSACTION_AFFILIATION (Store or order location), ITEM_NAME, ITEM_CODE, ITEM_VARIATION, TRANSACTION_ID, TRANSACTION_CURRENCY_CODE, PRODUCT_ACTION_TYPE,     Audience/Users  BROWSER, BROWSER_VERSION, BROWSER_SIZE, PLATFORM, PLATFORM_VERSION, LANGUAGE, SCREEN_RESOLUTION, SCREEN_COLORS, JAVA_ENABLED (Boolean Field), FLASH_VERSION, GEO_SPEED (Connection speed), VISITOR_TYPE, GEO_ORGANIZATION (ISP organization), GEO_DOMAIN, GEO_IP_ADDRESS, GEO_IP_VERSION,     Location  GEO_COUNTRY, GEO_REGION, GEO_CITY,     Event  EVENT_CATEGORY, EVENT_ACTION, EVENT_LABEL,     Other  CUSTOM_FIELD_1, CUSTOM_FIELD_2, USER_DEFINED_VALUE,     Application  APP_ID, APP_INSTALLER_ID, APP_NAME, APP_VERSION, SCREEN, IS_APP (Boolean Field), IS_FATAL_EXCEPTION (Boolean Field), EXCEPTION_DESCRIPTION,     Mobile device  IS_MOBILE (Boolean Field, Deprecated. Use DEVICE_CATEGORY=mobile), IS_TABLET (Boolean Field, Deprecated. Use DEVICE_CATEGORY=tablet), DEVICE_CATEGORY, MOBILE_HAS_QWERTY_KEYBOARD (Boolean Field), MOBILE_HAS_NFC_SUPPORT (Boolean Field), MOBILE_HAS_CELLULAR_RADIO (Boolean Field), MOBILE_HAS_WIFI_SUPPORT (Boolean Field), MOBILE_BRAND_NAME, MOBILE_MODEL_NAME, MOBILE_MARKETING_NAME, MOBILE_POINTING_METHOD,     Social  SOCIAL_NETWORK, SOCIAL_ACTION, SOCIAL_ACTION_TARGET,}
\item{includeDetails.matchType}{Match type for this filter. Possible values are BEGINS_WITH, EQUAL, ENDS_WITH, CONTAINS, or MATCHES. GEO_DOMAIN, GEO_IP_ADDRESS, PAGE_REQUEST_URI, or PAGE_HOSTNAME filters can use any match type; all other filters must use MATCHES.}
\item{includeDetails.expressionValue}{Filter expression value}
\item{includeDetails.caseSensitive}{Determines if the filter is case sensitive.}
\item{includeDetails.fieldIndex}{The Index of the custom dimension. Set only if the field is a is CUSTOM_DIMENSION.}
\item{excludeDetails.kind}{Kind value for filter expression}
\item{excludeDetails.field}{Field to filter. Possible values:    Content and Traffic  PAGE_REQUEST_URI, PAGE_HOSTNAME, PAGE_TITLE, REFERRAL, COST_DATA_URI (Campaign target URL), HIT_TYPE, INTERNAL_SEARCH_TERM, INTERNAL_SEARCH_TYPE, SOURCE_PROPERTY_TRACKING_ID,     Campaign or AdGroup  CAMPAIGN_SOURCE, CAMPAIGN_MEDIUM, CAMPAIGN_NAME, CAMPAIGN_AD_GROUP, CAMPAIGN_TERM, CAMPAIGN_CONTENT, CAMPAIGN_CODE, CAMPAIGN_REFERRAL_PATH,     E-Commerce  TRANSACTION_COUNTRY, TRANSACTION_REGION, TRANSACTION_CITY, TRANSACTION_AFFILIATION (Store or order location), ITEM_NAME, ITEM_CODE, ITEM_VARIATION, TRANSACTION_ID, TRANSACTION_CURRENCY_CODE, PRODUCT_ACTION_TYPE,     Audience/Users  BROWSER, BROWSER_VERSION, BROWSER_SIZE, PLATFORM, PLATFORM_VERSION, LANGUAGE, SCREEN_RESOLUTION, SCREEN_COLORS, JAVA_ENABLED (Boolean Field), FLASH_VERSION, GEO_SPEED (Connection speed), VISITOR_TYPE, GEO_ORGANIZATION (ISP organization), GEO_DOMAIN, GEO_IP_ADDRESS, GEO_IP_VERSION,     Location  GEO_COUNTRY, GEO_REGION, GEO_CITY,     Event  EVENT_CATEGORY, EVENT_ACTION, EVENT_LABEL,     Other  CUSTOM_FIELD_1, CUSTOM_FIELD_2, USER_DEFINED_VALUE,     Application  APP_ID, APP_INSTALLER_ID, APP_NAME, APP_VERSION, SCREEN, IS_APP (Boolean Field), IS_FATAL_EXCEPTION (Boolean Field), EXCEPTION_DESCRIPTION,     Mobile device  IS_MOBILE (Boolean Field, Deprecated. Use DEVICE_CATEGORY=mobile), IS_TABLET (Boolean Field, Deprecated. Use DEVICE_CATEGORY=tablet), DEVICE_CATEGORY, MOBILE_HAS_QWERTY_KEYBOARD (Boolean Field), MOBILE_HAS_NFC_SUPPORT (Boolean Field), MOBILE_HAS_CELLULAR_RADIO (Boolean Field), MOBILE_HAS_WIFI_SUPPORT (Boolean Field), MOBILE_BRAND_NAME, MOBILE_MODEL_NAME, MOBILE_MARKETING_NAME, MOBILE_POINTING_METHOD,     Social  SOCIAL_NETWORK, SOCIAL_ACTION, SOCIAL_ACTION_TARGET,}
\item{excludeDetails.matchType}{Match type for this filter. Possible values are BEGINS_WITH, EQUAL, ENDS_WITH, CONTAINS, or MATCHES. GEO_DOMAIN, GEO_IP_ADDRESS, PAGE_REQUEST_URI, or PAGE_HOSTNAME filters can use any match type; all other filters must use MATCHES.}
\item{excludeDetails.expressionValue}{Filter expression value}
\item{excludeDetails.caseSensitive}{Determines if the filter is case sensitive.}
\item{excludeDetails.fieldIndex}{The Index of the custom dimension. Set only if the field is a is CUSTOM_DIMENSION.}
\item{lowercaseDetails.field}{Field to use in the filter.}
\item{lowercaseDetails.fieldIndex}{The Index of the custom dimension. Required if field is a CUSTOM_DIMENSION.}
\item{uppercaseDetails.field}{Field to use in the filter.}
\item{uppercaseDetails.fieldIndex}{The Index of the custom dimension. Required if field is a CUSTOM_DIMENSION.}
\item{searchAndReplaceDetails.field}{Field to use in the filter.}
\item{searchAndReplaceDetails.fieldIndex}{The Index of the custom dimension. Required if field is a CUSTOM_DIMENSION.}
\item{searchAndReplaceDetails.searchString}{Term to search.}
\item{searchAndReplaceDetails.replaceString}{Term to replace the search term with.}
\item{searchAndReplaceDetails.caseSensitive}{Determines if the filter is case sensitive.}
\item{advancedDetails.fieldA}{Field A.}
\item{advancedDetails.fieldAIndex}{The Index of the custom dimension. Required if field is a CUSTOM_DIMENSION.}
\item{advancedDetails.extractA}{Expression to extract from field A.}
\item{advancedDetails.fieldB}{Field B.}
\item{advancedDetails.fieldBIndex}{The Index of the custom dimension. Required if field is a CUSTOM_DIMENSION.}
\item{advancedDetails.extractB}{Expression to extract from field B.}
\item{advancedDetails.outputToField}{Output field.}
\item{advancedDetails.outputToFieldIndex}{The Index of the custom dimension. Required if field is a CUSTOM_DIMENSION.}
\item{advancedDetails.outputConstructor}{Expression used to construct the output value.}
\item{advancedDetails.fieldARequired}{Indicates if field A is required to match.}
\item{advancedDetails.fieldBRequired}{Indicates if field B is required to match.}
\item{advancedDetails.overrideOutputField}{Indicates if the existing value of the output field, if any, should be overridden by the output expression.}
\item{advancedDetails.caseSensitive}{Indicates if the filter expressions are case sensitive.}
}
\description{
Returns a filters to which the user has access.
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/filters}{Management API - Filters Overview}
}
\seealso{
Other Management API: \code{\link{get_custom_dimension}},
  \code{\link{get_custom_metric}},
  \code{\link{get_experiment}}, \code{\link{get_goal}},
  \code{\link{get_profile}},
  \code{\link{get_unsampled_report}},
  \code{\link{get_upload}}, \code{\link{get_webproperty}},
  \code{\link{list_accounts}},
  \code{\link{list_custom_data_sources}},
  \code{\link{list_custom_dimensions}},
  \code{\link{list_custom_metrics}},
  \code{\link{list_experiments}},
  \code{\link{list_filters}}, \code{\link{list_goals}},
  \code{\link{list_profiles}}, \code{\link{list_segments}},
  \code{\link{list_unsampled_reports}},
  \code{\link{list_uploads}},
  \code{\link{list_webproperties}}
}

