% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{.postARp}
\alias{.postARp}
\title{Draws from the posterior of the autoregressive paramteres of a stationary AR(p),
\eqn{p > 1} process without starting values.}
\usage{
.postARp(Y, phi, phi0, Q0, sigma, lb = -Inf, ub = Inf)
}
\arguments{
\item{Y}{A \code{Tn x 1} vector with the time series.}

\item{phi}{a \code{1 x p} vector containing the last draw of the autoregressive parameters
\eqn{\phi}. \code{p} has to be larger than one.}

\item{phi0}{a \code{1 x p} vector containing the prior mean for \code{phi}.}

\item{Q0}{a \code{p x p} matrix containing the prior precision for \code{phi}.}

\item{sigma}{a scalar containing the innovation variance.}

\item{lb}{(optional) \code{1 x p} vector with lower bounds for \code{phi}.}

\item{ub}{(optional) \code{1 x p} vector with upper bounds for \code{phi}.}
}
\description{
Draws from the posterior of the autoregressive paramteres of a stationary AR(p),
\eqn{p > 1} process without starting values.
}
\details{
The corresponding model is given by
  \eqn{Y_t = \phi_1 Y_{t-1} + ... + \phi_p Y_{t-p} + e_t}, where
  \eqn{e_t ~ N(0, \sigma)} with prior distribution \eqn{p(\phi) = N(\phi_0, 1/Q_0 )}.

The posterior draw is obtained via a Metropolis Hastings step with proposal density
  \eqn{ q = \prod_{t=p+1}^Tn p(Y_t, \phi, \sigma, Y_{t-1}, ..., Y_{t-p} )} which is
  known due to conjugacy. The acceptance probability is given by
  \eqn{ \alpha = \min{1, p(Y_1, ... Y_p | \phi_r, \sigma) / p(Y_1, ... Y_p | \phi_{r-1}, \sigma)}}
  where the subscript \eqn{r} denotes the r-th draw. \eqn{p(Y_1, ... Y_p | \phi_r, \sigma)}
  is itself normal.

Stationarity and box constraints are enforced. If the constraints
  are not fulfilled, the last draw is returned.
}
\keyword{internal}
