% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior.R
\name{initializePrior}
\alias{initializePrior}
\title{Initialization of prior distributions}
\usage{
initializePrior(model, MLE = !is.null(MLEfit), MLEfit = NULL)
}
\arguments{
\item{model}{An object of class \code{TFPmodel} or \code{NAWRUmodel}.}

\item{MLE}{(Optional) A logical indicating whether the MLE estimates should be used for
the initialization. The default is \code{MLE = FALSE} if \code{MLEfit} is not provided
and vice versa.}

\item{MLEfit}{(Optional) An object of class \code{TFPfit} or \code{NAWRUfit} which is
used if \code{MLE = TRUE}.}
}
\value{
A list of three matrices with parameters for the prior distribution and box
  constraints. Each list item refers to an equation, namely the \code{cycle}, \code{trend},
  and second observation equation. Each list element is a \code{4 x n} matrix where \code{n}
  denotes the number of parameters involved in the respective equation. The upper two
  elements specify the distribution, the lower two parameters specify box constraints.
  \code{NA} denotes no constraints. Autoregressive parameters are automatically restricted
  to the stationary region unless box constraints are specified. The respective prior
  distributions are defined through their mean and standard deviation. For instance,
  \code{prior$cycle[, 1]} contains the mean, standard deviation, lower and upper bound for
  the first variable, in that respective order.
}
\description{
Initializes the prior distributions for a model of class \code{TFPmodel} or
  \code{NAWRUmodel}.
}
