% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gap.R
\name{plot.gap}
\alias{plot.gap}
\title{Plots for a \code{gap} object}
\usage{
\method{plot}{gap}(
  x,
  contribution = FALSE,
  path = NULL,
  combine = TRUE,
  prefix = NULL,
  device = "png",
  width = 10,
  height = 3,
  ...
)
}
\arguments{
\item{x}{An object of class \code{gap}.}

\item{contribution}{A boolean indicating whether the contributions to potential output
growth and the output gap should be plotted (only applicable for production function
type output gaps).}

\item{path}{An optional file path. If specified, the plots will be saved using the format
in \code{device} under the given path.}

\item{combine}{A logical indicating whether the plots should be combined or not, the
default is \code{TRUE}.}

\item{prefix}{An optional character string to be added to the names of the plots in case
\code{path} is specified.}

\item{device}{Device passed on to \code{ggplot} for plot saving. Options are 
\code{"eps", "ps", "tex"} (pictex), \code{"pdf", "jpeg", "tiff", "png", "bmp", "svg"} 
or \code{"wmf"}.}

\item{width}{The plot width in case of printing.}

\item{height}{The plot height in case of printing.}

\item{...}{Ignored.}
}
\value{
No return value, plots are printed.
}
\description{
Plots potential output growth and the output gap based on an objects of
  class \code{gap}.
}
