% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.rgcca.R, R/summary.rgcca_cv.r,
%   R/summary.rgcca_permutation.R, R/summary.rgcca_bootstrap.r,
%   R/summary.rgcca_stability.R
\name{summary.rgcca}
\alias{summary.rgcca}
\alias{summary.rgcca_cv}
\alias{summary.rgcca_permutation}
\alias{summary.rgcca_bootstrap}
\alias{summary.rgcca_stability}
\title{Summary of a fitted object from the RGCCA package}
\usage{
\method{summary}{rgcca}(object, ...)

\method{summary}{rgcca_cv}(object, type = c("sd", "quantile"), ...)

\method{summary}{rgcca_permutation}(object, ...)

\method{summary}{rgcca_bootstrap}(
  object,
  block = seq_along(object$rgcca$call$blocks),
  comp = 1,
  type = c("weights", "loadings"),
  empirical = TRUE,
  display_order = FALSE,
  adj.method = "fdr",
  ...
)

\method{summary}{rgcca_stability}(object, ...)
}
\arguments{
\item{object}{An object to be summarized
(output of functions \code{\link{rgcca}},
\code{\link{rgcca_cv}}, \code{\link{rgcca_permutation}},
\code{\link{rgcca_bootstrap}}, or \code{\link{rgcca_stability}}).}

\item{...}{Further arguments passed to other methods
(for the displaying of matrices).}

\item{type}{A character string indicating the type of the summarized object
(see details).}

\item{block}{A numeric corresponding to the block(s) to summarize.}

\item{comp}{A numeric vector indicating the component(s) to consider.}

\item{empirical}{A logical value indicating if the bootstrap confidence
intervals and p-values are derived from the empirical distribution.
(default: TRUE)}

\item{display_order}{A logical value for ordering the variables. If TRUE,
variables are ordered from highest to lowest absolute value. If FALSE,
the block order is used. Default is TRUE.}

\item{adj.method}{A string indicating the method used to adjust the p-values.
It must be a method handled by the p.adjust function. Default is "fdr".}
}
\value{
none
}
\description{
`summary.rgcca()` summarizes a fitted RGCCA object.
Some information about the
model are displayed like model parameters or criterion.

`summary.rgcca_cv()` summarizes a fitted rgcca_cv object. Parameters of the
analysis, tuning parameters and statistics for each set of
parameters are displayed.

`summary.rgcca_permutation()` summarizes a fitted rgcca_permutation object.
Parameters of the analysis, tuning parameters and statistics for each set of
parameters are displayed.

`summary.rgcca_bootstrap()` summarizes a fitted rgcca_bootstrap object.
Parameters of the analysis and bootstrap statistics are displayed.

`summary.rgcca_stability()` calls `summary.rgcca()` on the fitted RGCCA model
returned by `rgcca_stability()`.
}
\details{
Argument type can take two values in `summary.cval`: \itemize{
\item "sd" (default): mean values of the cross-validated scores are reported,
as well as means plus or minus standard deviations.
\item "quantiles": median values, 25\% and 75\% quantiles of the
cross-validated scores are reported.
}

Argument type can take two values in `summary.bootstrap`: \itemize{
\item "weights" (default): statistics about the block-weight vectors
are reported.
\item "loadings": statistics about the block-loading vectors are reported.
}
}
\examples{
## Summary of an rgcca object
data(Russett)
blocks <- list(
  agriculture = Russett[, seq(3)],
  industry = Russett[, 4:5],
  politic = Russett[, 6:8]
)
C <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1, 0), 3, 3)
res <- rgcca(blocks,
  connection = C, ncomp = rep(2, 3), tau = c(1, 1, 1),
  scheme = "factorial", scale = TRUE, verbose = FALSE
)
summary(res)

## Summary of an rgcca_cv object
res <- rgcca_cv(blocks,
  response = 3, method = "rgcca", par_type = "tau",
  par_value = c(0, 0.2, 0.3), n_run = 1, n_cores = 1,
  verbose = TRUE
)
summary(res)

## Summary of an rgcca_permutation object
perm.out <- rgcca_permutation(blocks,
  par_type = "tau",
  n_perms = 5, n_cores = 1,
  verbose = TRUE
)
summary(perm.out)

## Summary of an rgcca_bootstrap object
fit.rgcca <- rgcca(blocks, ncomp = c(2, 1, 2))
boot.out <- rgcca_bootstrap(fit.rgcca, n_boot = 20, n_cores = 2,
                            verbose = TRUE)
summary(boot.out)

## Summary of an rgcca_stability object
fit.sgcca <- rgcca(blocks, sparsity = c(.8, .9, .6))
res <- rgcca_stability(fit.sgcca, n_boot = 10, verbose = TRUE)
summary(res)
}
