% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genLimitRasterRange.R
\name{genLimitRasterRange}
\alias{genLimitRasterRange}
\title{Limit the maximum and the minimum values of a raster}
\usage{
genLimitRasterRange(r, mx = NULL, mn = NULL, rm.values = FALSE)
}
\arguments{
\item{r}{\code{Raster*} type object.}

\item{mx}{maximun value in the \code{Raster*}.}

\item{mn}{minimun value in the \code{Raster*}.}

\item{rm.values}{logical argument. If \code{FALSE}, the \code{mx} and 
\code{mn} values are assigned to the pixels above or below the \code{mx} and 
\code{mn} thresholds respectively. If \code{TRUE}, values outside the 
\code{mn} - \code{mx} range are replaced by \code{NA}.}
}
\value{
a \code{Raster*} with values comprised within a range.
}
\description{
\code{genLimitRasterRange} limits the maximum and the minimum values of a
\code{Raster*} class object to a given range.
}
\details{
This is a generic function to limit the maximun and the minimun values in a
\code{Raster*} object.
}
\examples{
# generate random images
img <- matrix(1:16, ncol = 4, byrow = TRUE)
r <- raster(img)
# assign the limit of the data in the raster stack
r2 <- genLimitRasterRange(r, mn = 4, mx = 10)
r3 <- genLimitRasterRange(r, mn = 4, mx = 10, rm.values = TRUE)
# plot limited data
spplot(stack(r, r2 ,r3))
}
