% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genMosaicList.R
\name{genMosaicList}
\alias{genMosaicList}
\title{Mosaic a list of raster images}
\usage{
genMosaicList(imageList, fun = "max", verbose = TRUE)
}
\arguments{
\item{imageList}{\code{list} of \code{RasterLayers}.}

\item{fun}{the function being applied to pixels that overlap.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the 
running steps and warnings.}
}
\value{
a \code{raster} with the mosaicked images.
}
\description{
\code{genMosaicList} makes a single mosaic from a list of raster images.
}
\details{
This is a helper function used by other functions in this package. It combines
a list of \code{raster} images with different geolocations. If images overlap,
the function applies \code{fun} to calculate the new values for the 
overlapping pixels. If not specified, \code{fun = max}.
}
\examples{
# create simulated rasters
img <- matrix(1:16, ncol = 4, byrow = TRUE)
r1 <- raster(img)
r2 <- r1
r3 <- r1
extent(r2) <- extent(1, 2, 1, 2)
extent(r3) <- extent(1, 2, 0, 1)
imageList <- list(r1, r2, r3)
# mosaic simulated rasters
mr <- genMosaicList(imageList)
spplot(mr)
}
