% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls7FolderToVar.R
\name{ls7FolderToVar}
\alias{ls7FolderToVar}
\title{Compute a remote sensing index from a time series of Landsat-7 images}
\usage{
ls7FolderToVar(src, fun, AppRoot, getStack = FALSE, overwrite = FALSE,
  verbose = FALSE, ...)
}
\arguments{
\item{src}{the path to the folder with the Landsat-7 multispectral imagery.}

\item{fun}{a \code{function} that computes the remote sensing index.}

\item{AppRoot}{the directory of the outcoming time series.}

\item{getStack}{logical argument. If \code{TRUE}, returns the time series 
as a \code{RasterStack}, otherwise the images are saved in the Hard Drive
Device (HDD).}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the
running steps and warnings.}

\item{...}{arguments for nested functions.}
}
\value{
this function does not return anything, unless \code{getStack = TRUE}
and then it returns a \code{RasterStack} with the time series of with the
index.
}
\description{
\link{ls7FolderToVar} computes a remote sensing index from the 
spectral bands of a time series of Landsat-7 images. The images are specified
by the path to the folder that stores the imagery (resulting from the 
\code{\link{lsMosaic}} function). The function returns a \code{RasterStack}
with the time series of images with the index.
}
\details{
The function requires the definition of the \code{src} and \code{fun} 
arguments. The \code{src} is usually the path resulting from 
\code{\link{lsMosaic}}. The \code{fun} argument can be any function from this
package beginning with “var” (\code{\link{varNDVI}}, \code{\link{varEVI}}, 
etc.). Custom functions can also be implemented.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
# main output directory
src <- paste0(tempdir(),"/Path_for_downloading_folder")
print(src)
# download Landsat-7 images
lsDownload(satellite = "ls7",
           username = "username",
           password = "password",
           startDate = as.Date("01-01-2018", "\%d-\%m-\%Y"),
           endDate = as.Date("20-01-2018", "\%d-\%m-\%Y"),
           extent = ex.navarre,
           untar = TRUE,
           AppRoot = src)
# folder with the Landsat-7 untared images 
src.ls7 <-file.path(src,"Landsat7")
tif.src <- file.path(src.ls7, "untar")
# mosaic the Landsat-7 images
lsMosaic(tif.src,
         AppRoot = src.ls7,
         out.name = "Navarre",
         extent = ex.navarre,
         gutils = TRUE)
# folder with the mosaicked images
src2 <- file.path(src.ls7, "Navarre")
# generate NDVI images of Navarre
src3 <- file.path(src.ls7, "Navarre_Variables")
dir.create(src3)
ls7FolderToVar(src2,
               fun = varNDVI,
               AppRoot = src3,
               overwrite = TRUE)
               
flist <- list.files(file.path(src3,"NDVI"),
                    pattern = "\\\\.tif$",
                    full.names = TRUE,
                    recursive = TRUE)
ras <- raster(flist[1])
spplot(ras)
}
}
