% Generated by roxygen2 (4.0.1): do not edit by hand
\name{PaginateQuery}
\alias{PaginateQuery}
\title{Paginate through pages of Google Analytics Query responses

In case if a single query returns more than 10k rows,the Core Reporting API returns a subset of
the rows at a time. This function loops across all such subsets (pages) in order to retrieve data corresponding
to the entire query. The maximum number of rows corresponding to a single query that can be retrieved via Pagination
is 1 M.}
\usage{
PaginateQuery(query.builder, pages, token)
}
\arguments{
\item{query.builder}{Name of the object corresponding to the query builder class}

\item{pages}{Integer representing the number of pages across which the query has to be paginated}

\item{token}{Token Object created by \code{Auth()}}
}
\value{
list containing Column Headers and the data collated across all the pages of the query
}
\description{
Paginate through pages of Google Analytics Query responses

In case if a single query returns more than 10k rows,the Core Reporting API returns a subset of
the rows at a time. This function loops across all such subsets (pages) in order to retrieve data corresponding
to the entire query. The maximum number of rows corresponding to a single query that can be retrieved via Pagination
is 1 M.
}
\seealso{
https://developers.google.com/analytics/devguides/reporting/core/v2/gdataReferenceDataFeed#largeDataResults
}
\keyword{internal}

