/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.security.UserGroupInformation;

public class AccessControlList
implements Writable {
    public static final String WILDCARD_ACL_VALUE = "*";
    private static final int INITIAL_CAPACITY = 256;
    private Set<String> users;
    private Set<String> groups;
    private boolean allAllowed;

    public AccessControlList() {
    }

    public AccessControlList(String aclString) {
        this.buildACL(aclString);
    }

    private void buildACL(String aclString) {
        this.users = new TreeSet<String>();
        this.groups = new TreeSet<String>();
        if (aclString.contains(WILDCARD_ACL_VALUE) && aclString.trim().equals(WILDCARD_ACL_VALUE)) {
            this.allAllowed = true;
        } else {
            String[] groupsStr;
            String[] usersStr;
            this.allAllowed = false;
            String[] userGroupStrings = aclString.split(" ", 2);
            if (userGroupStrings.length >= 1 && (usersStr = userGroupStrings[0].split(",")).length >= 1) {
                AccessControlList.addToSet(this.users, usersStr);
            }
            if (userGroupStrings.length == 2 && (groupsStr = userGroupStrings[1].split(",")).length >= 1) {
                AccessControlList.addToSet(this.groups, groupsStr);
            }
        }
    }

    public boolean isAllAllowed() {
        return this.allAllowed;
    }

    public void addUser(String user) {
        this.users.add(user);
    }

    Set<String> getUsers() {
        return this.users;
    }

    Set<String> getGroups() {
        return this.groups;
    }

    public boolean isUserAllowed(UserGroupInformation ugi) {
        if (this.allAllowed || this.users.contains(ugi.getShortUserName())) {
            return true;
        }
        for (String group : ugi.getGroupNames()) {
            if (!this.groups.contains(group)) continue;
            return true;
        }
        return false;
    }

    private static final void addToSet(Set<String> set, String[] strings) {
        for (String s : strings) {
            if ((s = s.trim()).length() <= 0) continue;
            set.add(s);
        }
    }

    public String toString() {
        String str = null;
        if (this.allAllowed) {
            str = "All users are allowed";
        } else if (this.users.isEmpty() && this.groups.isEmpty()) {
            str = "No users are allowed";
        } else {
            String usersStr = null;
            String groupsStr = null;
            if (!this.users.isEmpty()) {
                usersStr = this.users.toString();
            }
            if (!this.groups.isEmpty()) {
                groupsStr = this.groups.toString();
            }
            str = !this.users.isEmpty() && !this.groups.isEmpty() ? "Users " + usersStr + " and members of the groups " + groupsStr + " are allowed" : (!this.users.isEmpty() ? "Users " + usersStr + " are allowed" : "Members of the groups " + groupsStr + " are allowed");
        }
        return str;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.getACLString());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        String aclString = Text.readString(in);
        this.buildACL(aclString);
    }

    public String getACLString() {
        StringBuilder sb = new StringBuilder(256);
        if (this.allAllowed) {
            sb.append('*');
        } else {
            sb.append(this.getUsersString());
            sb.append(" ");
            sb.append(this.getGroupsString());
        }
        return sb.toString();
    }

    private String getUsersString() {
        return this.getString(this.users);
    }

    private String getGroupsString() {
        return this.getString(this.groups);
    }

    private String getString(Set<String> strings) {
        StringBuilder sb = new StringBuilder(256);
        boolean first = true;
        for (String str : strings) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(str);
        }
        return sb.toString();
    }

    static {
        WritableFactories.setFactory(AccessControlList.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new AccessControlList();
            }
        });
    }
}

