/*
 * Decompiled with CFR 0.152.
 */
package com.nexr.rhive.hive.udf;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@Description(name="expand", value="_FUNC_(value,arg1,delim) - Returns the extended result of one column")
public class GenericUDTFExpand
extends GenericUDTF {
    DATA_TYPE data_type;
    Writable[] retRow;
    Writable[] row;
    Object[] nullRow;
    ObjectInspector[] inputOIs;
    boolean pathParsed = false;
    boolean seenErrors = false;
    String delim = ",";

    public StructObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        this.inputOIs = args;
        if (args.length < 2 || args.length > 3) {
            throw new UDFArgumentException("expand() takes 2 or 3 arguments: the origin string, data type and delim");
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].getCategory() == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentException("expand()'s arguments have to be primitive type");
        }
        this.seenErrors = false;
        this.pathParsed = false;
        this.row = new Writable[1];
        this.retRow = new Writable[1];
        this.nullRow = new Object[1];
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>();
        fieldNames.add("col");
        fieldOIs.add(this.getColumnInspector(args[1].getTypeName()));
        this.row[0] = this.getColumnWritable(args[1].getTypeName());
        this.retRow[0] = this.row[0];
        this.nullRow = null;
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    private ObjectInspector getColumnInspector(String typeName) throws IllegalArgumentException {
        if (typeName.equals("int")) {
            return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        }
        if (typeName.equals("double")) {
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }
        if (typeName.equals("string")) {
            return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        }
        throw new IllegalArgumentException("can't support this type " + typeName);
    }

    private Writable getColumnWritable(String typeName) throws IllegalArgumentException {
        if (typeName.equals("int")) {
            return new IntWritable(0);
        }
        if (typeName.equals("double")) {
            return new DoubleWritable(0.0);
        }
        if (typeName.equals("string")) {
            return new Text();
        }
        throw new IllegalArgumentException("can't support this type : " + typeName);
    }

    public void process(Object[] args) throws HiveException {
        String originStr;
        if (args[0] == null) {
            this.forward(this.nullRow);
            return;
        }
        if (!this.pathParsed) {
            String local_delim;
            if (this.inputOIs[1] instanceof StringObjectInspector) {
                this.data_type = DATA_TYPE.STRING;
            } else if (this.inputOIs[1] instanceof DoubleObjectInspector) {
                this.data_type = DATA_TYPE.DOUBLE;
            } else if (this.inputOIs[1] instanceof IntObjectInspector) {
                this.data_type = DATA_TYPE.INT;
            } else {
                this.data_type = DATA_TYPE.NULLNAME;
                throw new HiveException("we don't know this type... " + this.inputOIs[1]);
            }
            if (args.length == 3 && (local_delim = ((StringObjectInspector)this.inputOIs[2]).getPrimitiveJavaObject(args[args.length - 1])) != null && !local_delim.equals("")) {
                this.delim = local_delim;
            }
            this.pathParsed = true;
        }
        if ((originStr = ((StringObjectInspector)this.inputOIs[0]).getPrimitiveJavaObject(args[0])) == null) {
            this.forward(this.nullRow);
            return;
        }
        try {
            String[] originStrs = this.parseString(originStr, this.delim);
            for (int i = 0; i < originStrs.length; ++i) {
                if (originStrs[i] == null) {
                    this.retRow[0] = this.row[0];
                } else {
                    switch (this.data_type) {
                        case STRING: {
                            ((Text)this.retRow[0]).set(originStrs[i]);
                            break;
                        }
                        case DOUBLE: {
                            ((DoubleWritable)this.retRow[0]).set(Double.parseDouble(originStrs[i]));
                            break;
                        }
                        case INT: {
                            ((IntWritable)this.retRow[0]).set((int)Double.parseDouble(originStrs[i]));
                            break;
                        }
                        default: {
                            this.retRow = this.row;
                        }
                    }
                }
                this.forward(this.retRow);
            }
            return;
        }
        catch (Exception e) {
            if (!this.seenErrors) {
                this.seenErrors = true;
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(output));
            throw new HiveException(new String(output.toByteArray()));
        }
    }

    public String toString() {
        return "expand";
    }

    public void close() throws HiveException {
    }

    private String[] parseString(String originStr, String delim) {
        StringTokenizer st = new StringTokenizer(originStr, delim);
        ArrayList<String> strs = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            strs.add(st.nextToken());
        }
        return strs.toArray(new String[0]);
    }

    static enum DATA_TYPE {
        STRING,
        DOUBLE,
        INT,
        NUMERIC,
        NULLNAME;

    }
}

