/*
 * Decompiled with CFR 0.152.
 */
package com.nexr.rhive.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;

public class JobManager {
    private String user = System.getProperty("user.name");

    public List<JobStatus> listJobs(boolean all) throws IOException {
        JobClient jobClient = new JobClient(new JobConf());
        ArrayList<JobStatus> list = new ArrayList<JobStatus>();
        JobStatus[] jobs = null;
        jobs = all ? jobClient.getAllJobs() : jobClient.jobsToComplete();
        ClusterStatus clusterStatus = jobClient.getClusterStatus();
        clusterStatus.getUsedMemory();
        if (jobs != null) {
            for (JobStatus jobStatus : jobs) {
                if (!this.user.equals(jobStatus.getUsername())) continue;
                list.add(jobStatus);
                JobID jobID = jobStatus.getJobID();
                RunningJob job = jobClient.getJob(jobID);
                String jobName = job.getJobName();
            }
        }
        return list;
    }

    public boolean kill(String id) throws IOException {
        JobClient jobClient = new JobClient(new JobConf());
        JobID jobID = JobID.forName((String)id);
        RunningJob job = jobClient.getJob(jobID);
        if (job == null) {
            return false;
        }
        job.killJob();
        return true;
    }
}

