% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glcm_all.R
\encoding{UTF-8}
\name{glcm_all}
\alias{glcm_all}
\title{Creates gray-level co-occurrence matrix of all possible directions of a RIA image}
\usage{
glcm_all(RIA_data_in, distance = 1, symmetric = TRUE, normalize = TRUE,
  use_type = "discretized", use_orig = FALSE, use_slot = NULL,
  save_name = NULL, verbose_in = TRUE)
}
\arguments{
\item{RIA_data_in}{\emph{RIA_image}, created by \code{\link[RIA]{load_dicom}}.}

\item{distance}{integer, distance between the voxels being compared.}

\item{symmetric}{logical, indicating whether to create a symmetric glcm
by also calculating the glcm in the opposite direction and add it to the glcm.}

\item{normalize}{logical, indicating whether to change glcm elements to relaive frequencies.}

\item{use_type}{string, can be \emph{"single"} which runs the function on a single image,
which is determined using \emph{"use_orig"} or \emph{"use_slot"}. \emph{"discretized"}
takes all datasets in the \emph{RIA_image$discretized} slot and runs the analysis on them.}

\item{use_orig}{logical, indicating to use image present in \emph{RIA_data$orig}.
If FALSE, the modified image will be used stored in \emph{RIA_data$modif}.}

\item{use_slot}{string, name of slot where data wished to be used is. Use if the desired image
is not in the \emph{data$orig} or \emph{data$modif} slot of the \emph{RIA_image}. For example,
if the desired dataset is in \emph{RIA_image$discretized$ep_4}, then \emph{use_slot} should be
\emph{discretized$ep_4}. The results are automatically saved. If the results are not saved to
the desired slot, then please use \emph{save_name} parameter.}

\item{save_name}{string, indicating the name of subslot of \emph{$glcm} to save results to.
If left empty, then it will be automatically determined by RIA.}

\item{verbose_in}{logical indicating whether to print detailed information.
Most prints can also be suppressed using the \code{\link{suppressMessages}} function.}
}
\value{
\emph{RIA_image} containing the GLCMs.
}
\description{
Creates gray-level co-occurrence matrix (GLCM) from \emph{RIA_image}.
GLCM assesses the spatial relation of voxels to each other. While the \code{\link[RIA]{glcm}}
function calculates the GLCM in one given direction, the \code{\link[RIA]{glcm_all}} function
simultaneously calculates all GLCMs in all possible directions. 
For 3D datasets, this means GLCMs will be calculated for all 26 different directions.
However, due to symmetry overall only 13 different GLCMs will be generated.
If the \emph{symmetric} parameter is set to \emph{FALSE}, then 26 non-symmetrical GLCM matrices
will be returned.
In case of 2D datasets, instead of 8 GLCMs, only 4 are returned by default. If the \emph{symmetric}
parameter is set to \emph{FALSE} then all 8 non-symmetrical GLCM matrices are returned.
For detailes see: \url{https://www.ncbi.nlm.nih.gov/pubmed/28346329}
By default the \emph{use_type} is set to \emph{discretize}, therefore GLCMs will be calculated
for all discretized images in all directions. Also \emph{single} data processing is supported, 
then by default the image in the \emph{$modif} slot will be used. If \emph{use_slot} is given,
then the data present in \emph{RIA_image$use_slot} will be used for calculations.
Results will be saved into the \emph{glcm} slot. The name of the subslot is automatically
generated by RIA.
}
\examples{
\dontrun{
#Discretize loaded image and then calculate GLCM matrix of RIA_image$modif
RIA_image <- discretize(RIA_image, bins_in = c(4, 8), equal_prob = TRUE,
use_orig = TRUE, write_orig = FALSE)
RIA_image <- glcm_all(RIA_image, use_type = "single")

#Use use_slot parameter to set which image to use
RIA_image <- glcm_all(RIA_image, use_type = "single",
use_orig = FALSE, use_slot = "discretized$ep_4")

#Batch calculation of GLCM matrices on all disretized images at a distance of 1 and 2
RIA_image <- glcm_all(RIA_image, use_type = "discretized", distance = c(1:2))
}

}
\references{
Márton KOLOSSVÁRY et al.
Radiomic Features Are Superior to Conventional Quantitative Computed Tomographic
Metrics to Identify Coronary Plaques With Napkin-Ring Sign
Circulation: Cardiovascular Imaging (2017).
DOI: 10.1161/circimaging.117.006843
\url{http://circimaging.ahajournals.org/content/10/12/e006843}

Márton KOLOSSVÁRY et al.
Cardiac Computed Tomography Radiomics: A Comprehensive Review on Radiomic Techniques.
Journal of Thoracic Imaging (2017).
DOI: 10.1097/RTI.0000000000000268
\url{https://www.ncbi.nlm.nih.gov/pubmed/28346329}
}
