% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RIGHT.R
\name{RIGHT}
\alias{RIGHT}
\title{Entry Function for RIGHT}
\usage{
RIGHT(expr = { }, ..., title = "RIGHT: R Interactive Graphics via HTml",
  ncol = NULL, dir = tempfile(), overwrite = FALSE,
  browser = getOption("browser"), supportRIGHT = getOption("supportRIGHT"))
}
\arguments{
\item{expr}{plotting expression to evaluate}

\item{...}{data.frame objects used in \code{expr}. If they are used in one of the plotting functions, it is not necessary to list them.}

\item{title}{title of the visualization. The default value is "RIGHT: R Interactive Graphics via HTml."}

\item{ncol}{support improved layout to group related plots together}

\item{dir}{directory name to store files used for the visualization. Temporary directory is created under the current working directory by default.}

\item{overwrite}{rewrite exiting files if the directory name matches. FALSE by default.}

\item{browser}{a character string giving the name of the browser. It should be in the PATH, or a full path specified. getOption("browser") by default.}

\item{supportRIGHT}{allow inserting Google AdSense to support further development of RIGHT. Use \code{\link{options}} and \code{\link{getOption}} to set and retrieve global option supportRIGHT.}
}
\description{
Entry Function for RIGHT
}
\examples{
{
       RIGHT({plot(conc ~ Time, Theoph, type = "p", color = "Subject")
       lines(conc ~ Time, Theoph, by="Subject")
       hist(Wt, Theoph)
       boxplot(conc ~ Time, Theoph)
       pie(Subject, Theoph)
       search(Theoph)
       table(Theoph)})
}
}

