% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gz_functions.R
\name{gz_functions}
\alias{gz_functions}
\alias{gunzip_file}
\alias{gzip_file}
\title{Compresses and uncompresses files to and from gz-archives}
\usage{
gunzip_file(
  infile,
  outfile = gsub("\\\\.gz$", "", infile),
  buffer_size = min(4 * file.size(infile), 2e+09)
)

gzip_file(
  infile,
  outfile = NA,
  buffer_size = min(4 * file.size(infile), 2e+09)
)
}
\arguments{
\item{infile}{the file to be zipped or unzipped}

\item{outfile}{the resulting zipped or unzipped file}

\item{buffer_size}{the size of the buffer to read in at once, default is 4 times the file.size (max 2Gb).}
}
\value{
The filename of the unzipped file, invisibly
}
\description{
Allows the compression and uncompression of files
}
\details{
Functions are

\itemize{
\item \code{gunzip_file}: uncompresses a gz-archive to raw binary data
}

-\code{gzip_file}: compresses a raw binary data file to a gz-archive
}
\examples{
gzfile <- system.file("extdata", "ex20101224.TEST_ITCH_50.gz", package = "RITCH")
file   <- system.file("extdata", "ex20101224.TEST_ITCH_50", package = "RITCH")

# uncompress file
(outfile <- gunzip_file(gzfile, "tmp"))
file.info(outfile)
unlink(outfile)

# compress file
(outfile <- gzip_file(file))
file.info(outfile)
unlink(outfile)
}
