/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import ij.process.FHT;
import ij.process.ImageProcessor;

public class Undo {
    public static final int NOTHING = 0;
    public static final int FILTER = 1;
    public static final int TYPE_CONVERSION = 2;
    public static final int PASTE = 3;
    public static final int COMPOUND_FILTER = 4;
    public static final int COMPOUND_FILTER_DONE = 5;
    public static final int TRANSFORM = 6;
    private static int whatToUndo = 0;
    private static int imageID;
    private static ImageProcessor ipCopy;
    private static ImagePlus impCopy;

    public static void setup(int what, ImagePlus imp) {
        if (imp == null) {
            whatToUndo = 0;
            Undo.reset();
            return;
        }
        if (what == 1 && whatToUndo == 4) {
            return;
        }
        if (what == 5) {
            if (whatToUndo == 4) {
                whatToUndo = what;
            }
            return;
        }
        whatToUndo = what;
        imageID = imp.getID();
        if (what == 2) {
            ipCopy = imp.getProcessor();
        } else if (what == 6) {
            impCopy = new ImagePlus(imp.getTitle(), imp.getProcessor().duplicate());
            Object fht = imp.getProperty("FHT");
            if (fht != null) {
                fht = new FHT((ImageProcessor)fht);
                impCopy.setProperty("FHT", fht);
            }
        } else {
            ImageProcessor ip;
            ipCopy = what == 4 ? ((ip = imp.getProcessor()) != null ? ip.duplicate() : null) : null;
        }
    }

    public static void reset() {
        if (whatToUndo == 4) {
            return;
        }
        whatToUndo = 0;
        imageID = 0;
        ipCopy = null;
        impCopy = null;
    }

    public static void undo() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imageID != imp.getID()) {
            Undo.reset();
            return;
        }
        switch (whatToUndo) {
            case 1: {
                ImageProcessor ip = imp.getProcessor();
                if (ip == null) break;
                ip.reset();
                imp.updateAndDraw();
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                if (ipCopy == null) break;
                imp.setProcessor(null, ipCopy);
                break;
            }
            case 6: {
                if (impCopy == null) break;
                imp.setProcessor(impCopy.getTitle(), impCopy.getProcessor());
                Object fht = impCopy.getProperty("FHT");
                if (fht != null) {
                    imp.setProperty("FHT", fht);
                    break;
                }
                if (imp.getProperty("FHT") == null) break;
                imp.getProperties().remove("FHT");
                break;
            }
            case 3: {
                Roi roi = imp.getRoi();
                if (roi == null) break;
                roi.abortPaste();
            }
        }
        Undo.reset();
    }

    static {
        ipCopy = null;
    }
}

