/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.util.Properties;

public class NewImage {
    public static final int GRAY8 = 0;
    public static final int GRAY16 = 1;
    public static final int GRAY32 = 2;
    public static final int RGB = 3;
    public static final int FILL_BLACK = 1;
    public static final int FILL_RAMP = 2;
    public static final int FILL_WHITE = 4;
    public static final int CHECK_AVAILABLE_MEMORY = 8;
    private static final int OLD_FILL_WHITE = 0;
    static final String NAME = "new.name";
    static final String TYPE = "new.type";
    static final String FILL = "new.fill";
    static final String WIDTH = "new.width";
    static final String HEIGHT = "new.height";
    static final String SLICES = "new.slices";
    private static String name = Prefs.getString("new.name", "Untitled");
    private static int width = Prefs.getInt("new.width", 400);
    private static int height = Prefs.getInt("new.height", 400);
    private static int slices = Prefs.getInt("new.slices", 1);
    private static int type = Prefs.getInt("new.type", 0);
    private static int fillWith = Prefs.getInt("new.fill", 0);
    private static String[] types = new String[]{"8-bit", "16-bit", "32-bit", "RGB"};
    private static String[] fill = new String[]{"White", "Black", "Ramp"};

    public NewImage() {
        this.openImage();
    }

    static boolean createStack(ImagePlus imp, ImageProcessor ip, int nSlices, int type, int options) {
        long inUse;
        long available;
        long max;
        int fill = NewImage.getFill(options);
        int width = imp.getWidth();
        int height = imp.getHeight();
        long bytesPerPixel = 1L;
        if (type == 1) {
            bytesPerPixel = 2L;
        } else if (type == 2 || type == 3) {
            bytesPerPixel = 4L;
        }
        long size = (long)width * (long)height * (long)nSlices * bytesPerPixel;
        String size2 = size / 0x100000L + "MB (" + width + "x" + height + "x" + nSlices + ")";
        if ((options & 8) != 0 && (max = IJ.maxMemory()) > 0L && size > (available = max - (inUse = IJ.currentMemory()))) {
            System.gc();
            IJ.error("Out of Memory", "There is not enough free memory to allocate a \n" + size2 + " stack.\n \n" + "Memory available: " + available / 0x100000L + "MB\n" + "Memory in use: " + IJ.freeMemory() + "\n \n" + "More information can be found in the \"Memory\"\n" + "sections of the ImageJ installation notes at\n" + "\"" + "http://rsb.info.nih.gov/ij" + "/docs/install/\".");
            return false;
        }
        ImageStack stack = imp.createEmptyStack();
        int inc = nSlices / 40;
        if (inc < 1) {
            inc = 1;
        }
        IJ.showStatus("Allocating " + size2 + ". Press 'Esc' to abort.");
        IJ.resetEscape();
        try {
            stack.addSlice(null, ip);
            for (int i = 2; i <= nSlices; ++i) {
                if (i % inc == 0) {
                    IJ.showProgress(i, nSlices);
                }
                Object[] pixels2 = null;
                switch (type) {
                    case 0: {
                        pixels2 = new byte[width * height];
                        break;
                    }
                    case 1: {
                        pixels2 = new short[width * height];
                        break;
                    }
                    case 2: {
                        pixels2 = new float[width * height];
                        break;
                    }
                    case 3: {
                        pixels2 = new int[width * height];
                    }
                }
                if (fill != 1 || type == 3) {
                    System.arraycopy(ip.getPixels(), 0, pixels2, 0, width * height);
                }
                stack.addSlice(null, pixels2);
                if (!IJ.escapePressed()) continue;
                IJ.beep();
                break;
            }
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory(imp.getTitle());
            stack.trim();
        }
        IJ.showProgress(nSlices, nSlices);
        if (stack.getSize() > 1) {
            imp.setStack(null, stack);
        }
        return true;
    }

    static ImagePlus createImagePlus() {
        return new ImagePlus();
    }

    static int getFill(int options) {
        int fill = options & 7;
        if (fill == 0) {
            fill = 4;
        }
        if (fill == 7 || fill == 6 || fill == 3 || fill == 5) {
            fill = 1;
        }
        return fill;
    }

    public static ImagePlus createByteImage(String title, int width, int height, int slices, int options) {
        boolean ok;
        int fill = NewImage.getFill(options);
        byte[] pixels = new byte[width * height];
        switch (fill) {
            case 4: {
                for (int i = 0; i < width * height; ++i) {
                    pixels[i] = -1;
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                byte[] ramp = new byte[width];
                for (int i = 0; i < width; ++i) {
                    ramp[i] = (byte)((double)i * 256.0 / (double)width);
                }
                for (int y = 0; y < height; ++y) {
                    int offset = y * width;
                    for (int x = 0; x < width; ++x) {
                        pixels[offset++] = ramp[x];
                    }
                }
                break;
            }
        }
        ByteProcessor ip = new ByteProcessor(width, height, pixels, null);
        ImagePlus imp = NewImage.createImagePlus();
        imp.setProcessor(title, ip);
        if (slices > 1 && !(ok = NewImage.createStack(imp, ip, slices, 0, options))) {
            imp = null;
        }
        return imp;
    }

    public static ImagePlus createRGBImage(String title, int width, int height, int slices, int options) {
        boolean ok;
        int fill = NewImage.getFill(options);
        int[] pixels = new int[width * height];
        switch (fill) {
            case 4: {
                int i;
                for (i = 0; i < width * height; ++i) {
                    pixels[i] = -1;
                }
                break;
            }
            case 1: {
                int i;
                for (i = 0; i < width * height; ++i) {
                    pixels[i] = -16777216;
                }
                break;
            }
            case 2: {
                int[] ramp = new int[width];
                for (int i = 0; i < width; ++i) {
                    byte b;
                    byte g = b = (byte)((double)i * 256.0 / (double)width);
                    byte r = b;
                    ramp[i] = 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
                }
                for (int y = 0; y < height; ++y) {
                    int offset = y * width;
                    for (int x = 0; x < width; ++x) {
                        pixels[offset++] = ramp[x];
                    }
                }
                break;
            }
        }
        ColorProcessor ip = new ColorProcessor(width, height, pixels);
        ImagePlus imp = NewImage.createImagePlus();
        imp.setProcessor(title, ip);
        if (slices > 1 && !(ok = NewImage.createStack(imp, ip, slices, 3, options))) {
            imp = null;
        }
        return imp;
    }

    public static ImagePlus createShortImage(String title, int width, int height, int slices, int options) {
        boolean ok;
        int fill = NewImage.getFill(options);
        short[] pixels = new short[width * height];
        switch (fill) {
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                short[] ramp = new short[width];
                for (int i = 0; i < width; ++i) {
                    ramp[i] = (short)((double)i * 65536.0 / (double)width + 0.5);
                }
                for (int y = 0; y < height; ++y) {
                    int offset = y * width;
                    for (int x = 0; x < width; ++x) {
                        pixels[offset++] = ramp[x];
                    }
                }
                break;
            }
        }
        ShortProcessor ip = new ShortProcessor(width, height, pixels, null);
        if (fill == 4) {
            ip.invertLut();
        }
        ImagePlus imp = NewImage.createImagePlus();
        imp.setProcessor(title, ip);
        if (slices > 1 && !(ok = NewImage.createStack(imp, ip, slices, 1, options))) {
            imp = null;
        }
        imp.getProcessor().setMinAndMax(0.0, 65535.0);
        return imp;
    }

    public static ImagePlus createUnsignedShortImage(String title, int width, int height, int slices, int options) {
        return NewImage.createShortImage(title, width, height, slices, options);
    }

    public static ImagePlus createFloatImage(String title, int width, int height, int slices, int options) {
        boolean ok;
        int fill = NewImage.getFill(options);
        float[] pixels = new float[width * height];
        switch (fill) {
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                float[] ramp = new float[width];
                for (int i = 0; i < width; ++i) {
                    ramp[i] = (float)((double)i * 1.0 / (double)width);
                }
                for (int y = 0; y < height; ++y) {
                    int offset = y * width;
                    for (int x = 0; x < width; ++x) {
                        pixels[offset++] = ramp[x];
                    }
                }
                break;
            }
        }
        FloatProcessor ip = new FloatProcessor(width, height, pixels, null);
        if (fill == 4) {
            ip.invertLut();
        }
        ImagePlus imp = NewImage.createImagePlus();
        imp.setProcessor(title, ip);
        if (slices > 1 && !(ok = NewImage.createStack(imp, ip, slices, 2, options))) {
            imp = null;
        }
        imp.getProcessor().setMinAndMax(0.0, 1.0);
        return imp;
    }

    public static void open(String title, int width, int height, int nSlices, int type, int options) {
        int bitDepth = 8;
        if (type == 1) {
            bitDepth = 16;
        } else if (type == 2) {
            bitDepth = 32;
        } else if (type == 3) {
            bitDepth = 24;
        }
        long startTime = System.currentTimeMillis();
        ImagePlus imp = NewImage.createImage(title, width, height, nSlices, bitDepth, options);
        if (imp != null) {
            WindowManager.checkForDuplicateName = true;
            imp.show();
            IJ.showStatus(IJ.d2s((double)(System.currentTimeMillis() - startTime) / 1000.0, 2) + " seconds");
        }
    }

    public static ImagePlus createImage(String title, int width, int height, int nSlices, int bitDepth, int options) {
        ImagePlus imp = null;
        switch (bitDepth) {
            case 8: {
                imp = NewImage.createByteImage(title, width, height, nSlices, options);
                break;
            }
            case 16: {
                imp = NewImage.createShortImage(title, width, height, nSlices, options);
                break;
            }
            case 32: {
                imp = NewImage.createFloatImage(title, width, height, nSlices, options);
                break;
            }
            case 24: {
                imp = NewImage.createRGBImage(title, width, height, nSlices, options);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid bitDepth: " + bitDepth);
            }
        }
        return imp;
    }

    boolean showDialog() {
        if (type < 0 || type > 3) {
            type = 0;
        }
        if (fillWith < 0 || fillWith > 2) {
            fillWith = 0;
        }
        GenericDialog gd = new GenericDialog("New Image...", IJ.getInstance());
        gd.addStringField("Name:", name, 12);
        gd.addChoice("Type:", types, types[type]);
        gd.addChoice("Fill With:", fill, fill[fillWith]);
        gd.addNumericField("Width:", width, 0, 5, "pixels");
        gd.addNumericField("Height:", height, 0, 5, "pixels");
        gd.addNumericField("Slices:", slices, 0, 5, "");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        name = gd.getNextString();
        String s = gd.getNextChoice();
        type = s.startsWith("8") ? 0 : (s.startsWith("16") ? 1 : (s.endsWith("RGB") || s.endsWith("rgb") ? 3 : 2));
        fillWith = gd.getNextChoiceIndex();
        width = (int)gd.getNextNumber();
        height = (int)gd.getNextNumber();
        slices = (int)gd.getNextNumber();
        return true;
    }

    void openImage() {
        if (!this.showDialog()) {
            return;
        }
        try {
            NewImage.open(name, width, height, slices, type, fillWith);
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory("New Image...");
        }
    }

    public static void savePreferences(Properties prefs) {
        prefs.put(NAME, name);
        prefs.put(TYPE, Integer.toString(type));
        prefs.put(FILL, Integer.toString(fillWith));
        prefs.put(WIDTH, Integer.toString(width));
        prefs.put(HEIGHT, Integer.toString(height));
        prefs.put(SLICES, Integer.toString(slices));
    }
}

