/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.gui.Toolbar;

public class FreehandRoi
extends PolygonRoi {
    public FreehandRoi(int n, int n2, ImagePlus imagePlus) {
        super(n, n2, imagePlus);
        this.type = Toolbar.getToolId() == 3 ? 3 : 7;
        if (this.nPoints == 2) {
            --this.nPoints;
        }
    }

    protected void grow(int n, int n2) {
        int n3 = this.ic.offScreenX(n);
        int n4 = this.ic.offScreenY(n2);
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n3 > this.xMax) {
            n3 = this.xMax;
        }
        if (n4 > this.yMax) {
            n4 = this.yMax;
        }
        if (n3 != this.xp[this.nPoints - 1] + this.x || n4 != this.yp[this.nPoints - 1] + this.y) {
            this.xp[this.nPoints] = n3 - this.x;
            this.yp[this.nPoints] = n4 - this.y;
            ++this.nPoints;
            if (this.nPoints == this.xp.length) {
                this.enlargeArrays();
            }
            this.drawLine();
        }
    }

    void drawLine() {
        double d;
        int n = this.xp[this.nPoints - 2] + this.x;
        int n2 = this.yp[this.nPoints - 2] + this.y;
        int n3 = this.xp[this.nPoints - 1] + this.x;
        int n4 = this.yp[this.nPoints - 1] + this.y;
        int n5 = Math.min(n, n3);
        int n6 = Math.max(n, n3);
        int n7 = Math.min(n2, n4);
        int n8 = Math.max(n2, n4);
        int n9 = 4;
        if (lineWidth > n9 && this.isLine()) {
            n9 = lineWidth;
        }
        if (this.ic != null && (d = this.ic.getMagnification()) < 1.0) {
            n9 = (int)((double)n9 / d);
        }
        this.imp.draw(n5 - n9, n7 - n9, n6 - n5 + n9 * 2, n8 - n7 + n9 * 2);
    }

    protected void handleMouseUp(int n, int n2) {
        if (this.state == 0) {
            this.addOffset();
            this.finishPolygon();
        }
        this.state = 3;
    }
}

