/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import ij.util.Tools;

public class DICOM_Sorter
implements PlugIn {
    static final int MAX_DIGITS = 5;

    public void run(String string) {
        ImagePlus imagePlus = IJ.getImage();
        if (!this.isDicomStack(imagePlus)) {
            IJ.showMessage("DICOM Sorter", "This command requires a DICOM stack");
            return;
        }
        int n = imagePlus.getStackSize();
        ImageStack imageStack = imagePlus.getStack();
        String[] stringArray = this.getSortStrings(imageStack, "0020,0013");
        if (stringArray == null) {
            return;
        }
        StringSorter.sort(stringArray);
        ImageStack imageStack2 = this.sortStack(imageStack, stringArray);
        if (imageStack2 != null) {
            imagePlus.setStack(null, imageStack2);
        }
    }

    public ImageStack sort(ImageStack imageStack) {
        if (IJ.debugMode) {
            IJ.log("DICOM_Sorter: sorting by image number");
        }
        if (imageStack.getSize() == 1) {
            return imageStack;
        }
        String[] stringArray = this.getSortStrings(imageStack, "0020,0013");
        if (stringArray == null) {
            return imageStack;
        }
        StringSorter.sort(stringArray);
        ImageStack imageStack2 = this.sortStack(imageStack, stringArray);
        return imageStack2 != null ? imageStack2 : imageStack;
    }

    ImageStack sortStack(ImageStack imageStack, String[] stringArray) {
        ImageProcessor imageProcessor = imageStack.getProcessor(1);
        ImageStack imageStack2 = new ImageStack(imageProcessor.getWidth(), imageProcessor.getHeight(), imageProcessor.getColorModel());
        for (int i = 0; i < imageStack.getSize(); ++i) {
            int n = (int)Tools.parseDouble(stringArray[i].substring(stringArray[i].length() - 5), 0.0);
            if (n == 0) {
                return null;
            }
            imageStack2.addSlice(imageStack.getSliceLabel(n), imageStack.getPixels(n));
        }
        imageStack2.update(imageStack.getProcessor(1));
        return imageStack2;
    }

    String[] getSortStrings(ImageStack imageStack, String string) {
        double d = this.getSeriesNumber(imageStack.getSliceLabel(1));
        int n = imageStack.getSize();
        String[] stringArray = new String[n];
        for (int i = 1; i <= n; ++i) {
            String string2 = imageStack.getSliceLabel(i);
            if (string2 == null) {
                return null;
            }
            double d2 = this.getNumericTag(string2, string);
            if (Double.isNaN(d2)) {
                if (IJ.debugMode) {
                    IJ.log("  " + string + "  tag missing in slice " + i);
                }
                return null;
            }
            if (this.getSeriesNumber(string2) != d) {
                if (IJ.debugMode) {
                    IJ.log("  all slices must be part of the same series");
                }
                return null;
            }
            stringArray[i - 1] = this.toString(d2, 5) + this.toString(i, 5);
        }
        return stringArray;
    }

    String toString(double d, int n) {
        String string = "       " + IJ.d2s(d, 0);
        return string.substring(string.length() - 5);
    }

    boolean isDicomStack(ImagePlus imagePlus) {
        if (imagePlus.getStackSize() == 1) {
            return false;
        }
        ImageStack imageStack = imagePlus.getStack();
        String string = imageStack.getSliceLabel(1);
        return string != null && string.lastIndexOf("7FE0,0010") > 0;
    }

    double getSeriesNumber(String string) {
        double d = this.getNumericTag(string, "0020,0011");
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        return d;
    }

    double getNumericTag(String string, String string2) {
        String string3 = this.getTag(string, string2);
        if (string3.equals("")) {
            return Double.NaN;
        }
        int n = string3.indexOf("\\");
        if (n > 0) {
            string3 = string3.substring(0, n);
        }
        return Tools.parseDouble(string3);
    }

    String getTag(String string, String string2) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return "";
        }
        if (string.charAt(n + 11) == '>' && (n = string.indexOf(string2, n + 10)) == -1) {
            return "";
        }
        if ((n = string.indexOf(":", n)) == -1) {
            return "";
        }
        int n2 = string.indexOf("\n", n);
        String string3 = string.substring(n + 1, n2);
        return string3;
    }
}

