/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.FHT;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class FFTMath
implements PlugIn {
    private static final int CONJUGATE_MULTIPLY = 0;
    private static final int MULTIPLY = 1;
    private static final int DIVIDE = 2;
    private static String[] ops = new String[]{"Correlate", "Convolve", "Deconvolve"};
    private static int index1;
    private static int index2;
    private static int operation;
    private static boolean doInverse;
    private static String title;
    private ImagePlus imp1;
    private ImagePlus imp2;

    public void run(String string) {
        if (this.showDialog()) {
            this.doMath(this.imp1, this.imp2);
        }
    }

    public boolean showDialog() {
        Object object;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.noImage();
            return false;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            object = WindowManager.getImage(nArray[i]);
            stringArray[i] = object != null ? ((ImagePlus)object).getTitle() : "";
        }
        if (index1 >= stringArray.length) {
            index1 = 0;
        }
        if (index2 >= stringArray.length) {
            index2 = 0;
        }
        GenericDialog genericDialog = new GenericDialog("FFT Math");
        genericDialog.addChoice("Image1: ", stringArray, stringArray[index1]);
        genericDialog.addChoice("Operation:", ops, ops[operation]);
        genericDialog.addChoice("Image2: ", stringArray, stringArray[index2]);
        genericDialog.addStringField("Result:", title);
        genericDialog.addCheckbox("Do inverse transform", doInverse);
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#fft-math");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        index1 = genericDialog.getNextChoiceIndex();
        operation = genericDialog.getNextChoiceIndex();
        index2 = genericDialog.getNextChoiceIndex();
        title = genericDialog.getNextString();
        doInverse = genericDialog.getNextBoolean();
        object = stringArray[index1];
        String string = stringArray[index2];
        this.imp1 = WindowManager.getImage(nArray[index1]);
        this.imp2 = WindowManager.getImage(nArray[index2]);
        return true;
    }

    public void doMath(ImagePlus imagePlus, ImagePlus imagePlus2) {
        ImageProcessor imageProcessor;
        FHT fHT;
        FHT fHT2 = null;
        ImageProcessor imageProcessor2 = (ImageProcessor)imagePlus.getProperty("FHT");
        if (imageProcessor2 != null) {
            fHT = new FHT(imageProcessor2);
        } else {
            IJ.showStatus("Converting to float");
            imageProcessor = imagePlus.getProcessor();
            fHT = new FHT(imageProcessor);
        }
        ImageProcessor imageProcessor3 = (ImageProcessor)imagePlus2.getProperty("FHT");
        if (imageProcessor3 != null) {
            fHT2 = new FHT(imageProcessor3);
        } else {
            imageProcessor = imagePlus2.getProcessor();
            if (imagePlus2 != imagePlus) {
                fHT2 = new FHT(imageProcessor);
            }
        }
        if (!fHT.powerOf2Size()) {
            IJ.error("FFT Math", "Images must be a power of 2 size (256x256, 512x512, etc.)");
            return;
        }
        if (imagePlus.getWidth() != imagePlus2.getWidth()) {
            IJ.error("FFT Math", "Images must be the same size");
            return;
        }
        if (imageProcessor2 == null) {
            IJ.showStatus("Transform image1");
            fHT.transform();
        }
        if (imageProcessor3 == null) {
            if (fHT2 == null) {
                fHT2 = new FHT(fHT.duplicate());
            } else {
                IJ.showStatus("Transform image2");
                fHT2.transform();
            }
        }
        imageProcessor = null;
        switch (operation) {
            case 0: {
                IJ.showStatus("Complex conjugate multiply");
                imageProcessor = fHT.conjugateMultiply(fHT2);
                break;
            }
            case 1: {
                IJ.showStatus("Fourier domain multiply");
                imageProcessor = fHT.multiply(fHT2);
                break;
            }
            case 2: {
                IJ.showStatus("Fourier domain divide");
                imageProcessor = fHT.divide(fHT2);
            }
        }
        if (doInverse) {
            IJ.showStatus("Inverse transform");
            ((FHT)imageProcessor).inverseTransform();
            IJ.showStatus("Swap quadrants");
            ((FHT)imageProcessor).swapQuadrants();
            IJ.showStatus("Display image");
            ((FloatProcessor)imageProcessor).resetMinAndMax();
            new ImagePlus(title, imageProcessor).show();
        } else {
            IJ.showStatus("Power spectrum");
            ImageProcessor imageProcessor4 = ((FHT)imageProcessor).getPowerSpectrum();
            ImagePlus imagePlus3 = new ImagePlus(title, imageProcessor4.convertToFloat());
            ((FHT)imageProcessor).quadrantSwapNeeded = true;
            imagePlus3.setProperty("FHT", imageProcessor);
            imagePlus3.show();
        }
        IJ.showProgress(1.0);
    }

    static {
        operation = 0;
        doInverse = true;
        title = "Result";
    }
}

