/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.text.TextWindow;

public class NewPlugin
implements PlugIn {
    public static final int MACRO = 0;
    public static final int JAVASCRIPT = 1;
    public static final int PLUGIN = 2;
    public static final int PLUGIN_FILTER = 3;
    public static final int PLUGIN_FRAME = 4;
    public static final int TEXT_FILE = 5;
    public static final int TABLE = 6;
    private static int rows = 16;
    private static int columns = 60;
    private static int tableWidth = 350;
    private static int tableHeight = 250;
    private int type = 0;
    private String name = "Macro.ijm";
    private boolean monospaced;
    private boolean menuBar = true;
    private Editor ed;

    public void run(String string) {
        this.type = -1;
        if (string.startsWith("text") || string.equals("")) {
            this.type = 5;
            this.name = "Untitled.txt";
        } else if (string.equals("macro")) {
            this.type = 0;
            this.name = "Macro.ijm";
        } else if (string.equals("javascript")) {
            this.type = 1;
            this.name = "Script.js";
        } else if (string.equals("plugin")) {
            this.type = 2;
            this.name = "My_Plugin.java";
        } else if (string.equals("frame")) {
            this.type = 4;
            this.name = "Plugin_Frame.java";
        } else if (string.equals("filter")) {
            this.type = 3;
            this.name = "Filter_Plugin.java";
        } else if (string.equals("table")) {
            String string2 = Macro.getOptions();
            if (IJ.isMacro() && string2 != null && string2.indexOf("[Text File]") != -1) {
                this.type = 5;
                this.name = "Untitled.txt";
                string = "text+dialog";
            } else {
                this.type = 6;
                this.name = "Table";
            }
        }
        this.menuBar = true;
        if ((string.equals("text+dialog") || this.type == 6) && !this.showDialog()) {
            return;
        }
        if (this.type == -1) {
            this.name = "Converted_Macro.java";
            if (string.startsWith("name:")) {
                int n = string.indexOf(10);
                this.name = string.substring(5, n);
                string = string.substring(n + 1);
            }
            this.createPlugin(this.name, 2, string);
        } else if (this.type == 0 || this.type == 5 || this.type == 1) {
            if (this.type == 5 && this.name.equals("Macro")) {
                this.name = "Untitled.txt";
            }
            this.createMacro(this.name);
        } else if (this.type == 6) {
            this.createTable();
        } else {
            this.createPlugin(this.name, this.type, string);
        }
    }

    public void createMacro(String string) {
        int n = (this.monospaced ? 1 : 0) + (this.menuBar ? 2 : 0);
        if (this.type == 0 && !string.endsWith(".txt")) {
            string = SaveDialog.setExtension(string, ".txt");
        } else if (this.type == 1 && !string.endsWith(".js")) {
            if (string.equals("Macro")) {
                string = "script";
            }
            string = SaveDialog.setExtension(string, ".js");
        }
        if (this.type == 0 && IJ.runFijiEditor(string, "")) {
            return;
        }
        this.ed = new Editor(rows, columns, 0, n);
        this.ed.create(string, "");
    }

    void createTable() {
        new TextWindow(this.name, "", tableWidth, tableHeight);
    }

    public void createPlugin(String string, int n, String string2) {
        String string3 = string;
        if (!string.endsWith(".java") && !string.endsWith(".JAVA")) {
            string = SaveDialog.setExtension(string, ".java");
        }
        String string4 = string3.substring(0, string3.length() - 5);
        String string5 = "";
        string5 = string5 + "import ij.*;\n";
        string5 = string5 + "import ij.process.*;\n";
        string5 = string5 + "import ij.gui.*;\n";
        string5 = string5 + "import java.awt.*;\n";
        switch (n) {
            case 2: {
                string5 = string5 + "import ij.plugin.*;\n";
                string5 = string5 + "import ij.plugin.frame.*;\n";
                string5 = string5 + "\n";
                string5 = string5 + "public class " + string4 + " implements PlugIn {\n";
                string5 = string5 + "\n";
                string5 = string5 + "\tpublic void run(String arg) {\n";
                string5 = string2.equals("plugin") ? string5 + "\t\tIJ.showMessage(\"" + string4 + "\",\"Hello world!\");\n" : string5 + string2;
                string5 = string5 + "\t}\n";
                break;
            }
            case 3: {
                string5 = string5 + "import ij.plugin.filter.*;\n";
                string5 = string5 + "\n";
                string5 = string5 + "public class " + string4 + " implements PlugInFilter {\n";
                string5 = string5 + "\tImagePlus imp;\n";
                string5 = string5 + "\n";
                string5 = string5 + "\tpublic int setup(String arg, ImagePlus imp) {\n";
                string5 = string5 + "\t\tthis.imp = imp;\n";
                string5 = string5 + "\t\treturn DOES_ALL;\n";
                string5 = string5 + "\t}\n";
                string5 = string5 + "\n";
                string5 = string5 + "\tpublic void run(ImageProcessor ip) {\n";
                string5 = string5 + "\t\tip.invert();\n";
                string5 = string5 + "\t\timp.updateAndDraw();\n";
                string5 = string5 + "\t\tIJ.wait(500);\n";
                string5 = string5 + "\t\tip.invert();\n";
                string5 = string5 + "\t\timp.updateAndDraw();\n";
                string5 = string5 + "\t}\n";
                break;
            }
            case 4: {
                string5 = string5 + "import ij.plugin.frame.*;\n";
                string5 = string5 + "\n";
                string5 = string5 + "public class " + string4 + " extends PlugInFrame {\n";
                string5 = string5 + "\n";
                string5 = string5 + "\tpublic " + string4 + "() {\n";
                string5 = string5 + "\t\tsuper(\"" + string4 + "\");\n";
                string5 = string5 + "\t\tTextArea ta = new TextArea(15, 50);\n";
                string5 = string5 + "\t\tadd(ta);\n";
                string5 = string5 + "\t\tpack();\n";
                string5 = string5 + "\t\tGUI.center(this);\n";
                string5 = string5 + "\t\tshow();\n";
                string5 = string5 + "\t}\n";
            }
        }
        string5 = string5 + "\n";
        string5 = string5 + "}\n";
        if (IJ.runFijiEditor(string3, string5)) {
            return;
        }
        this.ed = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
        if (this.ed == null) {
            return;
        }
        this.ed.create(string3, string5);
    }

    public boolean showDialog() {
        String string;
        String string2;
        int n;
        int n2;
        String string3;
        if (this.type == 6) {
            string3 = "New Table";
            this.name = "Table";
            n2 = tableWidth;
            n = tableHeight;
            string2 = "pixels";
            string = "pixels";
        } else {
            string3 = "New Text Window";
            this.name = "Untitled";
            n2 = columns;
            n = rows;
            string2 = "characters";
            string = "lines";
        }
        GenericDialog genericDialog = new GenericDialog(string3);
        genericDialog.addStringField("Name:", this.name, 16);
        genericDialog.addMessage("");
        genericDialog.addNumericField("Width:", n2, 0, 3, string2);
        genericDialog.addNumericField("Height:", n, 0, 3, string);
        if (this.type != 6) {
            genericDialog.setInsets(5, 30, 0);
            genericDialog.addCheckbox("Menu Bar", true);
            genericDialog.setInsets(0, 30, 0);
            genericDialog.addCheckbox("Monospaced Font", this.monospaced);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        this.name = genericDialog.getNextString();
        n2 = (int)genericDialog.getNextNumber();
        n = (int)genericDialog.getNextNumber();
        if (n2 < 1) {
            n2 = 1;
        }
        if (n < 1) {
            n = 1;
        }
        if (this.type != 6) {
            this.menuBar = genericDialog.getNextBoolean();
            this.monospaced = genericDialog.getNextBoolean();
            columns = n2;
            rows = n;
            if (rows > 100) {
                rows = 100;
            }
            if (columns > 200) {
                columns = 200;
            }
        } else {
            tableWidth = n2;
            tableHeight = n;
            if (tableWidth < 128) {
                tableWidth = 128;
            }
            if (tableHeight < 75) {
                tableHeight = 75;
            }
        }
        return true;
    }

    public Editor getEditor() {
        return this.ed;
    }
}

