/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.imageio.ImageIO;

public class PNG_Writer
implements PlugIn {
    ImagePlus imp;

    public void run(String string) {
        String string2;
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (string.equals("")) {
            SaveDialog saveDialog = new SaveDialog("Save as PNG...", this.imp.getTitle(), ".png");
            string2 = saveDialog.getFileName();
            if (string2 == null) {
                return;
            }
            String string3 = saveDialog.getDirectory();
            string = string3 + string2;
        }
        try {
            this.writeImage(this.imp, string, Prefs.getTransparentIndex());
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
            if (string2 == null || string2.equals("")) {
                string2 = "" + exception;
            }
            IJ.showMessage("PNG Writer", "An error occured writing the file.\n \n" + string2);
        }
        IJ.showStatus("");
    }

    public void writeImage(ImagePlus imagePlus, String string, int n) throws Exception {
        if (n >= 0 && n <= 255 && imagePlus.getBitDepth() == 8) {
            this.writeImageWithTransparency(imagePlus, string, n);
        } else if (imagePlus.getOverlay() != null && !imagePlus.getHideOverlay()) {
            ImageIO.write((RenderedImage)imagePlus.flatten().getBufferedImage(), "png", new File(string));
        } else if (imagePlus.getBitDepth() == 16 && !imagePlus.isComposite() && imagePlus.getProcessor().isDefaultLut()) {
            this.write16gs(imagePlus, string);
        } else {
            ImageIO.write((RenderedImage)imagePlus.getBufferedImage(), "png", new File(string));
        }
    }

    void writeImageWithTransparency(ImagePlus imagePlus, String string, int n) throws Exception {
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        IndexColorModel indexColorModel = (IndexColorModel)imageProcessor.getColorModel();
        int n4 = indexColorModel.getMapSize();
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        indexColorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3, n);
        WritableRaster writableRaster = indexColorModel.createCompatibleWritableRaster(n2, n3);
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray4 = dataBufferByte.getData();
        System.arraycopy(imageProcessor.getPixels(), 0, byArray4, 0, byArray4.length);
        BufferedImage bufferedImage = new BufferedImage(indexColorModel, writableRaster, false, null);
        ImageIO.write((RenderedImage)bufferedImage, "png", new File(string));
    }

    void write16gs(ImagePlus imagePlus, String string) throws Exception {
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 11);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(imagePlus.getImage(), 0, 0, null);
        File file = new File(string);
        ImageIO.write((RenderedImage)bufferedImage, "png", file);
    }
}

