/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.Blitter;
import ij.process.ByteBlitter;
import ij.process.ByteProcessor;
import ij.process.ColorBlitter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.util.Date;

public class SurfacePlotter
implements PlugIn {
    static final int fontSize = 14;
    static int plotWidth = 350;
    static int polygonMultiplier = 100;
    static boolean oneToOne;
    static boolean firstTime;
    static boolean showWireframe;
    static boolean showGrayscale;
    static boolean showAxis;
    static boolean whiteBackground;
    static boolean blackFill;
    static boolean smooth;
    ImagePlus img;
    int[] x;
    int[] y;
    boolean invertedLut;
    double angleInDegrees = 35.0;
    double angle = this.angleInDegrees / 360.0 * 2.0 * Math.PI;
    double angle2InDegrees = 15.0;
    double angle2 = this.angle2InDegrees / 360.0 * 2.0 * Math.PI;
    double yinc2 = Math.sin(this.angle2);
    double p1x;
    double p1y;
    double p2x;
    double p2y;
    double p3x;
    double p3y;
    LookUpTable lut;

    public void run(String string) {
        Object object;
        this.img = WindowManager.getCurrentImage();
        if (this.img == null) {
            IJ.noImage();
            return;
        }
        if (this.img.getType() == 4) {
            IJ.error("Surface Plotter", "Grayscale or pseudo-color image required");
            return;
        }
        this.invertedLut = this.img.getProcessor().isInvertedLut();
        if (firstTime) {
            if (this.invertedLut) {
                whiteBackground = true;
            }
            firstTime = false;
        }
        if (!this.showDialog()) {
            return;
        }
        int n = IJ.setupDialog(this.img, 0);
        if (n == 4096) {
            return;
        }
        Date date = new Date();
        this.lut = this.img.createLut();
        if (n == 32 && this.img.getStack().getSize() > 1) {
            object = this.img.getStack();
            ImageProcessor imageProcessor = ((ImageStack)object).getProcessor(1);
            ImageProcessor imageProcessor2 = this.makeSurfacePlot(imageProcessor);
            ImageStack imageStack = new ImageStack(imageProcessor2.getWidth(), imageProcessor2.getHeight());
            imageStack.setColorModel(imageProcessor2.getColorModel());
            for (int i = 1; i <= ((ImageStack)object).getSize(); ++i) {
                imageStack.addSlice(null, new byte[imageProcessor2.getWidth() * imageProcessor2.getHeight()]);
            }
            imageStack.setPixels(imageProcessor2.getPixels(), 1);
            ImagePlus imagePlus = new ImagePlus("Surface Plot", imageStack);
            imagePlus.show();
            for (int i = 2; i <= ((ImageStack)object).getSize(); ++i) {
                IJ.showStatus("Drawing slice " + i + "..." + " (" + 100 * (i - 1) / ((ImageStack)object).getSize() + "% done)");
                imageProcessor = ((ImageStack)object).getProcessor(i);
                imageProcessor2 = this.makeSurfacePlot(imageProcessor);
                ImageWindow imageWindow = imagePlus.getWindow();
                if (imageWindow == null || !imageWindow.isClosed()) {
                    imageStack.setPixels(imageProcessor2.getPixels(), i);
                    imagePlus.setSlice(i);
                    continue;
                }
                break;
            }
        } else {
            object = this.makeSurfacePlot(this.img.getProcessor());
            new ImagePlus("Surface Plot", (ImageProcessor)object).show();
        }
        object = new Date();
        long l = date.getTime();
        long l2 = ((Date)object).getTime();
        long l3 = l2 - l;
        IJ.register(SurfacePlotter.class);
        IJ.showStatus("Done in " + l3 + " msec.");
    }

    boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog("Surface Plotter");
        genericDialog.addNumericField("Polygon Multiplier (10-200%):", polygonMultiplier, 0);
        genericDialog.addCheckbox("Draw_Wireframe", showWireframe);
        genericDialog.addCheckbox("Shade", showGrayscale);
        genericDialog.addCheckbox("Draw_Axis", showAxis);
        genericDialog.addCheckbox("Source Background is Lighter", whiteBackground);
        genericDialog.addCheckbox("Fill Plot Background with Black", blackFill);
        genericDialog.addCheckbox("One Polygon Per Line", oneToOne);
        genericDialog.addCheckbox("Smooth", smooth);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        polygonMultiplier = (int)genericDialog.getNextNumber();
        showWireframe = genericDialog.getNextBoolean();
        showGrayscale = genericDialog.getNextBoolean();
        showAxis = genericDialog.getNextBoolean();
        whiteBackground = genericDialog.getNextBoolean();
        blackFill = genericDialog.getNextBoolean();
        oneToOne = genericDialog.getNextBoolean();
        smooth = genericDialog.getNextBoolean();
        if (showWireframe && !showGrayscale) {
            blackFill = false;
        }
        if (polygonMultiplier > 400) {
            polygonMultiplier = 400;
        }
        if (polygonMultiplier < 10) {
            polygonMultiplier = 10;
        }
        return true;
    }

    public ImageProcessor makeSurfacePlot(ImageProcessor imageProcessor) {
        int n;
        imageProcessor = imageProcessor.duplicate();
        Rectangle rectangle = this.img.getProcessor().getRoi();
        imageProcessor.setRoi(rectangle);
        if (!(imageProcessor instanceof ByteProcessor)) {
            imageProcessor.setMinAndMax(this.img.getProcessor().getMin(), this.img.getProcessor().getMax());
            imageProcessor = imageProcessor.convertToByte(true);
            imageProcessor.setRoi(rectangle);
        }
        double d = this.angleInDegrees / 360.0 * 2.0 * Math.PI;
        int n2 = (int)((double)plotWidth * ((double)polygonMultiplier / 100.0) / 4.0);
        if (oneToOne) {
            n2 = rectangle.height;
        }
        double d2 = 0.8 * (double)plotWidth * Math.sin(d) / (double)n2;
        double d3 = 0.8 * (double)plotWidth * Math.cos(d) / (double)n2;
        IJ.showProgress(0.01);
        imageProcessor.setInterpolate(!oneToOne);
        imageProcessor = imageProcessor.resize(plotWidth, n2);
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        double d4 = imageProcessor.getMin();
        double d5 = imageProcessor.getMax();
        if (this.invertedLut) {
            imageProcessor.invert();
        }
        if (whiteBackground) {
            imageProcessor.invert();
        }
        if (smooth) {
            imageProcessor.smooth();
        }
        this.x = new int[n3 + 2];
        this.y = new int[n3 + 2];
        double d6 = 10.0;
        if (d2 < 0.0) {
            d6 += Math.abs(d2) * (double)n2;
        }
        ByteProcessor byteProcessor = new ByteProcessor(n3, (int)(256.0 + (double)n3 * this.yinc2));
        byteProcessor.setValue(255.0);
        byteProcessor.fill();
        double d7 = this.yinc2 * (double)n3;
        int n5 = (int)(d7 + 0.5);
        int n6 = (int)((double)plotWidth + (double)n2 * Math.abs(d2) + 20.0);
        int n7 = (int)((double)byteProcessor.getHeight() + (double)n2 * d3 + 10.0);
        if (showAxis) {
            n6 += 80;
            n7 += 20;
            this.p1x = d6 += 70.0;
            this.p1y = (d7 += 10.0) + 255.0;
            this.p2x = d6 + d2 * (double)n4;
            this.p2y = this.p1y + d3 * (double)n4;
            this.p3x = this.p2x + (double)n3 - 1.0;
            this.p3y = this.p2y - this.yinc2 * (double)n3;
        }
        if (showGrayscale) {
            int n8;
            int[] nArray = new int[255];
            for (n8 = 0; n8 < 255; ++n8) {
                int n9 = whiteBackground ? n8 : 255 - n8;
                nArray[n8] = n9;
            }
            n8 = byteProcessor.getHeight() - 255;
            for (n = 0; n < n3; ++n) {
                byteProcessor.putColumn(n, n8 - (int)(this.yinc2 * (double)n + 0.5), nArray, 255);
            }
        } else {
            byteProcessor.setValue(254.0);
            byteProcessor.fill();
        }
        byteProcessor.snapshot();
        ImageProcessor imageProcessor2 = new ByteProcessor(n6, n7);
        if (showGrayscale) {
            imageProcessor2.setColorModel(imageProcessor.getColorModel());
            if (this.invertedLut) {
                imageProcessor2.invertLut();
            }
            this.fixLut(imageProcessor2);
        }
        if (!blackFill) {
            imageProcessor2.setValue(255.0);
        } else {
            imageProcessor2.setValue(0.0);
        }
        imageProcessor2.fill();
        for (int i = 0; i < n4; ++i) {
            double[] dArray = imageProcessor.getLine(0.0, i, n3 - 1, i);
            this.clearAboveProfile(byteProcessor, dArray, n3, this.yinc2);
            n = (int)(d6 + 0.5);
            int n10 = (int)(d7 + 0.5);
            imageProcessor2.copyBits(byteProcessor, n, n10 - n5, 2);
            byteProcessor.reset();
            if (showWireframe) {
                imageProcessor2.setValue(0.0);
                double d8 = 0.0;
                imageProcessor2.moveTo(n, (int)(d7 + 255.5 - dArray[0]));
                for (int j = 1; j < n3; ++j) {
                    imageProcessor2.lineTo(n + j, (int)(d7 + 255.5 - (dArray[j] + (d8 += this.yinc2))));
                }
                imageProcessor2.drawLine(n, n10 + 255, n + n3 - 1, (int)(d7 + 255.5 - d8));
                imageProcessor2.drawLine(n, n10 + 255 - (int)(dArray[0] + 0.5), n, n10 + 255);
                imageProcessor2.drawLine(n + n3 - 1, (int)(d7 + 255.5 - d8), n + n3 - 1, (int)(d7 + 255.5 - (dArray[n3 - 1] + d8)));
            }
            d6 += d2;
            d7 += d3;
            if (i % 10 != 0) continue;
            IJ.showProgress((double)i / (double)n4);
        }
        IJ.showProgress(1.0);
        if (this.invertedLut) {
            imageProcessor.invert();
            imageProcessor.invertLut();
        }
        if (whiteBackground) {
            imageProcessor.invert();
        }
        if (showAxis) {
            if (!this.lut.isGrayscale() && showGrayscale) {
                imageProcessor2 = imageProcessor2.convertToRGB();
            }
            this.drawAndLabelAxis(imageProcessor, imageProcessor2, rectangle);
        }
        if (this.img.getStackSize() == 1) {
            imageProcessor2 = this.trimPlot(imageProcessor2, n5);
        }
        return imageProcessor2;
    }

    void drawAndLabelAxis(ImageProcessor imageProcessor, ImageProcessor imageProcessor2, Rectangle rectangle) {
        double d;
        double d2;
        imageProcessor2.setFont(new Font("SansSerif", 0, 14));
        if (!blackFill) {
            imageProcessor2.setColor(Color.black);
        } else {
            imageProcessor2.setColor(Color.white);
        }
        imageProcessor2.setAntialiasedText(true);
        Calibration calibration = this.img.getCalibration();
        String string = calibration.getValueUnit();
        if (string.equals("Gray Value")) {
            string = "";
        }
        int n = imageProcessor2.getFontMetrics().stringWidth(string);
        this.drawAxis(imageProcessor2, (int)this.p1x, (int)this.p1y - 255, (int)this.p1x, (int)this.p1y, string, 10, -1, 0, 1);
        if (this.img.getBitDepth() == 8) {
            d2 = 0.0;
            d = 255.0;
        } else {
            d2 = this.img.getProcessor().getMin();
            d = this.img.getProcessor().getMax();
        }
        if (calibration.calibrated()) {
            d2 = calibration.getCValue((int)d2);
            d = calibration.getCValue((int)d);
        }
        imageProcessor2.setAntialiasedText(true);
        string = String.valueOf((double)Math.round(d * 10.0) / 10.0);
        n = imageProcessor.getFontMetrics().stringWidth(string);
        int n2 = imageProcessor.getFontMetrics().getHeight();
        imageProcessor2.drawString(string, (int)this.p1x - 18 - n, (int)this.p1y - 255 + n2 / 2);
        string = String.valueOf((double)Math.round(d2 * 10.0) / 10.0);
        n = imageProcessor2.getFontMetrics().stringWidth(string);
        imageProcessor2.drawString(string, (int)this.p1x - 18 - n, (int)this.p1y + n2 / 2);
        string = (double)Math.round((double)rectangle.height * calibration.pixelHeight * 10.0) / 10.0 + " " + calibration.getUnits();
        n = imageProcessor2.getFontMetrics().stringWidth(string);
        this.drawAxis(imageProcessor2, (int)this.p1x, (int)this.p1y, (int)this.p2x, (int)this.p2y, string, 10, -1, 1, 1);
        string = (double)Math.round((double)rectangle.width * calibration.pixelWidth * 10.0) / 10.0 + " " + calibration.getUnits();
        n = imageProcessor2.getFontMetrics().stringWidth(string);
        this.drawAxis(imageProcessor2, (int)this.p2x, (int)this.p2y, (int)this.p3x, (int)this.p3y, string, 10, 1, -1, 1);
    }

    void drawAxis(ImageProcessor imageProcessor, int n, int n2, int n3, int n4, String string, int n5, int n6, int n7, int n8) {
        if (blackFill) {
            imageProcessor.setColor(Color.white);
        } else {
            imageProcessor.setColor(Color.black);
        }
        double d = -((double)(n4 - n2)) / (double)(n3 - n);
        if (d == 0.0) {
            d = 1.0E-4;
        }
        double d2 = -1.0 / d;
        double d3 = Math.atan(d2);
        int n9 = -n6 * (int)(7.0 * Math.sin(d3));
        int n10 = -n6 * (int)(7.0 * Math.cos(d3));
        imageProcessor.drawLine(n += n6 * (int)((double)n5 * Math.cos(d3)), n2 += n7 * (int)((double)n5 * Math.sin(d3)), n3 += n6 * (int)((double)n5 * Math.cos(d3)), n4 += n7 * (int)((double)n5 * Math.sin(d3)));
        imageProcessor.drawLine(n, n2, n + n10, n2 - n9);
        imageProcessor.drawLine(n3, n4, n3 + n10, n4 - n9);
        ImageProcessor imageProcessor2 = this.drawString(imageProcessor, string, (int)(Math.atan(d) / 2.0 / Math.PI * 360.0));
        if (blackFill) {
            imageProcessor2.invert();
        }
        Blitter blitter = imageProcessor instanceof ByteProcessor ? new ByteBlitter((ByteProcessor)imageProcessor) : new ColorBlitter((ColorProcessor)imageProcessor);
        Color color = blackFill ? Color.black : Color.white;
        blitter.setTransparentColor(color);
        int n11 = (n + n3) / 2 - imageProcessor2.getWidth() / 2 + n6 * n8 * (int)(15.0 * Math.cos(d3));
        int n12 = (n2 + n4) / 2 - imageProcessor2.getHeight() / 2 + n7 * n8 * (int)(15.0 * Math.sin(d3));
        blitter.copyBits(imageProcessor2, n11, n12, 2);
    }

    ImageProcessor drawString(ImageProcessor imageProcessor, String string, int n) {
        int n2 = imageProcessor.getFontMetrics().stringWidth(string);
        int n3 = imageProcessor.getFontMetrics().getHeight();
        double d = Math.sqrt(n2 / 2 * (n2 / 2) + n3 / 2 * (n3 / 2));
        double d2 = (double)n / 360.0 * 2.0 * Math.PI;
        double d3 = Math.acos((double)(n2 / 2) / d);
        int n4 = (int)Math.abs(d * Math.cos(d3 + d2));
        int n5 = (int)Math.abs(d * Math.sin(d3 + d2));
        if ((int)Math.abs(d * Math.cos(-d3 + d2)) > n4) {
            n4 = (int)Math.abs(d * Math.cos(-d3 + d2));
        }
        if ((int)Math.abs(d * Math.sin(-d3 + d2)) > n5) {
            n5 = (int)Math.abs(d * Math.sin(-d3 + d2));
        }
        n5 *= 2;
        int n6 = n2;
        if ((n4 *= 2) > n2) {
            n6 = n4;
        }
        ImageProcessor imageProcessor2 = new ByteProcessor(n6, n5);
        imageProcessor2.setFont(new Font("SansSerif", 0, 14));
        ((ImageProcessor)imageProcessor2).setColor(Color.white);
        imageProcessor2.fill();
        ((ImageProcessor)imageProcessor2).setColor(Color.black);
        imageProcessor2.setAntialiasedText(true);
        imageProcessor2.drawString(string, n6 / 2 - n2 / 2, n5 / 2 + n3 / 2);
        imageProcessor2.setInterpolate(true);
        ((ImageProcessor)imageProcessor2).rotate(-n);
        imageProcessor2.setRoi(n6 / 2 - n4 / 2, 0, n4, n5);
        imageProcessor2 = ((ImageProcessor)imageProcessor2).crop();
        return imageProcessor2;
    }

    void clearAboveProfile(ImageProcessor imageProcessor, double[] dArray, int n, double d) {
        byte[] byArray = (byte[])imageProcessor.getPixels();
        double d2 = 0.0;
        int n2 = imageProcessor.getHeight();
        for (int i = 0; i < n; ++i) {
            int n3 = n2 - (int)(dArray[i] + (d2 += d));
            int n4 = 0;
            int n5 = i;
            while (n4 < n3) {
                byArray[n5] = -1;
                ++n4;
                n5 += n;
            }
        }
    }

    ImageProcessor trimPlot(ImageProcessor imageProcessor, int n) {
        int n2 = imageProcessor.getPixel(0, 0);
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        int n5 = n - 5;
        block0: for (int i = 0; i < n - 5; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (imageProcessor.getPixel(j, i) == n2) continue;
                n5 = i - 5;
                break block0;
            }
        }
        if (n5 > 10) {
            imageProcessor.setRoi(0, n5, n3, n4 - n5);
            imageProcessor = imageProcessor.crop();
        }
        return imageProcessor;
    }

    void fixLut(ImageProcessor imageProcessor) {
        if (!this.lut.isGrayscale() && this.lut.getMapSize() == 256) {
            for (int i = 0; i < imageProcessor.getHeight(); ++i) {
                for (int j = 0; j < imageProcessor.getWidth(); ++j) {
                    if (imageProcessor.getPixelValue(j, i) == 0.0f) {
                        imageProcessor.putPixelValue(j, i, 1.0);
                        continue;
                    }
                    if (imageProcessor.getPixelValue(j, i) != 255.0f) continue;
                    imageProcessor.putPixelValue(j, i, 254.0);
                }
            }
            byte[] byArray = this.lut.getReds();
            byte[] byArray2 = this.lut.getGreens();
            byte[] byArray3 = this.lut.getBlues();
            byArray[0] = 0;
            byArray2[0] = 0;
            byArray3[0] = 0;
            byArray[255] = -1;
            byArray2[255] = -1;
            byArray3[255] = -1;
            imageProcessor.setColorModel(new IndexColorModel(8, 256, byArray, byArray2, byArray3));
        }
    }

    static {
        firstTime = true;
        showWireframe = false;
        showGrayscale = true;
        showAxis = true;
        whiteBackground = false;
        blackFill = false;
        smooth = true;
    }
}

