/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.measure.Calibration;
import ij.plugin.CompositeConverter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.MedianCut;

public class StackConverter {
    ImagePlus imp;
    int type;
    int nSlices;
    int width;
    int height;

    public StackConverter(ImagePlus imagePlus) {
        this.imp = imagePlus;
        this.type = imagePlus.getType();
        this.nSlices = imagePlus.getStackSize();
        if (this.nSlices < 2) {
            throw new IllegalArgumentException("Stack required");
        }
        this.width = imagePlus.getWidth();
        this.height = imagePlus.getHeight();
    }

    public void convertToGray8() {
        boolean bl;
        ImageStack imageStack = this.imp.getStack();
        int n = this.imp.getCurrentSlice();
        ImageProcessor imageProcessor = this.imp.getProcessor();
        boolean bl2 = imageProcessor.isColorLut();
        boolean bl3 = bl = bl2 && imageProcessor.isPseudoColorLut();
        if (this.type == 0 && bl) {
            boolean bl4 = imageProcessor.isInvertedLut();
            imageProcessor.setColorModel(LookUpTable.createGrayscaleColorModel(bl4));
            imageStack.setColorModel(imageProcessor.getColorModel());
            this.imp.updateAndDraw();
            return;
        }
        if (this.type == 4 || this.type == 3 || bl2) {
            this.convertRGBToGray8();
            this.imp.setSlice(n);
            return;
        }
        ImageStack imageStack2 = new ImageStack(this.width, this.height);
        double d = imageProcessor.getMin();
        double d2 = imageProcessor.getMax();
        int n2 = this.nSlices / 20;
        if (n2 < 1) {
            n2 = 1;
        }
        LUT[] lUTArray = this.imp.isComposite() ? ((CompositeImage)this.imp).getLuts() : null;
        for (int i = 1; i <= this.nSlices; ++i) {
            int n3;
            String string = imageStack.getSliceLabel(1);
            imageProcessor = imageStack.getProcessor(1);
            imageStack.deleteSlice(1);
            if (lUTArray != null) {
                n3 = (i - 1) % lUTArray.length;
                d = lUTArray[n3].min;
                d2 = lUTArray[n3].max;
            }
            imageProcessor.setMinAndMax(d, d2);
            n3 = ImageConverter.getDoScaling();
            imageStack2.addSlice(string, imageProcessor.convertToByte(n3 != 0));
            if (i % n2 != 0) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
            IJ.showStatus("Converting to 8-bits: " + i + "/" + this.nSlices);
        }
        this.imp.setStack(null, imageStack2);
        this.imp.setCalibration(this.imp.getCalibration());
        if (this.imp.isComposite()) {
            ((CompositeImage)this.imp).resetDisplayRanges();
            ((CompositeImage)this.imp).updateAllChannelsAndDraw();
        }
        this.imp.setSlice(n);
        IJ.showProgress(1.0);
    }

    void convertRGBToGray8() {
        ImageStack imageStack = this.imp.getStack();
        ImageStack imageStack2 = new ImageStack(this.width, this.height);
        int n = this.nSlices / 20;
        if (n < 1) {
            n = 1;
        }
        for (int i = 1; i <= this.nSlices; ++i) {
            String string = imageStack.getSliceLabel(1);
            ImageProcessor imageProcessor = imageStack.getProcessor(1);
            imageStack.deleteSlice(1);
            if (imageProcessor instanceof ByteProcessor) {
                imageProcessor = new ColorProcessor(imageProcessor.createImage());
            }
            boolean bl = ImageConverter.getDoScaling();
            imageStack2.addSlice(string, imageProcessor.convertToByte(bl));
            if (i % n != 0) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
            IJ.showStatus("Converting to 8-bits: " + i + "/" + this.nSlices);
        }
        this.imp.setStack(null, imageStack2);
        IJ.showProgress(1.0);
    }

    public void convertToGray16() {
        if (this.type == 1) {
            return;
        }
        if (this.type != 0 && this.type != 2) {
            throw new IllegalArgumentException("Unsupported conversion");
        }
        ImageStack imageStack = this.imp.getStack();
        ImageStack imageStack2 = new ImageStack(this.width, this.height);
        int n = this.nSlices / 20;
        if (n < 1) {
            n = 1;
        }
        boolean bl = this.type == 2 && ImageConverter.getDoScaling();
        for (int i = 1; i <= this.nSlices; ++i) {
            String string = imageStack.getSliceLabel(1);
            ImageProcessor imageProcessor = imageStack.getProcessor(1);
            ImageProcessor imageProcessor2 = imageProcessor.convertToShort(bl);
            imageStack.deleteSlice(1);
            imageStack2.addSlice(string, imageProcessor2);
            if (i % n != 0) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
            IJ.showStatus("Converting to 16-bits: " + i + "/" + this.nSlices);
        }
        IJ.showProgress(1.0);
        this.imp.setStack(null, imageStack2);
    }

    public void convertToGray32() {
        if (this.type == 2) {
            return;
        }
        if (this.type != 0 && this.type != 1) {
            throw new IllegalArgumentException("Unsupported conversion");
        }
        ImageStack imageStack = this.imp.getStack();
        ImageStack imageStack2 = new ImageStack(this.width, this.height);
        int n = this.nSlices / 20;
        if (n < 1) {
            n = 1;
        }
        Calibration calibration = this.imp.getCalibration();
        for (int i = 1; i <= this.nSlices; ++i) {
            String string = imageStack.getSliceLabel(1);
            ImageProcessor imageProcessor = imageStack.getProcessor(1);
            imageProcessor.setCalibrationTable(calibration.getCTable());
            ImageProcessor imageProcessor2 = imageProcessor.convertToFloat();
            imageStack.deleteSlice(1);
            imageStack2.addSlice(string, imageProcessor2);
            if (i % n != 0) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
            IJ.showStatus("Converting to 32-bits: " + i + "/" + this.nSlices);
        }
        IJ.showProgress(1.0);
        this.imp.setStack(null, imageStack2);
        this.imp.setCalibration(this.imp.getCalibration());
    }

    public void convertToRGB() {
        if (this.imp.isComposite()) {
            throw new IllegalArgumentException("Use Image>Color>Stack to RGB");
        }
        ImageStack imageStack = this.imp.getStack();
        ImageStack imageStack2 = new ImageStack(this.width, this.height);
        int n = this.nSlices / 20;
        if (n < 1) {
            n = 1;
        }
        Calibration calibration = this.imp.getCalibration();
        for (int i = 1; i <= this.nSlices; ++i) {
            String string = imageStack.getSliceLabel(i);
            ImageProcessor imageProcessor = imageStack.getProcessor(i);
            ImageProcessor imageProcessor2 = imageProcessor.convertToRGB();
            imageStack2.addSlice(string, imageProcessor2);
            if (i % n != 0) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
            IJ.showStatus("Converting to RGB: " + i + "/" + this.nSlices);
        }
        IJ.showProgress(1.0);
        this.imp.setStack(null, imageStack2);
        this.imp.setCalibration(this.imp.getCalibration());
    }

    public void convertToRGBHyperstack() {
        if (this.type != 4) {
            throw new IllegalArgumentException("RGB stack required");
        }
        new CompositeConverter().run("composite");
    }

    public void convertToHSBHyperstack() {
        if (this.type != 4) {
            throw new IllegalArgumentException("RGB stack required");
        }
        ImageStack imageStack = this.imp.getStack();
        ImageStack imageStack2 = new ImageStack(this.width, this.height);
        int n = imageStack.getSize();
        Calibration calibration = this.imp.getCalibration();
        int n2 = n / 20;
        if (n2 < 1) {
            n2 = 1;
        }
        for (int i = 1; i <= n; ++i) {
            String string = imageStack.getSliceLabel(i);
            ColorProcessor colorProcessor = (ColorProcessor)imageStack.getProcessor(i);
            ImageStack imageStack3 = colorProcessor.getHSBStack();
            imageStack2.addSlice(string, imageStack3.getProcessor(1));
            imageStack2.addSlice(string, imageStack3.getProcessor(2));
            imageStack2.addSlice(string, imageStack3.getProcessor(3));
            if (i % n2 != 0) continue;
            IJ.showProgress((double)i / (double)n);
            IJ.showStatus("Converting to HSB: " + i + "/" + n);
        }
        IJ.showProgress(1.0);
        this.imp.setStack(null, imageStack2);
        this.imp.setCalibration(calibration);
        this.imp.setDimensions(3, n, 1);
        CompositeImage compositeImage = new CompositeImage(this.imp, 3);
        compositeImage.show();
        this.imp.hide();
    }

    public void convertToIndexedColor(int n) {
        if (this.type != 4) {
            throw new IllegalArgumentException("RGB stack required");
        }
        ImageStack imageStack = this.imp.getStack();
        int n2 = imageStack.getSize();
        ImageProcessor imageProcessor = new ColorProcessor(this.width * n2, this.height);
        for (int i = 0; i < n2; ++i) {
            imageProcessor.insert(imageStack.getProcessor(i + 1), i * this.width, 0);
        }
        MedianCut medianCut = new MedianCut((ColorProcessor)imageProcessor);
        imageProcessor = medianCut.convertToByte(n);
        ImageStack imageStack2 = new ImageStack(this.width, this.height);
        for (int i = 0; i < n2; ++i) {
            imageProcessor.setRoi(i * this.width, 0, this.width, this.height);
            imageStack2.addSlice(null, imageProcessor.crop());
        }
        this.imp.setStack(null, imageStack2);
    }
}

