/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImageStack;
import ij.macro.Interpreter;
import ij.process.ImageProcessor;

public class StackProcessor {
    private ImageStack stack;
    private ImageProcessor ip;
    int nSlices;
    double xScale;
    double yScale;
    int[] table;
    double fillValue;
    static final int FLIPH = 0;
    static final int FLIPV = 1;
    static final int SCALE = 2;
    static final int INVERT = 3;
    static final int APPLY_TABLE = 4;
    static final int SCALE_WITH_FILL = 5;

    public StackProcessor(ImageStack imageStack, ImageProcessor imageProcessor) {
        this.stack = imageStack;
        this.ip = imageProcessor;
        this.nSlices = imageStack.getSize();
        if (this.nSlices > 1 && imageProcessor != null) {
            imageProcessor.setProgressBar(null);
        }
    }

    void process(int n) {
        String string = "";
        ImageProcessor imageProcessor = this.stack.getProcessor(1);
        switch (n) {
            case 0: 
            case 1: {
                string = "Flip: ";
                break;
            }
            case 2: {
                string = "Scale: ";
                break;
            }
            case 5: {
                string = "Scale: ";
                imageProcessor.setBackgroundValue(this.fillValue);
                break;
            }
            case 3: {
                string = "Invert: ";
                break;
            }
            case 4: {
                string = "Apply: ";
            }
        }
        imageProcessor.setRoi(this.ip.getRoi());
        imageProcessor.setInterpolate(this.ip.getInterpolate());
        for (int i = 1; i <= this.nSlices; ++i) {
            this.showStatus(string, i, this.nSlices);
            imageProcessor.setPixels(this.stack.getPixels(i));
            if (this.nSlices == 1 && i == 1 && n == 2) {
                imageProcessor.snapshot();
            }
            switch (n) {
                case 0: {
                    imageProcessor.flipHorizontal();
                    break;
                }
                case 1: {
                    imageProcessor.flipVertical();
                    break;
                }
                case 2: 
                case 5: {
                    imageProcessor.scale(this.xScale, this.yScale);
                    break;
                }
                case 3: {
                    imageProcessor.invert();
                    break;
                }
                case 4: {
                    imageProcessor.applyTable(this.table);
                }
            }
            IJ.showProgress((double)i / (double)this.nSlices);
        }
        IJ.showProgress(1.0);
    }

    public void invert() {
        this.process(3);
    }

    public void flipHorizontal() {
        this.process(0);
    }

    public void flipVertical() {
        this.process(1);
    }

    public void applyTable(int[] nArray) {
        this.table = nArray;
        this.process(4);
    }

    public void scale(double d, double d2) {
        this.xScale = d;
        this.yScale = d2;
        this.process(2);
    }

    public void scale(double d, double d2, double d3) {
        this.xScale = d;
        this.yScale = d2;
        this.fillValue = d3;
        this.process(5);
    }

    public ImageStack resize(int n, int n2) {
        return this.resize(n, n2, false);
    }

    public ImageStack resize(int n, int n2, boolean bl) {
        ImageStack imageStack = new ImageStack(n, n2);
        try {
            for (int i = 1; i <= this.nSlices; ++i) {
                this.showStatus("Resize: ", i, this.nSlices);
                this.ip.setPixels(this.stack.getPixels(1));
                String string = this.stack.getSliceLabel(1);
                this.stack.deleteSlice(1);
                ImageProcessor imageProcessor = this.ip.resize(n, n2, bl);
                if (imageProcessor != null) {
                    imageStack.addSlice(string, imageProcessor);
                }
                IJ.showProgress((double)i / (double)this.nSlices);
            }
            IJ.showProgress(1.0);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            while (this.stack.getSize() > 1) {
                this.stack.deleteLastSlice();
            }
            IJ.outOfMemory("StackProcessor.resize");
            IJ.showProgress(1.0);
        }
        return imageStack;
    }

    public ImageStack crop(int n, int n2, int n3, int n4) {
        ImageStack imageStack = new ImageStack(n3, n4);
        for (int i = 1; i <= this.nSlices; ++i) {
            ImageProcessor imageProcessor = this.stack.getProcessor(1);
            imageProcessor.setRoi(n, n2, n3, n4);
            String string = this.stack.getSliceLabel(1);
            this.stack.deleteSlice(1);
            ImageProcessor imageProcessor2 = imageProcessor.crop();
            imageStack.addSlice(string, imageProcessor2);
            IJ.showProgress((double)i / (double)this.nSlices);
        }
        IJ.showProgress(1.0);
        return imageStack;
    }

    ImageStack rotate90Degrees(boolean bl) {
        ImageStack imageStack = new ImageStack(this.stack.getHeight(), this.stack.getWidth());
        for (int i = 1; i <= this.nSlices; ++i) {
            this.showStatus("Rotate: ", i, this.nSlices);
            this.ip.setPixels(this.stack.getPixels(1));
            String string = this.stack.getSliceLabel(1);
            this.stack.deleteSlice(1);
            ImageProcessor imageProcessor = bl ? this.ip.rotateRight() : this.ip.rotateLeft();
            if (imageProcessor != null) {
                imageStack.addSlice(string, imageProcessor);
            }
            if (Interpreter.isBatchMode()) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
        }
        if (!Interpreter.isBatchMode()) {
            IJ.showProgress(1.0);
        }
        return imageStack;
    }

    public ImageStack rotateRight() {
        return this.rotate90Degrees(true);
    }

    public ImageStack rotateLeft() {
        return this.rotate90Degrees(false);
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        this.copyBits(imageProcessor, null, n, n2, n3);
    }

    public void copyBits(ImageStack imageStack, int n, int n2, int n3) {
        this.copyBits(null, imageStack, n, n2, n3);
    }

    private void copyBits(ImageProcessor imageProcessor, ImageStack imageStack, int n, int n2, int n3) {
        int n4 = this.nSlices / 20;
        if (n4 < 1) {
            n4 = 1;
        }
        boolean bl = imageProcessor == null;
        for (int i = 1; i <= this.nSlices; ++i) {
            if (bl) {
                imageProcessor = imageStack.getProcessor(i);
            }
            ImageProcessor imageProcessor2 = this.stack.getProcessor(i);
            imageProcessor2.copyBits(imageProcessor, n, n2, n3);
            if (i % n4 != 0) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
        }
        IJ.showProgress(1.0);
    }

    void showStatus(String string, int n, int n2) {
        IJ.showStatus(string + n + "/" + n2);
    }
}

