/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.timeseries.regression.AdditiveOutlierFactory;
import ec.tstoolkit.timeseries.regression.IOutlierFactory;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.LevelShiftFactory;
import ec.tstoolkit.timeseries.regression.OutlierDefinition;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.regression.SeasonalOutlierFactory;
import ec.tstoolkit.timeseries.regression.TransitoryChangeFactory;
import java.util.ArrayList;
import java.util.List;

public final class OutliersFactory {
    public static final OutliersFactory defaultFactory = new OutliersFactory(true);
    private final ArrayList<IOutlierFactory> factories = new ArrayList();

    public OutliersFactory(boolean def) {
        if (def) {
            this.factories.add(new AdditiveOutlierFactory());
            this.factories.add(new LevelShiftFactory());
            this.factories.add(new TransitoryChangeFactory());
            this.factories.add(new SeasonalOutlierFactory());
        }
    }

    public List<IOutlierFactory> getFactories() {
        return this.factories;
    }

    public IOutlierVariable make(OutlierDefinition def) {
        for (IOutlierFactory fac : this.factories) {
            if (fac.getOutlierType() != def.getType()) continue;
            IOutlierVariable o = fac.create(def.getPosition());
            return o;
        }
        return null;
    }

    public boolean register(IOutlierFactory fac) {
        for (IOutlierFactory f : this.factories) {
            if (fac.getOutlierType() != f.getOutlierType()) continue;
            return false;
        }
        this.factories.add(fac);
        return true;
    }

    public boolean unregister(OutlierType code) {
        for (IOutlierFactory f : this.factories) {
            if (code != f.getOutlierType()) continue;
            this.factories.remove(f);
            return true;
        }
        return false;
    }

    public IOutlierFactory getFactory(OutlierType code) {
        for (IOutlierFactory f : this.factories) {
            if (code != f.getOutlierType()) continue;
            return f;
        }
        return null;
    }
}

