/*
 * Decompiled with CFR 0.152.
 */
package demetra.xml.regression;

import demetra.datatypes.DynamicTsVariable;
import demetra.xml.IXmlConverter;
import demetra.xml.XmlConverterAdapter;
import demetra.xml.XmlNamedObject;
import demetra.xml.regression.XmlDynamicTsVariable;
import demetra.xml.regression.XmlTsVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.TsVariable;
import ec.tstoolkit.timeseries.regression.TsVariables;
import ec.tstoolkit.utilities.Arrays2;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;

@XmlRootElement(name="tsVariables")
@XmlType(name="tsVariablesType")
public class XmlTsVariables
implements IXmlConverter<TsVariables> {
    static final String NAME = "tsVariablesType";
    static final String RNAME = "tsVariables";
    static final HashMap<Class<? extends XmlNamedObject>, XmlAdapter<? extends XmlNamedObject, ? extends ITsVariable>> fromXmlMap = new HashMap();
    static final HashMap<Class<? extends ITsVariable>, XmlAdapter<? extends XmlNamedObject, ? extends ITsVariable>> toXmlMap = new HashMap();
    @XmlElements(value={@XmlElement(name="tsVariable", type=XmlTsVariable.class), @XmlElement(name="dynamicTsVariable", type=XmlDynamicTsVariable.class)})
    public XmlNamedObject[] vars;
    @XmlAttribute
    public String name;

    static <S extends ITsVariable, X extends XmlNamedObject> void register(Class<S> sclass, Class<X> xclass) {
        XmlConverterAdapter mapper = new XmlConverterAdapter(xclass);
        fromXmlMap.put(xclass, mapper);
        toXmlMap.put(sclass, mapper);
    }

    public boolean isEmpty() {
        return this.vars == null || this.vars.length == 0;
    }

    @Override
    public TsVariables create() {
        TsVariables nvars = new TsVariables();
        if (!this.isEmpty()) {
            for (int i = 0; i < this.vars.length; ++i) {
                XmlAdapter<? extends XmlNamedObject, ? extends ITsVariable> adapter;
                if (this.vars[i] == null || (adapter = fromXmlMap.get(this.vars[i].getClass())) == null) continue;
                try {
                    ITsVariable v = (ITsVariable)adapter.unmarshal((Object)this.vars[i]);
                    nvars.set(this.vars[i].name, (Object)v);
                    continue;
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        return nvars;
    }

    @Override
    public void copy(TsVariables t) {
        Object[] n = t.getNames();
        if (Arrays2.isNullOrEmpty((Object[])n)) {
            return;
        }
        this.vars = new XmlNamedObject[n.length];
        for (int i = 0; i < n.length; ++i) {
            ITsVariable v = (ITsVariable)t.get((String)n[i]);
            XmlAdapter<? extends XmlNamedObject, ? extends ITsVariable> adapter = toXmlMap.get(v.getClass());
            if (adapter == null) continue;
            try {
                this.vars[i] = (XmlNamedObject)adapter.marshal((Object)v);
                this.vars[i].name = n[i];
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        XmlTsVariables.register(TsVariable.class, XmlTsVariable.class);
        XmlTsVariables.register(DynamicTsVariable.class, XmlDynamicTsVariable.class);
    }
}

