/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.Parameter;
import ec.tstoolkit.ParameterType;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.arima.estimation.ArmaFunction;
import ec.tstoolkit.arima.estimation.Forecasts;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.dstats.T;
import ec.tstoolkit.eco.CoefficientEstimation;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.RegressionItem;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.DeterministicComponent;
import ec.tstoolkit.modelling.PreadjustmentVariable;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.modelling.arima.LogForecasts;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.PreadjustmentType;
import ec.tstoolkit.modelling.arima.x13.UscbForecasts;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.regression.ICalendarVariable;
import ec.tstoolkit.timeseries.regression.IEasterVariable;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.IUserTsVariable;
import ec.tstoolkit.timeseries.regression.MissingValueEstimation;
import ec.tstoolkit.timeseries.regression.OutlierEstimation;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;
import ec.tstoolkit.timeseries.simplets.ITsDataTransformation;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.Arrays2;
import ec.tstoolkit.utilities.Jdk6;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class PreprocessingModel
implements IProcResults {
    public final ModelDescription description;
    public final ModelEstimation estimation;
    public InformationSet info_;
    private List<ProcessingInformation> log_ = new ArrayList<ProcessingInformation>();
    private static final OutlierEstimation[] NO_OUTLIER = new OutlierEstimation[0];
    private TsVariableList x_;
    private TsData fullres_;
    private TsData lin_;
    private TsData fcast_;
    private TsData bcast_;
    private Forecasts xfcasts_;
    private int ncasts = -2;
    public static final String LOG = "log";
    public static final String ADJUST = "adjust";
    public static final String SPAN = "span";
    public static final String ESPAN = "espan";
    public static final String START = "start";
    public static final String END = "end";
    public static final String N = "n";
    public static final String NM = "missing";
    public static final String PERIOD = "period";
    public static final String REGRESSION = "regression";
    public static final String OUTLIERS = "outlier(*)";
    public static final String CALENDAR = "calendar(*)";
    public static final String EASTER = "easter";
    public static final String FULLRES = "fullresiduals";
    public static final String FCASTS = "fcasts";
    public static final String EFCASTS = "efcasts";
    public static final String BCASTS = "bcasts";
    public static final String LIN_FCASTS = "lin_fcasts";
    public static final String LIN_BCASTS = "lin_bcasts";
    public static final String NTD = "ntd";
    public static final String NMH = "nmh";
    public static final String TD = "td";
    public static final String TD1 = "td(1)";
    public static final String TD2 = "td(2)";
    public static final String TD3 = "td(3)";
    public static final String TD4 = "td(4)";
    public static final String TD5 = "td(5)";
    public static final String TD6 = "td(6)";
    public static final String TD7 = "td(7)";
    public static final String TD8 = "td(8)";
    public static final String TD9 = "td(9)";
    public static final String TD10 = "td(10)";
    public static final String TD11 = "td(11)";
    public static final String TD12 = "td(12)";
    public static final String TD13 = "td(13)";
    public static final String TD14 = "td(14)";
    public static final String LP = "lp";
    public static final String OUT = "out";
    public static final String OUT1 = "out(1)";
    public static final String OUT2 = "out(2)";
    public static final String OUT3 = "out(3)";
    public static final String OUT4 = "out(4)";
    public static final String OUT5 = "out(5)";
    public static final String OUT6 = "out(6)";
    public static final String OUT7 = "out(7)";
    public static final String NOUT = "nout";
    public static final String NOUTAO = "noutao";
    public static final String NOUTLS = "noutls";
    public static final String NOUTTC = "nouttc";
    public static final String NOUTSO = "noutso";
    public static final String OUT8 = "out(8)";
    public static final String OUT9 = "out(9)";
    public static final String OUT10 = "out(10)";
    public static final String OUT11 = "out(11)";
    public static final String OUT12 = "out(12)";
    public static final String OUT13 = "out(13)";
    public static final String OUT14 = "out(14)";
    public static final String OUT15 = "out(15)";
    public static final String OUT16 = "out(16)";
    public static final String OUT17 = "out(17)";
    public static final String OUT18 = "out(18)";
    public static final String OUT19 = "out(19)";
    public static final String OUT20 = "out(20)";
    public static final String OUT21 = "out(21)";
    public static final String OUT22 = "out(22)";
    public static final String OUT23 = "out(23)";
    public static final String OUT24 = "out(24)";
    public static final String OUT25 = "out(25)";
    public static final String OUT26 = "out(26)";
    public static final String OUT27 = "out(27)";
    public static final String OUT28 = "out(28)";
    public static final String OUT29 = "out(29)";
    public static final String OUT30 = "out(30)";
    public static final String USER = "user";
    public static final String COEFF = "coefficients";
    public static final String COVAR = "covar";
    public static final String COEFFDESC = "description";
    public static final String PCOVAR = "pcovar";
    public static final String TD_DERIVED = "td-derived";
    public static final String TD_FTEST = "td-ftest";
    private static final InformationMapping<PreprocessingModel> MAPPING = new InformationMapping<PreprocessingModel>(PreprocessingModel.class);

    public int getNcasts() {
        return this.ncasts;
    }

    public void setNcasts(int ncasts) {
        this.ncasts = ncasts;
    }

    public static ComponentType outlierComponent(OutlierType type) {
        switch (type) {
            case AO: {
                return ComponentType.Irregular;
            }
            case TC: {
                return ComponentType.Irregular;
            }
            case LS: {
                return ComponentType.Trend;
            }
            case SO: {
                return ComponentType.Seasonal;
            }
        }
        return ComponentType.Undefined;
    }

    public static OutlierType[] outlierTypes(ComponentType cmp) {
        switch (cmp) {
            case Trend: {
                return new OutlierType[]{OutlierType.LS};
            }
            case Seasonal: {
                return new OutlierType[]{OutlierType.SO};
            }
            case Irregular: {
                return new OutlierType[]{OutlierType.AO, OutlierType.TC};
            }
        }
        return new OutlierType[0];
    }

    public void backTransform(TsData s, boolean T2, boolean S) {
        if (s == null) {
            return;
        }
        List<ITsDataTransformation> back = this.description.backTransformations(T2, S);
        for (ITsDataTransformation t : back) {
            t.transform(s, null);
        }
    }

    public PreprocessingModel(ModelDescription description, ModelEstimation estimation) {
        this.description = description;
        this.estimation = estimation;
    }

    public void updateModel() {
        IReadDataBlock p = this.estimation.getArima().getParameters();
        DataBlock e = new DataBlock(p.getLength());
        if (this.estimation.getParametersCovariance() != null) {
            DataBlock diag = this.estimation.getParametersCovariance().diagonal();
            for (int i = 0; i < e.getLength(); ++i) {
                double var = diag.get(i);
                e.set(i, var <= 0.0 ? 0.0 : Math.sqrt(var));
            }
            this.description.getArimaComponent().setParameters(p, e, ParameterType.Estimated);
        } else {
            this.description.getArimaComponent().setParameters(p, e, ParameterType.Initial);
        }
        if (this.description.getArimaComponent().isEstimatedMean()) {
            this.description.getArimaComponent().setMu(new Parameter(this.estimation.getLikelihood().getB()[0], ParameterType.Estimated));
        }
    }

    public void addProcessingInformation(ProcessingInformation info) {
        this.log_.add(info);
    }

    public void addProcessingInformation(Collection<ProcessingInformation> info) {
        if (this.log_ != null && info != null) {
            this.log_.addAll(info);
        }
    }

    public IFunction likelihoodFunction() {
        RegArimaModel<SarimaModel> regArima = this.estimation.getRegArima();
        ArmaFunction<SarimaModel> fn = new ArmaFunction<SarimaModel>(regArima.getDModel(), regArima.getArima().getDifferenceOrder(), regArima.getMissings(), this.description.defaultMapping());
        fn.llog = true;
        return fn;
    }

    public IFunctionInstance maxLikelihoodFunction() {
        IFunction fn = this.likelihoodFunction();
        return fn.evaluate(this.description.defaultMapping().map(this.estimation.getArima()));
    }

    public MissingValueEstimation[] missings(boolean unbiased) {
        int[] missings = this.description.getMissingValues();
        if (missings != null) {
            Object[] m = new MissingValueEstimation[missings.length];
            ConcentratedLikelihood ll = this.estimation.getLikelihood();
            double[] b = ll.getB();
            int nhp = this.description.getArimaComponent().getFreeParametersCount();
            double[] se = ll.getBSer(unbiased, nhp);
            int istart = this.description.isEstimatedMean() ? 1 : 0;
            for (int i = 0; i < missings.length; ++i) {
                int pos = missings[i];
                TsPeriod period = this.description.getEstimationDomain().get(pos);
                double val = this.description.getY()[pos] - b[istart + i];
                MissingValueEstimation cur = new MissingValueEstimation(period, val, se[istart + i]);
                m[i] = cur;
            }
            Arrays.sort(m);
            return m;
        }
        return null;
    }

    public TsData interpolatedSeries(boolean bTransformed) {
        TsData data = !bTransformed ? this.description.getOriginal() : this.description.transformedOriginal();
        int[] missings = this.description.getMissingValues();
        if (missings != null) {
            if (this.estimation == null) {
                return null;
            }
            if (!bTransformed) {
                List<ITsDataTransformation> list = this.description.backTransformations(true, true);
            }
            double[] b = this.estimation.getLikelihood().getB();
            int istart = this.description.isEstimatedMean() ? 1 : 0;
            int del = this.description.getEstimationDomain().getStart().minus(this.description.getSeriesDomain().getStart());
            for (int i = 0; i < missings.length; ++i) {
                int pos = missings[i];
                double val = this.description.getY()[pos] - b[istart + i];
                if (!bTransformed) {
                    TsData tmp = new TsData(this.description.getEstimationDomain().get(pos), 1);
                    tmp.set(0, val);
                    this.backTransform(tmp, true, true);
                    data.set(del + pos, tmp.get(0));
                    continue;
                }
                data.set(del + pos, val);
            }
        }
        return data;
    }

    public TsData linearizedSeries() {
        if (this.lin_ != null) {
            return this.lin_.clone();
        }
        if (this.estimation == null) {
            return this.description.transformedOriginal();
        }
        TsData interp = this.interpolatedSeries(true);
        TsData regs = this.regressionEffect(this.description.getSeriesDomain());
        this.lin_ = TsData.subtract(interp, regs);
        return this.lin_.clone();
    }

    public TsData linearizedSeries(boolean includeUndefinedReg) {
        TsData s = this.linearizedSeries();
        if (includeUndefinedReg) {
            TsData reg = this.userEffect(s.getDomain(), ComponentType.Undefined);
            s = TsData.add(s, reg);
        }
        return s;
    }

    public <T extends ITsVariable> TsData preadjustmentEffect(TsDomain domain) {
        if (this.description.hasFixedEffects()) {
            DataBlock reg = PreadjustmentVariable.regressionEffect(this.description.preadjustmentVariables(), domain);
            return new TsData(domain.getStart(), reg);
        }
        return null;
    }

    public <T extends ITsVariable> TsData preadjustmentEffect(TsDomain domain, ComponentType type) {
        if (this.description.hasFixedEffects()) {
            DataBlock reg = PreadjustmentVariable.regressionEffect(this.description.preadjustmentVariables(), domain, type);
            return new TsData(domain.getStart(), reg);
        }
        return null;
    }

    public TsData regressionEffect(TsDomain domain) {
        if (this.estimation == null) {
            return null;
        }
        double[] coeffs = this.estimation.getLikelihood().getB();
        if (coeffs == null) {
            return new TsData(domain, 0.0);
        }
        int istart = this.description.getRegressionVariablesStartingPosition();
        TsVariableSelection<ITsVariable> sel = this.vars().all();
        DataBlock sum = sel.sum(new DataBlock(coeffs, istart, coeffs.length, 1), domain);
        if (sum == null) {
            sum = new DataBlock(domain.getLength());
        }
        TsData rslt = new TsData(domain.getStart(), sum.getData(), false);
        return rslt;
    }

    public <T extends ITsVariable> TsData preadjustmentEffect(TsDomain domain, Class<T> tclass) {
        if (this.description.hasFixedEffects()) {
            DataBlock reg = PreadjustmentVariable.regressionEffect(this.description.preadjustmentVariables(), domain, tclass);
            return new TsData(domain.getStart(), reg);
        }
        return null;
    }

    public <T extends ITsVariable> TsData regressionEffect(TsDomain domain, Class<T> tclass) {
        int istart;
        if (this.estimation == null) {
            return null;
        }
        TsVariableSelection<ITsVariable> sel = this.vars().selectCompatible(tclass);
        if (sel.isEmpty()) {
            return new TsData(domain, 0.0);
        }
        double[] coeffs = this.estimation.getLikelihood().getB();
        DataBlock sum = sel.sum(new DataBlock(coeffs, istart = this.description.getRegressionVariablesStartingPosition(), coeffs.length, 1), domain);
        if (sum == null) {
            sum = new DataBlock(domain.getLength());
        }
        TsData rslt = new TsData(domain.getStart(), sum.getData(), false);
        return rslt;
    }

    public <T extends ITsVariable> TsData preadjustmentEffect(TsDomain domain, Predicate<PreadjustmentVariable> selector) {
        if (this.description.hasFixedEffects()) {
            DataBlock reg = PreadjustmentVariable.regressionEffect(this.description.preadjustmentVariables(), domain, selector);
            return new TsData(domain.getStart(), reg);
        }
        return null;
    }

    private TsData regressionEffect(TsDomain domain, Predicate<Variable> selector) {
        if (this.estimation == null) {
            return null;
        }
        double[] coeffs = this.estimation.getLikelihood().getB();
        if (coeffs == null) {
            return new TsData(domain, 0.0);
        }
        TsVariableSelection sel = this.description.buildRegressionVariables(selector);
        if (sel.isEmpty()) {
            return new TsData(domain, 0.0);
        }
        DataBlock sum = sel.sum(new DataBlock(coeffs, this.description.getRegressionVariablesStartingPosition(), coeffs.length, 1), domain);
        TsData rslt = new TsData(domain.getStart(), sum.getData(), false);
        return rslt;
    }

    public TsData deterministicEffect(TsDomain domain) {
        return TsData.add(this.regressionEffect(domain), this.preadjustmentEffect(domain));
    }

    public TsData deterministicEffect(TsDomain domain, Predicate<ITsVariable> selector) {
        return TsData.add(this.regressionEffect(domain, (Variable reg) -> selector.test(reg.getVariable())), this.preadjustmentEffect(domain, (PreadjustmentVariable reg) -> selector.test(reg.getVariable())));
    }

    public <T extends ITsVariable> TsData deterministicEffect(TsDomain domain, Class<T> tclass) {
        return TsData.add(this.regressionEffect(domain, tclass), this.preadjustmentEffect(domain, tclass));
    }

    public TsData tradingDaysEffect(TsDomain domain) {
        return this.deterministicEffect(domain, (ITsVariable var) -> var instanceof ICalendarVariable);
    }

    public TsData movingHolidaysEffect(TsDomain domain) {
        return this.deterministicEffect(domain, (ITsVariable var) -> var instanceof IMovingHolidayVariable);
    }

    public TsData outliersEffect(TsDomain domain) {
        return this.deterministicEffect(domain, IOutlierVariable.class);
    }

    public TsData outliersEffect(TsDomain domain, ComponentType type) {
        if (this.estimation == null) {
            return null;
        }
        if (type == ComponentType.Undefined) {
            return this.outliersEffect(domain);
        }
        return this.deterministicEffect(domain, (ITsVariable var) -> var instanceof IOutlierVariable && type == Variable.searchType((IOutlierVariable)var));
    }

    public OutlierEstimation[] outliersEstimation(boolean unbiased, boolean prespecified) {
        ConcentratedLikelihood ll = this.estimation.getLikelihood();
        if (ll == null) {
            return null;
        }
        double[] b = ll.getB();
        if (b == null) {
            return NO_OUTLIER;
        }
        int nhp = this.description.getArimaComponent().getFreeParametersCount();
        double[] se = ll.getBSer(unbiased, nhp);
        int istart = this.description.getRegressionVariablesStartingPosition();
        TsVariableSelection<IOutlierVariable> sel = this.vars().select(IOutlierVariable.class);
        ArrayList<OutlierEstimation> o = new ArrayList<OutlierEstimation>();
        for (TsVariableSelection.Item<IOutlierVariable> cur : sel.elements()) {
            if (prespecified != this.description.isPrespecified((IOutlierVariable)cur.variable)) continue;
            int rpos = cur.position + istart;
            CoefficientEstimation c = new CoefficientEstimation(b[rpos], se[rpos]);
            o.add(new OutlierEstimation(c, (IOutlierVariable)cur.variable, this.description.getEstimationDomain().getFrequency()));
        }
        return o.isEmpty() ? NO_OUTLIER : Jdk6.Collections.toArray(o, OutlierEstimation.class);
    }

    public List<TsData> regressors(TsDomain domain) {
        ArrayList<TsData> regs = new ArrayList<TsData>();
        List<DataBlock> data = this.vars().all().data(domain);
        for (DataBlock d : data) {
            double[] cur = new double[domain.getLength()];
            d.copyTo(cur, 0);
            regs.add(new TsData(domain.getStart(), cur, false));
        }
        return regs;
    }

    public TsData deterministicEffect(TsDomain domain, ComponentType type) {
        return TsData.add(this.regressionEffect(domain, (Variable reg) -> reg.type == type), this.preadjustmentEffect(domain, (PreadjustmentVariable reg) -> reg.getType() == type));
    }

    public TsData userEffect(TsDomain domain, ComponentType type) {
        return TsData.add(this.regressionEffect(domain, (Variable reg) -> reg.isUser() && reg.type == type), this.preadjustmentEffect(domain, (PreadjustmentVariable reg) -> reg.isUser() && reg.getType() == type));
    }

    public TsData userEffect(TsDomain domain) {
        return TsData.add(this.regressionEffect(domain, (Variable reg) -> reg.isUser()), this.preadjustmentEffect(domain, (PreadjustmentVariable reg) -> reg.isUser()));
    }

    public TsData linearizedForecast(int nf) {
        if (this.fcast_ != null && nf <= this.fcast_.getLength()) {
            return this.fcast_.drop(0, this.fcast_.getLength() - nf);
        }
        TsData s = this.linearizedSeries(false);
        DataBlock data = new DataBlock(s.internalStorage());
        double mean = this.description.isEstimatedMean() ? this.estimation.getLikelihood().getB()[0] : this.description.getArimaComponent().getMeanCorrection();
        UscbForecasts fcast = new UscbForecasts(this.estimation.getArima(), mean);
        double[] forecasts = fcast.forecasts(data, nf);
        TsData fs = new TsData(s.getEnd(), forecasts, false);
        this.fcast_ = fs.clone();
        return fs;
    }

    public TsData linearizedForecast(int nf, boolean includeUndefinedReg) {
        TsData s = this.linearizedForecast(nf);
        if (includeUndefinedReg) {
            TsData reg = this.userEffect(s.getDomain(), ComponentType.Undefined);
            s = TsData.add(s, reg);
        }
        return s;
    }

    public TsData linearizedBackcast(int nf, boolean includeUndefinedReg) {
        TsData s = this.linearizedBackcast(nf);
        if (includeUndefinedReg) {
            TsData reg = this.userEffect(s.getDomain(), ComponentType.Undefined);
            s = TsData.add(s, reg);
        }
        return s;
    }

    public Forecasts forecasts(int nf) {
        if (this.xfcasts_ != null && nf <= this.xfcasts_.getForecastsCount()) {
            return this.xfcasts_;
        }
        this.xfcasts_ = new Forecasts();
        TsDomain fdomain = new TsDomain(this.description.getSeriesDomain().getEnd(), nf);
        RegArimaEstimation<SarimaModel> est = new RegArimaEstimation<SarimaModel>(this.estimation.getRegArima(), this.estimation.getLikelihood());
        this.xfcasts_.calcForecast(est, this.vars().all().data(fdomain), nf, this.description.getArimaComponent().getFreeParametersCount());
        return this.xfcasts_;
    }

    public TsData linearizedBackcast(int nb) {
        if (this.bcast_ != null && nb <= this.bcast_.getLength()) {
            return this.bcast_.drop(this.bcast_.getLength() - nb, 0);
        }
        TsData s = this.linearizedSeries(false);
        DataBlock data = new DataBlock(s.internalStorage()).reverse();
        double mean = this.description.isEstimatedMean() ? this.estimation.getLikelihood().getB()[0] : this.description.getArimaComponent().getMeanCorrection();
        UscbForecasts fcast = new UscbForecasts(this.estimation.getArima(), mean);
        double[] backcasts = fcast.forecasts(data, nb);
        Arrays2.reverse(backcasts);
        TsData bs = new TsData(s.getStart().minus(nb), backcasts, false);
        this.bcast_ = bs.clone();
        return bs;
    }

    public TsData forecast(int nf, boolean transformed) {
        TsData f = this.linearizedForecast(nf);
        TsData c = this.deterministicEffect(f.getDomain());
        TsData r = TsData.add(f, c);
        if (!transformed) {
            this.backTransform(r, true, true);
        }
        return r;
    }

    public TsData backcast(int nb, boolean transformed) {
        TsData b = this.linearizedBackcast(nb);
        TsData c = this.deterministicEffect(b.getDomain());
        TsData r = TsData.add(b, c);
        if (!transformed) {
            this.backTransform(r, true, true);
        }
        return r;
    }

    public DeterministicComponent getDeterministicComponent() {
        DeterministicComponent det = new DeterministicComponent();
        det.setOriginal(this.description.getOriginal());
        det.setY(this.interpolatedSeries(true));
        det.setLengthOfPeriodAdjustment(this.description.getLengthOfPeriodType());
        det.setTransformation(this.description.getTransformation());
        det.setUnits(this.description.getUnits());
        this.description.preadjustmentVariables().forEach(var -> det.add((PreadjustmentVariable)var));
        if (this.estimation == null) {
            return null;
        }
        double[] coeffs = this.estimation.getLikelihood().getB();
        if (coeffs != null) {
            int cur = this.description.getRegressionVariablesStartingPosition();
            List<Variable> vars = this.description.getOrderedVariables();
            for (Variable var2 : vars) {
                int ncur = cur += var2.getVariable().getDim();
                PreadjustmentVariable pvar = PreadjustmentVariable.fix(var2, Arrays.copyOfRange(coeffs, cur, ncur));
                det.add(pvar);
                cur = ncur;
            }
        }
        return det;
    }

    @Override
    public Map<String, Class> getDictionary() {
        return PreprocessingModel.dictionary(false);
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        if (MAPPING.contains(id)) {
            return MAPPING.getData(this, id, tclass);
        }
        if (this.estimation.contains(id)) {
            return this.estimation.getData(id, tclass);
        }
        if (this.info_ != null) {
            if (!id.contains(InformationSet.STRSEP)) {
                return this.info_.deepSearch(id, tclass);
            }
            return this.info_.search(id, tclass);
        }
        return null;
    }

    @Override
    public <T> Map<String, T> searchAll(String wc, Class<T> tclass) {
        Map<String, T> all = MAPPING.searchAll(this, wc, tclass);
        if (this.info_ != null) {
            List<Information<T>> sel = this.info_.select(wc, tclass);
            for (Information<T> info : sel) {
                all.put(info.name, info.value);
            }
        }
        Map<String, T> eall = this.estimation.searchAll(wc, tclass);
        all.putAll(eall);
        return all;
    }

    @Override
    public boolean contains(String id) {
        if (MAPPING.contains(id)) {
            return true;
        }
        if (this.estimation.contains(id)) {
            return true;
        }
        if (this.info_ != null) {
            if (!id.contains(InformationSet.STRSEP)) {
                return this.info_.deepSearch(id, Object.class) != null;
            }
            return this.info_.search(id, Object.class) != null;
        }
        return false;
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return this.log_ == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.log_);
    }

    public static void fillDictionary(String prefix, Map<String, Class> map, boolean compact) {
        MAPPING.fillDictionary(prefix, map, compact);
        ModelEstimation.fillDictionary(prefix, map, compact);
    }

    public static Map<String, Class> dictionary(boolean compact) {
        LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
        PreprocessingModel.fillDictionary(null, map, compact);
        return map;
    }

    private TsData op(TsData l, TsData r) {
        if (this.description.getTransformation() == DefaultTransformationType.Log) {
            return TsData.multiply(l, r);
        }
        return TsData.add(l, r);
    }

    private TsData inv_op(TsData l, TsData r) {
        if (this.description.getTransformation() == DefaultTransformationType.Log) {
            return TsData.divide(l, r);
        }
        return TsData.subtract(l, r);
    }

    public TsData getForecastError() {
        double[] ef;
        TsDomain fdomain = this.domain(true);
        Forecasts fcasts = this.forecasts(fdomain.getLength());
        if (this.isMultiplicative()) {
            LogForecasts lf = new LogForecasts(fcasts);
            ef = lf.getForecastStdevs();
        } else {
            ef = fcasts.getForecastStdevs();
        }
        return new TsData(fdomain.getStart(), ef, true);
    }

    private TsData getTde(boolean fcast) {
        TsDomain fdom = this.domain(fcast);
        TsData tmp = this.tradingDaysEffect(fdom);
        if (tmp == null) {
            return null;
        }
        this.backTransform(tmp, false, true);
        return tmp;
    }

    private TsData getYcal(boolean fcast) {
        return this.inv_op(fcast ? this.forecast(this.getForecastCount(), false) : this.interpolatedSeries(false), this.getCal(fcast));
    }

    private TsData getReg(boolean fcast) {
        TsData tmp = this.userEffect(this.domain(fcast));
        if (tmp == null) {
            return null;
        }
        this.backTransform(tmp, false, false);
        return tmp;
    }

    private TsData getReg(ComponentType componentType, boolean fcast) {
        TsData tmp = this.userEffect(this.domain(fcast), componentType);
        if (tmp == null) {
            return null;
        }
        this.backTransform(tmp, false, false);
        return tmp;
    }

    private TsData getOutlier(ComponentType componentType, boolean fcast) {
        TsData tmp = this.outliersEffect(this.domain(fcast), componentType);
        if (tmp == null) {
            return null;
        }
        this.backTransform(tmp, false, false);
        return tmp;
    }

    private TsData getOmhe(boolean fcast) {
        TsData tmp = this.inv_op(this.getMhe(fcast), this.op(this.getEe(fcast), this.getRmde(fcast)));
        if (tmp == null) {
            return null;
        }
        return tmp;
    }

    private TsData getMhe(boolean fcast) {
        TsData tmp = this.movingHolidaysEffect(this.domain(fcast));
        if (tmp == null) {
            return null;
        }
        this.backTransform(tmp, false, false);
        return tmp;
    }

    private TsData getEe(boolean fcast) {
        TsData tmp = this.deterministicEffect(this.domain(fcast), IEasterVariable.class);
        if (tmp == null) {
            return null;
        }
        this.backTransform(tmp, false, false);
        return tmp;
    }

    private TsData getDet(boolean fcast) {
        TsData tmp = this.deterministicEffect(this.domain(fcast));
        if (tmp == null) {
            return null;
        }
        this.backTransform(tmp, false, true);
        return tmp;
    }

    private TsData getCal(boolean fcast) {
        TsData tmp = this.op(this.getTde(fcast), this.getMhe(fcast));
        if (tmp == null) {
            return null;
        }
        return tmp;
    }

    private TsData getRmde(boolean fcast) {
        return null;
    }

    private int getForecastCount() {
        int n = this.ncasts >= 0 ? this.ncasts : -this.ncasts * this.description.getFrequency();
        return n;
    }

    private TsDomain domain(boolean fcast) {
        if (fcast) {
            TsDomain dom = this.description.getSeriesDomain();
            return new TsDomain(dom.getEnd(), this.getForecastCount());
        }
        return this.description.getSeriesDomain();
    }

    public TsData getFullResiduals() {
        if (this.fullres_ == null) {
            TsDomain domain = this.domain(false);
            DataBlock res = this.estimation.getFullResiduals();
            double[] xres = new double[res.getLength()];
            res.copyTo(xres, 0);
            this.fullres_ = new TsData(domain.getStart().plus(domain.getLength() - xres.length), xres, false);
        }
        return this.fullres_;
    }

    private TsVariableList vars() {
        if (this.x_ == null) {
            this.x_ = this.description.buildRegressionVariables();
        }
        return this.x_;
    }

    public boolean isMultiplicative() {
        return this.description.getTransformation() == DefaultTransformationType.Log;
    }

    public TsFrequency getFrequency() {
        return this.description.getEstimationDomain().getFrequency();
    }

    public <V extends ITsVariable> RegressionItem getRegressionItem(Class<V> tclass, int vpos) {
        int l;
        int cur;
        TsVariableSelection<V> sel = this.vars().select(tclass);
        if (sel.isEmpty()) {
            return null;
        }
        int nhp = this.description.getArimaComponent().getFreeParametersCount();
        int df = this.estimation.getLikelihood().getDegreesOfFreedom(true, nhp);
        T tstat = new T();
        tstat.setDegreesofFreedom(df);
        for (cur = 0; cur < sel.getItemsCount() && vpos >= (l = sel.get((int)cur).variable.getDim()); ++cur, vpos -= l) {
        }
        if (cur == sel.getItemsCount()) {
            return null;
        }
        TsVariableSelection.Item<V> item = sel.get(cur);
        TsFrequency context = this.description.getEstimationDomain().getFrequency();
        int pos = this.description.getRegressionVariablesStartingPosition() + item.position + vpos;
        double c = this.estimation.getLikelihood().getB()[pos];
        double e = this.estimation.getLikelihood().getBSer(pos, true, nhp);
        double t = c / e;
        double prob = 1.0 - tstat.getProbabilityForInterval(-t, t);
        return new RegressionItem(item.variable.getItemDescription(vpos, context), c, e, prob);
    }

    public static InformationMapping<PreprocessingModel> getMapping() {
        return MAPPING;
    }

    public static <T> void setMapping(String name, Class<T> tclass, Function<PreprocessingModel, T> extractor) {
        MAPPING.set(name, tclass, extractor);
    }

    public static <T> void setTsData(String name, Function<PreprocessingModel, TsData> extractor) {
        MAPPING.set(name, extractor);
    }

    private static int nperiods(PreprocessingModel m, int n) {
        if (n >= 0) {
            return n;
        }
        return -n * m.getFrequency().intValue();
    }

    static {
        MAPPING.set(PERIOD, Integer.class, source -> source.description.getFrequency());
        MAPPING.set(InformationSet.item(SPAN, START), TsPeriod.class, source -> source.description.getSeriesDomain().getStart());
        MAPPING.set(InformationSet.item(SPAN, END), TsPeriod.class, source -> source.description.getSeriesDomain().getLast());
        MAPPING.set(InformationSet.item(SPAN, N), Integer.class, source -> source.description.getSeriesDomain().getLength());
        MAPPING.set(InformationSet.item(SPAN, NM), Integer.class, source -> source.description.getOriginal().getMissingValuesCount());
        MAPPING.set(InformationSet.item(ESPAN, START), TsPeriod.class, source -> source.description.getEstimationDomain().getStart());
        MAPPING.set(InformationSet.item(ESPAN, END), TsPeriod.class, source -> source.description.getEstimationDomain().getLast());
        MAPPING.set(InformationSet.item(ESPAN, N), Integer.class, source -> source.description.getEstimationDomain().getLength());
        MAPPING.set(LOG, Boolean.class, source -> source.isMultiplicative());
        MAPPING.set(ADJUST, Boolean.class, source -> {
            if (source.description.getPreadjustmentType() == PreadjustmentType.None) {
                return null;
            }
            return source.description.getLengthOfPeriodType() != LengthOfPeriodType.None;
        });
        MAPPING.set("y", source -> source.description.getOriginal());
        MAPPING.set("y_f", source -> source.forecast(source.getForecastCount(), false));
        MAPPING.set("y_ef", source -> source.getForecastError());
        MAPPING.set("yc", source -> source.interpolatedSeries(false));
        MAPPING.set("yc_f", source -> source.forecast(source.getForecastCount(), false));
        MAPPING.set("yc_ef", source -> source.getForecastError());
        MAPPING.set("l", source -> source.linearizedSeries(false));
        MAPPING.set("y_lin", source -> source.linearizedSeries(true));
        MAPPING.set("y_lin_f", source -> source.linearizedForecast(source.domain(true).getLength(), true));
        MAPPING.set("ycal", source -> source.getYcal(false));
        MAPPING.set("ycal_f", source -> source.getYcal(true));
        MAPPING.set("det", source -> source.getDet(false));
        MAPPING.set("det_f", source -> source.getDet(true));
        MAPPING.set("l_f", source -> source.linearizedForecast(source.getForecastCount()));
        MAPPING.set("l_b", source -> source.linearizedBackcast(source.description.getFrequency()));
        MAPPING.set("cal", source -> source.getCal(false));
        MAPPING.set("cal_f", source -> source.getCal(true));
        MAPPING.set("tde", source -> source.getTde(false));
        MAPPING.set("tde_f", source -> source.getTde(true));
        MAPPING.set("mhe", source -> source.getMhe(false));
        MAPPING.set("mhe_f", source -> source.getMhe(true));
        MAPPING.set("ee", source -> source.getEe(false));
        MAPPING.set("ee_f", source -> source.getEe(true));
        MAPPING.set("omhe", source -> source.getOmhe(false));
        MAPPING.set("omhe_f", source -> source.getOmhe(true));
        MAPPING.set(OUT, source -> source.getOutlier(ComponentType.Undefined, false));
        MAPPING.set("out_f", source -> source.getOutlier(ComponentType.Undefined, true));
        MAPPING.set("out_i", source -> source.getOutlier(ComponentType.Irregular, false));
        MAPPING.set("out_i_f", source -> source.getOutlier(ComponentType.Irregular, true));
        MAPPING.set("out_t", source -> source.getOutlier(ComponentType.Trend, false));
        MAPPING.set("out_t_f", source -> source.getOutlier(ComponentType.Trend, true));
        MAPPING.set("out_s", source -> source.getOutlier(ComponentType.Seasonal, false));
        MAPPING.set("out_s_f", source -> source.getOutlier(ComponentType.Seasonal, true));
        MAPPING.set("reg", source -> source.getReg(false));
        MAPPING.set("reg_f", source -> source.getReg(true));
        MAPPING.set("reg_t", source -> source.getReg(ComponentType.Trend, false));
        MAPPING.set("reg_t_f", source -> source.getReg(ComponentType.Trend, true));
        MAPPING.set("reg_s", source -> source.getReg(ComponentType.Seasonal, false));
        MAPPING.set("reg_s_f", source -> source.getReg(ComponentType.Seasonal, true));
        MAPPING.set("reg_i", source -> source.getReg(ComponentType.Irregular, false));
        MAPPING.set("reg_i_f", source -> source.getReg(ComponentType.Irregular, true));
        MAPPING.set("reg_sa", source -> source.getReg(ComponentType.SeasonallyAdjusted, false));
        MAPPING.set("reg_sa_f", source -> source.getReg(ComponentType.SeasonallyAdjusted, true));
        MAPPING.set("reg_y", source -> source.getReg(ComponentType.Series, false));
        MAPPING.set("reg_y_f", source -> source.getReg(ComponentType.Series, true));
        MAPPING.set("reg_u", source -> source.getReg(ComponentType.Undefined, false));
        MAPPING.set("reg_u_f", source -> source.getReg(ComponentType.Undefined, true));
        MAPPING.set(FULLRES, source -> source.getFullResiduals());
        MAPPING.set(InformationSet.item(REGRESSION, LP), RegressionItem.class, source -> source.getRegressionItem(ILengthOfPeriodVariable.class, 0));
        MAPPING.set(InformationSet.item(REGRESSION, NTD), Integer.class, source -> source.description.countRegressors(var -> var.status.isSelected() && var.getVariable() instanceof ICalendarVariable));
        MAPPING.set(InformationSet.item(REGRESSION, NMH), Integer.class, source -> source.description.countRegressors(var -> var.status.isSelected() && var.getVariable() instanceof IMovingHolidayVariable));
        MAPPING.setList(InformationSet.item(REGRESSION, TD), 1, 15, RegressionItem.class, (source, i) -> source.getRegressionItem(ITradingDaysVariable.class, i - 1));
        MAPPING.set(InformationSet.item(REGRESSION, TD_DERIVED), RegressionItem.class, source -> {
            TsVariableSelection<ITsVariable> regs = source.x_.select(var -> var instanceof ITradingDaysVariable);
            if (regs.isEmpty() || regs.getItemsCount() > 1) {
                return null;
            }
            TsVariableSelection.Item<ITsVariable> reg = regs.elements()[0];
            int ndim = reg.variable.getDim();
            if (ndim <= 1) {
                return null;
            }
            ConcentratedLikelihood ll = source.estimation.getLikelihood();
            int nhp = source.description.getArimaComponent().getFreeParametersCount();
            int start = source.description.getRegressionVariablesStartingPosition();
            double[] b = ll.getB();
            int k0 = start + reg.position;
            int k1 = k0 + ndim;
            double bd = 0.0;
            for (int k = k0; k < k1; ++k) {
                bd -= b[k];
            }
            double var2 = ll.getBVar(true, nhp).subMatrix(k0, k1, k0, k1).sum();
            double tval = bd / Math.sqrt(var2);
            T t = new T();
            t.setDegreesofFreedom(ll.getDegreesOfFreedom(true, nhp));
            double prob = 1.0 - t.getProbabilityForInterval(-tval, tval);
            return new RegressionItem(TD_DERIVED, bd, Math.sqrt(var2), prob);
        });
        MAPPING.set(InformationSet.item(REGRESSION, TD_FTEST), Double.class, source -> {
            TsVariableSelection<ITsVariable> regs = source.x_.select(var -> var instanceof ITradingDaysVariable);
            if (regs.isEmpty()) {
                return null;
            }
            int nvars = regs.getVariablesCount();
            if (regs.getItemsCount() == 1 && nvars > 1) {
                try {
                    JointRegressionTest jtest = new JointRegressionTest(0.05);
                    jtest.accept(source.estimation.getLikelihood(), source.description.getArimaComponent().getFreeParametersCount(), source.description.getRegressionVariablesStartingPosition() + regs.get((int)0).position, nvars, null);
                    return jtest.getTest().getPValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        });
        MAPPING.set(InformationSet.item(REGRESSION, EASTER), RegressionItem.class, source -> source.getRegressionItem(IEasterVariable.class, 0));
        MAPPING.set(InformationSet.item(REGRESSION, NOUT), Integer.class, source -> source.description.getOutliers().size() + source.description.getPrespecifiedOutliers().size());
        MAPPING.set(InformationSet.item(REGRESSION, NOUTAO), Integer.class, source -> {
            TsVariableList vars = source.vars();
            return vars.select(OutlierType.AO).getItemsCount();
        });
        MAPPING.set(InformationSet.item(REGRESSION, NOUTLS), Integer.class, source -> {
            TsVariableList vars = source.vars();
            return vars.select(OutlierType.LS).getItemsCount();
        });
        MAPPING.set(InformationSet.item(REGRESSION, NOUTTC), Integer.class, source -> {
            TsVariableList vars = source.vars();
            return vars.select(OutlierType.TC).getItemsCount();
        });
        MAPPING.set(InformationSet.item(REGRESSION, NOUTSO), Integer.class, source -> {
            TsVariableList vars = source.vars();
            return vars.select(OutlierType.SO).getItemsCount();
        });
        MAPPING.setList(InformationSet.item(REGRESSION, OUT), 1, 31, RegressionItem.class, (source, i) -> source.getRegressionItem(IOutlierVariable.class, i - 1));
        MAPPING.setList(InformationSet.item(REGRESSION, USER), 1, 31, RegressionItem.class, (source, i) -> source.getRegressionItem(IUserTsVariable.class, i - 1));
        MAPPING.set(InformationSet.item(REGRESSION, COEFF), Parameter[].class, source -> {
            double[] c = source.estimation.getLikelihood().getB();
            if (c == null) {
                return new Parameter[0];
            }
            Parameter[] C = new Parameter[c.length];
            double[] e = source.estimation.getLikelihood().getBSer(true, source.description.getArimaComponent().getFreeParametersCount());
            for (int i = 0; i < C.length; ++i) {
                Parameter p = new Parameter(c[i], ParameterType.Estimated);
                p.setStde(e[i]);
                C[i] = p;
            }
            return C;
        });
        MAPPING.set(InformationSet.item(REGRESSION, COEFFDESC), String[].class, source -> {
            int[] missings;
            ArrayList<String> str = new ArrayList<String>();
            if (source.description.isEstimatedMean()) {
                str.add("Mean");
            }
            if ((missings = source.description.getMissingValues()) != null) {
                for (int i = 0; i < missings.length; ++i) {
                    int pos = missings[i];
                    TsPeriod period = source.description.getEstimationDomain().get(pos);
                    str.add("Missing: " + period.toString());
                }
            }
            ITsVariable[] items = source.vars().items();
            TsFrequency context = source.description.getEstimationDomain().getFrequency();
            for (ITsVariable var : items) {
                for (int j = 0; j < var.getDim(); ++j) {
                    str.add(var.getItemDescription(j, context));
                }
            }
            String[] desc = new String[str.size()];
            return str.toArray(desc);
        });
        MAPPING.set(InformationSet.item(REGRESSION, COVAR), Matrix.class, source -> source.estimation.getLikelihood().getBVar(true, source.description.getArimaComponent().getFreeParametersCount()));
        MAPPING.set(InformationSet.item(REGRESSION, PCOVAR), Matrix.class, source -> source.estimation.getParametersCovariance());
        MAPPING.set(FCASTS, -2, TsData.class, (source, i) -> source.forecast(PreprocessingModel.nperiods(source, i), false));
        MAPPING.set(BCASTS, -2, TsData.class, (source, i) -> source.backcast(PreprocessingModel.nperiods(source, i), false));
        MAPPING.set(LIN_FCASTS, -2, TsData.class, (source, i) -> source.linearizedForecast(PreprocessingModel.nperiods(source, i)));
        MAPPING.set(LIN_BCASTS, -2, TsData.class, (source, i) -> source.linearizedBackcast(PreprocessingModel.nperiods(source, i)));
        MAPPING.set(EFCASTS, -2, TsData.class, (source, i) -> {
            double[] ef;
            int np = PreprocessingModel.nperiods(source, i);
            TsDomain fdomain = new TsDomain(source.description.getSeriesDomain().getEnd(), np);
            Forecasts fcasts = source.forecasts(np);
            if (source.isMultiplicative()) {
                LogForecasts lf = new LogForecasts(fcasts);
                ef = lf.getForecastStdevs();
            } else {
                ef = fcasts.getForecastStdevs();
            }
            return new TsData(fdomain.getStart(), ef, true);
        });
    }
}

