/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.ISeriesDecomposition;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DefaultSeriesDecomposition
implements ISeriesDecomposition,
IProcResults {
    private final DecompositionMode mode;
    private static final int ncmps = EnumSet.allOf(ComponentType.class).size() - 1;
    private final TsData[] cmps_;
    private final TsData[] fcmps_;
    private final TsData[] ecmps_;
    private final TsData[] efcmps_;
    public static final String SPAN = "span";
    public static final String START = "start";
    public static final String END = "end";
    public static final String N = "n";
    private static final InformationMapping<DefaultSeriesDecomposition> MAPPING = new InformationMapping<DefaultSeriesDecomposition>(DefaultSeriesDecomposition.class);

    public DefaultSeriesDecomposition(DecompositionMode mode) {
        this.mode = mode;
        this.cmps_ = new TsData[ncmps];
        this.fcmps_ = new TsData[ncmps];
        this.ecmps_ = new TsData[ncmps];
        this.efcmps_ = new TsData[ncmps];
    }

    public void add(TsData data, ComponentType cmp) {
        this.add(data, cmp, ComponentInformation.Value);
    }

    public void add(TsData data, ComponentType cmp, ComponentInformation info) {
        int icmp = cmp.intValue() - 1;
        if (icmp < 0) {
            throw new TsException("Invalid component type");
        }
        switch (info) {
            case Stdev: {
                this.ecmps_[icmp] = data;
                break;
            }
            case Forecast: {
                this.fcmps_[icmp] = data;
                break;
            }
            case StdevForecast: {
                this.efcmps_[icmp] = data;
                break;
            }
            default: {
                this.cmps_[icmp] = data;
            }
        }
    }

    @Override
    public DecompositionMode getMode() {
        return this.mode;
    }

    @Override
    public TsData getSeries(ComponentType cmp, ComponentInformation info) {
        int icmp = cmp.intValue() - 1;
        if (icmp < 0) {
            return null;
        }
        switch (info) {
            case Stdev: {
                return this.ecmps_[icmp];
            }
            case Forecast: {
                return this.fcmps_[icmp];
            }
            case StdevForecast: {
                return this.efcmps_[icmp];
            }
        }
        return this.cmps_[icmp];
    }

    @Override
    public boolean contains(String id) {
        return MAPPING.contains(id);
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
        MAPPING.fillDictionary(null, map, false);
        return map;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        return MAPPING.getData(this, id, tclass);
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.EMPTY_LIST;
    }

    public static void fillDictionary(String prefix, Map<String, Class> map, boolean compact) {
        MAPPING.fillDictionary(prefix, map, compact);
    }

    public static InformationMapping<DefaultSeriesDecomposition> getMapping() {
        return MAPPING;
    }

    public static <T> void setMapping(String name, Class<T> tclass, Function<DefaultSeriesDecomposition, T> extractor) {
        MAPPING.set(name, tclass, extractor);
    }

    public static <T> void setTsData(String name, Function<DefaultSeriesDecomposition, TsData> extractor) {
        MAPPING.set(name, extractor);
    }

    static {
        MAPPING.set("y", source -> source.getSeries(ComponentType.Series, ComponentInformation.Value));
        MAPPING.set("y_f", source -> source.getSeries(ComponentType.Series, ComponentInformation.Forecast));
        MAPPING.set("t", source -> source.getSeries(ComponentType.Trend, ComponentInformation.Value));
        MAPPING.set("t_f", source -> source.getSeries(ComponentType.Trend, ComponentInformation.Forecast));
        MAPPING.set("sa", source -> source.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value));
        MAPPING.set("sa_f", source -> source.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast));
        MAPPING.set("s", source -> source.getSeries(ComponentType.Seasonal, ComponentInformation.Value));
        MAPPING.set("s_f", source -> source.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast));
        MAPPING.set("i", source -> source.getSeries(ComponentType.Irregular, ComponentInformation.Value));
        MAPPING.set("i_f", source -> source.getSeries(ComponentType.Irregular, ComponentInformation.Forecast));
        MAPPING.set("mode", DecompositionMode.class, source -> source.getMode());
    }
}

