/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.analysis;

import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.timeseries.analysis.DiagnosticException;
import ec.tstoolkit.timeseries.analysis.DiagnosticInfo;
import ec.tstoolkit.timeseries.analysis.ITsProcessing;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.Arrays2;
import ec.tstoolkit.utilities.Jdk6;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SlidingSpans<I extends IProcResults> {
    private Node<I>[] m_estimation;
    private final ITsProcessing<I> m_processing;
    private final TsDomain m_domainT;
    private final I m_reference;
    private int m_spanLength = 8;
    private int m_spanCount = 4;
    private final int m_spanDistance = 1;
    private int m_spanMin = 2;

    public SlidingSpans(ITsProcessing<I> processing, TsDomain domain) {
        this.m_processing = processing;
        this.m_domainT = domain;
        this.m_reference = processing.process(this.m_domainT);
    }

    private void addDel(int p, HashMap<TsPeriod, MaxMin> buffer, TsData data) {
        TsPeriod start = data.getStart();
        double[] obs = data.internalStorage();
        for (int i = p; i < obs.length; ++i) {
            TsPeriod cur = start.plus(i);
            MaxMin Mm = buffer.get(cur);
            if (Mm == null) {
                Mm = new MaxMin();
                buffer.put(cur, Mm);
            }
            Mm.add(obs[i] - obs[i - p]);
        }
    }

    private void addPct(int p, HashMap<TsPeriod, MaxMin> buffer, TsData data) {
        TsPeriod start = data.getStart();
        double[] obs = data.internalStorage();
        for (int i = p; i < obs.length; ++i) {
            TsPeriod cur = start.plus(i);
            MaxMin Mm = buffer.get(cur);
            if (Mm == null) {
                Mm = new MaxMin();
                buffer.put(cur, Mm);
            }
            Mm.add(obs[i] / obs[i - p]);
        }
    }

    private void addValue(HashMap<TsPeriod, MaxMin> buffer, TsData data) {
        TsPeriod start = data.getStart();
        double[] obs = data.internalStorage();
        for (int i = 0; i < obs.length; ++i) {
            TsPeriod cur = start.plus(i);
            MaxMin Mm = buffer.get(cur);
            if (Mm == null) {
                Mm = new MaxMin();
                buffer.put(cur, Mm);
            }
            Mm.add(obs[i]);
        }
    }

    public int getMaxSpanCount() {
        return this.m_spanCount;
    }

    public int getMinSpanCount() {
        return this.m_spanMin;
    }

    public ITsProcessing<I> getProcessing() {
        return this.m_processing;
    }

    public I getReferenceInfo() {
        return this.m_reference;
    }

    public TsDomain getReferenceDomain() {
        return this.m_domainT;
    }

    public int getSpanCount() {
        if (this.m_estimation == null && !this.process()) {
            return 0;
        }
        return this.m_estimation.length;
    }

    public int getSpanLength() {
        return this.m_spanLength;
    }

    public I info(int idx) {
        if (this.m_estimation == null && !this.process()) {
            return null;
        }
        return (I)(this.m_estimation.length <= idx ? null : (IProcResults)this.m_estimation[idx].estimation);
    }

    public TsDomain getDomain(int idx) {
        if (this.m_estimation == null && !this.process()) {
            return null;
        }
        return this.m_estimation.length <= idx ? null : this.m_estimation[idx].domain;
    }

    public boolean isValid() {
        if (this.m_estimation == null && !this.process()) {
            return false;
        }
        return this.m_estimation.length >= this.m_spanMin;
    }

    public boolean process() {
        if (this.m_estimation != null) {
            return true;
        }
        ArrayList rslts = new ArrayList();
        int freq = this.m_domainT.getFrequency().intValue();
        int length = this.m_spanLength * freq;
        TsPeriod start = this.m_domainT.getLast().minus(length - 1);
        if (start.getPosition() != 0) {
            length += start.getPosition();
            start.move(-start.getPosition());
        }
        for (int idx = 0; idx < this.m_spanCount && start.isNotBefore(this.m_domainT.getStart()); ++idx) {
            try {
                TsDomain cur = new TsDomain(start, length);
                I info = this.m_processing.process(cur);
                if (info == null) break;
                Node node = new Node();
                node.estimation = info;
                node.domain = cur;
                rslts.add(node);
                start.move(-1 * freq);
                continue;
            }
            catch (Exception err) {
                // empty catch block
                break;
            }
        }
        if (rslts.size() < this.m_spanMin) {
            return false;
        }
        this.m_estimation = Jdk6.Collections.toArray(rslts, Node.class);
        Arrays2.reverse(this.m_estimation);
        return true;
    }

    public TsData referenceSeries(String series) {
        if (this.m_reference == null) {
            return null;
        }
        return this.m_reference.getData(series, TsData.class);
    }

    public void setMaxSpanCount(int value) {
        if (value != this.m_spanCount) {
            this.m_estimation = null;
        }
        this.m_spanCount = value;
    }

    public void setMinSpanCount(int value) {
        if (value < 2) {
            throw new DiagnosticException("Invalid argument in sliding spans analysis ");
        }
        this.m_spanMin = value;
    }

    public void setSpanLength(int value) {
        if (value != this.m_spanLength) {
            this.m_estimation = null;
        }
        this.m_spanLength = value;
    }

    public TsData Statistics(String key, DiagnosticInfo info) {
        if (this.m_estimation == null && !this.process()) {
            return null;
        }
        if (this.getSpanCount() < this.getMinSpanCount()) {
            return null;
        }
        HashMap<TsPeriod, MaxMin> buffer = new HashMap<TsPeriod, MaxMin>();
        block6: for (int i = 0; i < this.m_estimation.length; ++i) {
            TsData data = ((IProcResults)this.m_estimation[i].estimation).getData(key, TsData.class);
            if (data == null) continue;
            switch (info) {
                case PeriodToPeriodGrowthDifference: {
                    this.addPct(1, buffer, data);
                    continue block6;
                }
                case AnnualGrowthDifference: {
                    this.addPct(data.getFrequency().intValue(), buffer, data);
                    continue block6;
                }
                case PeriodToPeriodDifference: {
                    this.addDel(1, buffer, data);
                    continue block6;
                }
                case AnnualDifference: {
                    this.addDel(data.getFrequency().intValue(), buffer, data);
                    continue block6;
                }
                default: {
                    this.addValue(buffer, data);
                }
            }
        }
        TsData rslt = new TsData(this.m_domainT);
        TsPeriod start = this.m_domainT.getStart();
        for (Map.Entry kv : buffer.entrySet()) {
            if (((MaxMin)kv.getValue()).count < this.m_spanMin) continue;
            int idx = ((TsPeriod)kv.getKey()).minus(start);
            rslt.set(idx, ((MaxMin)kv.getValue()).value(info));
        }
        return rslt.cleanExtremities();
    }

    private static class Node<I> {
        TsDomain domain;
        I estimation;

        private Node() {
        }
    }

    class MaxMin {
        double max;
        double min;
        int count;

        MaxMin() {
        }

        void add(double val) {
            if (this.count == 0) {
                this.max = val;
                this.min = val;
            } else {
                if (val > this.max) {
                    this.max = val;
                }
                if (val < this.min) {
                    this.min = val;
                }
            }
            ++this.count;
        }

        double value(DiagnosticInfo info) {
            if (info == DiagnosticInfo.RelativeDifference) {
                return (this.max - this.min) / this.min;
            }
            return this.max - this.min;
        }
    }
}

