/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.arima.x13.SingleOutlierSpec;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.utilities.Comparator;
import ec.tstoolkit.utilities.Jdk6;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class OutlierSpec
implements Cloneable,
InformationSetSerializable {
    public static final String SPAN = "span";
    public static final String AO = "ao";
    public static final String LS = "ls";
    public static final String TC = "tc";
    public static final String SO = "so";
    public static final String IO = "io";
    public static final String SLS = "sls";
    public static final String WO = "wo";
    public static final String TLS = "tls";
    public static final String DEFCV = "defcv";
    public static final String METHOD = "method";
    public static final String LSRUN = "lsrun";
    public static final String TCRATE = "tcrate";
    public static final String MAXITER = "maxiter";
    private ArrayList<SingleOutlierSpec> types_ = new ArrayList();
    private int lsrun_ = 0;
    private Method method_ = Method.AddOne;
    private double tc_ = 0.7;
    private double defcv_ = 0.0;
    private TsPeriodSelector span_ = new TsPeriodSelector();
    private int nmax_ = 30;
    public static final double DEF_TCRATE = 0.7;
    public static final double DEF_VA = 4.0;
    public static final int DEF_NMAX = 30;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, SPAN), TsPeriodSelector.class);
        dic.put(InformationSet.item(prefix, AO), Boolean.class);
        dic.put(InformationSet.item(prefix, LS), Boolean.class);
        dic.put(InformationSet.item(prefix, TC), Boolean.class);
        dic.put(InformationSet.item(prefix, SO), Boolean.class);
        dic.put(InformationSet.item(prefix, IO), Boolean.class);
        dic.put(InformationSet.item(prefix, SLS), Boolean.class);
        dic.put(InformationSet.item(prefix, WO), Boolean.class);
        dic.put(InformationSet.item(prefix, TLS), Boolean.class);
        dic.put(InformationSet.item(prefix, DEFCV), Double.class);
        dic.put(InformationSet.item(prefix, METHOD), String.class);
        dic.put(InformationSet.item(prefix, LSRUN), Integer.class);
        dic.put(InformationSet.item(prefix, TCRATE), Double.class);
        dic.put(InformationSet.item(prefix, MAXITER), Integer.class);
    }

    public void reset() {
        this.types_.clear();
        this.lsrun_ = 0;
        this.method_ = Method.AddOne;
        this.tc_ = 0.7;
        this.defcv_ = 0.0;
        this.span_ = new TsPeriodSelector();
        this.nmax_ = 30;
    }

    public boolean isUsed() {
        return !this.types_.isEmpty();
    }

    public int getTypesCount() {
        return this.types_.size();
    }

    public SingleOutlierSpec[] getTypes() {
        return Jdk6.Collections.toArray(this.types_, SingleOutlierSpec.class);
    }

    public void setTypes(SingleOutlierSpec[] value) {
        this.types_.clear();
        if (value != null) {
            for (SingleOutlierSpec sspec : value) {
                this.add(sspec);
            }
        }
    }

    public void clearTypes() {
        this.types_.clear();
    }

    public void add(OutlierType type) {
        SingleOutlierSpec spec = new SingleOutlierSpec();
        spec.setCriticalValue(this.defcv_);
        spec.setType(type);
        this.add(spec);
    }

    public void add(SingleOutlierSpec spec) {
        for (SingleOutlierSpec s : this.types_) {
            if (s.getType() != spec.getType()) continue;
            s.setCriticalValue(spec.getCriticalValue());
            return;
        }
        this.types_.add(spec);
    }

    public SingleOutlierSpec search(OutlierType type) {
        for (SingleOutlierSpec s : this.types_) {
            if (s.getType() != type) continue;
            return s;
        }
        return null;
    }

    public void remove(OutlierType type) {
        for (SingleOutlierSpec s : this.types_) {
            if (s.getType() != type) continue;
            this.types_.remove(s);
            return;
        }
    }

    public int getLSRun() {
        return this.lsrun_;
    }

    public void setLSRun(int value) {
        this.lsrun_ = value;
    }

    public int getMaxIter() {
        return this.nmax_;
    }

    @Deprecated
    public void seMaxIter(int value) {
        this.nmax_ = value;
    }

    public void setMaxIter(int value) {
        this.nmax_ = value;
    }

    public Method getMethod() {
        return this.method_;
    }

    public void setMethod(Method value) {
        this.method_ = value;
    }

    public TsPeriodSelector getSpan() {
        return this.span_;
    }

    public void setSpan(TsPeriodSelector value) {
        if (value == null) {
            this.span_.all();
        } else {
            this.span_ = value;
        }
    }

    public double getMonthlyTCRate() {
        return this.tc_;
    }

    public void setMonthlyTCRate(double value) {
        this.tc_ = value;
    }

    public double getDefaultCriticalValue() {
        return this.defcv_;
    }

    public void setDefaultCriticalValue(double value) {
        this.defcv_ = value;
        for (SingleOutlierSpec s : this.types_) {
            s.setCriticalValue(value);
        }
    }

    public OutlierSpec clone() {
        try {
            OutlierSpec spec = (OutlierSpec)super.clone();
            spec.types_ = new ArrayList();
            for (SingleOutlierSpec s : this.types_) {
                spec.types_.add(s.clone());
            }
            spec.span_ = this.span_.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof OutlierSpec && this.equals((OutlierSpec)obj);
    }

    private boolean equals(OutlierSpec other) {
        return this.defcv_ == other.defcv_ && this.lsrun_ == other.lsrun_ && this.method_ == other.method_ && Objects.equals(this.span_, other.span_) && this.nmax_ == other.nmax_ && this.tc_ == other.tc_ && Comparator.equals(this.types_, other.types_);
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode((Object)this.method_);
        hash = 71 * hash + Jdk6.Double.hashCode(this.tc_);
        hash = 71 * hash + Jdk6.Double.hashCode(this.defcv_);
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && !this.isUsed()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.span_.getType() != PeriodSelectorType.All) {
            info.add(SPAN, this.span_);
        }
        for (SingleOutlierSpec s : this.types_) {
            info.add(s.getType().name().toLowerCase(), Double.valueOf(s.getCriticalValue()));
        }
        if (verbose || this.defcv_ != 0.0) {
            info.add(DEFCV, Double.valueOf(this.defcv_));
        }
        if (verbose || this.method_ != Method.AddOne) {
            info.add(METHOD, this.method_.name());
        }
        if (verbose || this.lsrun_ != 0) {
            info.add(LSRUN, Integer.valueOf(this.lsrun_));
        }
        if (verbose || this.tc_ != 0.7) {
            info.add(TCRATE, Double.valueOf(this.tc_));
        }
        if (verbose || this.nmax_ != 30) {
            info.add(MAXITER, Integer.valueOf(this.nmax_));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            Integer nmax;
            Integer lsrun;
            String method;
            Double tcr;
            Double defcv;
            Double tls;
            Double wo;
            Double sls;
            Double io;
            Double so;
            Double tc;
            Double ls;
            Double ao;
            this.reset();
            TsPeriodSelector span = info.get(SPAN, TsPeriodSelector.class);
            if (span != null) {
                this.span_ = span;
            }
            if ((ao = info.get(AO, Double.class)) != null) {
                this.types_.add(new SingleOutlierSpec(OutlierType.AO, ao));
            }
            if ((ls = info.get(LS, Double.class)) != null) {
                this.types_.add(new SingleOutlierSpec(OutlierType.LS, ls));
            }
            if ((tc = info.get(TC, Double.class)) != null) {
                this.types_.add(new SingleOutlierSpec(OutlierType.TC, tc));
            }
            if ((so = info.get(SO, Double.class)) != null) {
                this.types_.add(new SingleOutlierSpec(OutlierType.SO, so));
            }
            if ((io = info.get(IO, Double.class)) != null) {
                this.types_.add(new SingleOutlierSpec(OutlierType.IO, io));
            }
            if ((sls = info.get(SLS, Double.class)) != null) {
                this.types_.add(new SingleOutlierSpec(OutlierType.SLS, sls));
            }
            if ((wo = info.get(WO, Double.class)) != null) {
                this.types_.add(new SingleOutlierSpec(OutlierType.WO, wo));
            }
            if ((tls = info.get(TLS, Double.class)) != null) {
                this.types_.add(new SingleOutlierSpec(OutlierType.TLS, tls));
            }
            if ((defcv = info.get(DEFCV, Double.class)) != null) {
                this.defcv_ = defcv;
            }
            if ((tcr = info.get(TCRATE, Double.class)) != null) {
                this.tc_ = tcr;
            }
            if ((method = info.get(METHOD, String.class)) != null) {
                this.method_ = Method.valueOf(method);
            }
            if ((lsrun = info.get(LSRUN, Integer.class)) != null) {
                this.lsrun_ = lsrun;
            }
            if ((nmax = info.get(MAXITER, Integer.class)) != null) {
                this.nmax_ = nmax;
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public static enum Method {
        AddOne,
        AddAll;

    }
}

