/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RegressionUtilities {
    public static List<DataBlock> data(ITsVariable var, TsDomain domain) {
        ArrayList<DataBlock> cols = new ArrayList<DataBlock>();
        int dim = var.getDim();
        for (int i = 0; i < dim; ++i) {
            cols.add(new DataBlock(domain.getLength()));
        }
        var.data(domain, cols);
        return cols;
    }

    public static Matrix matrix(ITsVariable var, TsDomain domain) {
        Matrix m = new Matrix(domain.getLength(), var.getDim());
        var.data(domain, m.columnList());
        return m;
    }

    public static TsData toTsData(ITsVariable var, TsDomain sdom) {
        if (var.getDim() != 1) {
            return null;
        }
        if (sdom == null) {
            TsDomain d = var.getDefinitionDomain();
            if (d != null) {
                List<DataBlock> data = Collections.singletonList(new DataBlock(d.getLength()));
                var.data(d, data);
                return new TsData(d.getStart(), data.get(0));
            }
            return null;
        }
        TsFrequency dfreq = var.getDefinitionFrequency();
        TsDomain ddom = var.getDefinitionDomain();
        if (dfreq != TsFrequency.Undefined && dfreq != sdom.getFrequency()) {
            return null;
        }
        if (ddom == null || ddom.contains(sdom)) {
            List<DataBlock> data = Collections.singletonList(new DataBlock(sdom.getLength()));
            var.data(sdom, data);
            return new TsData(sdom.getStart(), data.get(0));
        }
        return null;
    }
}

