/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.utilities.IntList;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoublePredicate;

public interface IReadDataBlock {
    public void copyTo(double[] var1, int var2);

    public double get(int var1);

    public int getLength();

    public IReadDataBlock rextract(int var1, int var2);

    default public boolean check(DoublePredicate pred) {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            if (pred.test(this.get(i))) continue;
            return false;
        }
        return true;
    }

    default public int count(DoublePredicate pred) {
        int n = this.getLength();
        int m = 0;
        for (int i = 0; i < n; ++i) {
            if (!pred.test(this.get(i))) continue;
            ++m;
        }
        return m;
    }

    default public int first(DoublePredicate pred) {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            if (!pred.test(this.get(i))) continue;
            return i;
        }
        return n;
    }

    default public int last(DoublePredicate pred) {
        int n = this.getLength();
        for (int i = n - 1; i >= 0; --i) {
            if (!pred.test(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    default public double computeRecursively(double initial, DoubleBinaryOperator fn) {
        double cur = initial;
        int n = this.getLength();
        for (int i = n - 1; i >= 0; --i) {
            cur = fn.applyAsDouble(cur, this.get(i));
        }
        return cur;
    }

    default public int[] search(DoublePredicate pred) {
        IntList list = new IntList();
        int n = this.getLength();
        for (int j = 0; j < n; ++j) {
            double cur = this.get(j);
            if (!pred.test(cur)) continue;
            list.add(j);
        }
        return list.toArray();
    }

    default public double sum() {
        int n = this.getLength();
        double s = 0.0;
        for (int i = 0; i < n; ++i) {
            double cur = this.get(i);
            if (!Double.isFinite(cur)) continue;
            s += cur;
        }
        return s;
    }

    default public double ssq() {
        int n = this.getLength();
        double s = 0.0;
        for (int i = 0; i < n; ++i) {
            double cur = this.get(i);
            if (!Double.isFinite(cur)) continue;
            s += cur * cur;
        }
        return s;
    }

    default public double ssqc(double mean) {
        int n = this.getLength();
        double s = 0.0;
        for (int i = 0; i < n; ++i) {
            double cur = this.get(i) - mean;
            if (!Double.isFinite(cur)) continue;
            s += cur * cur;
        }
        return s;
    }

    default public double average() {
        int n = this.getLength();
        int m = 0;
        double s = 0.0;
        for (int i = 0; i < n; ++i) {
            double cur = this.get(i);
            if (Double.isFinite(cur)) {
                s += cur;
                continue;
            }
            ++m;
        }
        return s / (double)(n - m);
    }

    default public double dot(IReadDataBlock data) {
        int n = this.getLength();
        double s = 0.0;
        for (int i = 0; i < n; ++i) {
            s += this.get(i) * data.get(i);
        }
        return s;
    }

    default public double distance(IReadDataBlock data) {
        double scale = 0.0;
        double ssq = 1.0;
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            double s;
            double d;
            double y;
            double x = this.get(i);
            if (Double.compare(x, y = data.get(i)) == 0 || (d = x - y) == 0.0) continue;
            double absxi = Math.abs(d);
            if (scale < absxi) {
                s = scale / absxi;
                ssq = 1.0 + ssq * s * s;
                scale = absxi;
                continue;
            }
            s = absxi / scale;
            ssq += s * s;
        }
        return scale * Math.sqrt(ssq);
    }

    default public boolean isMissing(int idx) {
        return !Double.isFinite(this.get(idx));
    }

    public static double round(double r, int ndec) {
        if (ndec < 0) {
            throw new IllegalArgumentException("Negative rounding parameter");
        }
        double f = 1.0;
        for (int i = 0; i < ndec; ++i) {
            f *= 10.0;
        }
        if (Double.isFinite(r)) {
            double v = r;
            r = ndec > 0 ? (double)Math.round(v * f) / f : (double)Math.round(v);
        }
        return r;
    }

    default public int getRepeatCount() {
        int i;
        int n = this.getLength();
        for (i = 0; i < n && !Double.isFinite(this.get(i)); ++i) {
        }
        if (i == n) {
            return 0;
        }
        int c = 0;
        double prev = this.get(i++);
        while (i < n) {
            double cur = this.get(i);
            if (Double.isFinite(cur)) {
                if (cur == prev) {
                    ++c;
                } else {
                    prev = cur;
                }
            }
            ++i;
        }
        return c;
    }
}

