/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.seats;

import ec.satoolkit.seats.IModelValidator;
import ec.satoolkit.seats.ModelStatus;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.utilities.Arrays2;

public class DefaultModelValidator
implements IModelValidator {
    public static final double DEF_XL = 0.95;
    private double xl = 0.95;
    public static final double DEF_EPS = 1.0E-4;
    private double eps = 1.0E-4;
    private SarimaModel newModel;

    public DefaultModelValidator() {
    }

    public DefaultModelValidator(double xl) {
        this.xl = xl;
    }

    @Override
    public SarimaModel getNewModel() {
        return this.newModel;
    }

    public double getXl() {
        return this.xl;
    }

    private boolean maStabilize(double ur, DataBlock p, int start, int n) {
        if (n == 1) {
            double q = p.get(start);
            if (q < -ur) {
                p.set(start, -ur);
                return true;
            }
            if (q > ur) {
                p.set(start, ur);
                return true;
            }
            return false;
        }
        double[] P = Polynomial.Doubles.fromDegree(n);
        P[0] = 1.0;
        for (int i = 0; i < n; ++i) {
            P[i + 1] = p.get(start + i);
        }
        boolean changed = false;
        Complex[] roots = Arrays2.copyOf(Polynomial.of(P).roots());
        for (int i = 0; i < roots.length; ++i) {
            Complex root = roots[i];
            double q = 1.0 / roots[i].abs();
            if (!(q > ur)) continue;
            changed = true;
            roots[i] = root.times(q / ur);
        }
        if (!changed) {
            return false;
        }
        Polynomial ptmp = Polynomial.fromComplexRoots(roots);
        ptmp = ptmp.divide(ptmp.get(0));
        for (int i = 0; i < n; ++i) {
            p.set(start + i, ptmp.get(i + 1));
        }
        return true;
    }

    public void setXl(double xl) {
        this.xl = xl;
    }

    @Override
    public ModelStatus validate(SarimaModel model, InformationSet info) {
        this.newModel = model;
        ModelStatus smp = this.simplifyModel(info);
        ModelStatus ma = this.validateMA(info);
        if (ma == ModelStatus.Invalid) {
            return ModelStatus.Invalid;
        }
        ModelStatus ar = this.validateAR(info);
        if (ar == ModelStatus.Invalid) {
            return ModelStatus.Invalid;
        }
        if (smp == ModelStatus.Changed || ar == ModelStatus.Changed || ma == ModelStatus.Changed) {
            return ModelStatus.Changed;
        }
        return ModelStatus.Valid;
    }

    protected ModelStatus validateAR(InformationSet info) {
        return ModelStatus.Valid;
    }

    protected boolean fixMaUnitRoots(SarimaModel arima) {
        boolean changed;
        block10: {
            double ur;
            SarimaSpecification spec;
            block8: {
                double th;
                block9: {
                    spec = arima.getSpecification();
                    changed = false;
                    ur = 1.0 - this.eps;
                    if (spec.getBQ() > 0) {
                        double sur = Math.pow(ur, arima.getFrequency());
                        double bth = arima.btheta(1);
                        if (bth < -sur) {
                            changed = true;
                            arima.setBTheta(1, -1.0);
                        } else if (bth > sur) {
                            changed = true;
                            arima.setBTheta(1, 1.0);
                        }
                    }
                    if (spec.getQ() != 1) break block8;
                    th = arima.theta(1);
                    if (!(th < -ur)) break block9;
                    changed = true;
                    arima.setTheta(1, -1.0);
                    break block10;
                }
                if (!(th > ur)) break block10;
                changed = true;
                arima.setTheta(1, 1.0);
                break block10;
            }
            if (spec.getQ() > 1) {
                int i;
                Polynomial q = arima.getRegularMA();
                Complex[] roots = q.roots();
                boolean qchanged = false;
                for (i = 0; i < roots.length; ++i) {
                    double l = roots[i].abs();
                    if (!(l < ur)) continue;
                    qchanged = true;
                    roots[i] = roots[i].div(l);
                }
                if (qchanged) {
                    q = Polynomial.fromComplexRoots(roots);
                    for (i = 1; i <= spec.getQ(); ++i) {
                        arima.setTheta(i, q.get(i) / q.get(0));
                    }
                }
            }
        }
        return changed;
    }

    protected ModelStatus validateMA(InformationSet info) {
        if (this.xl < 1.0) {
            SarimaSpecification spec = this.newModel.getSpecification();
            boolean rslt = false;
            DataBlock p = new DataBlock(this.newModel.getParameters());
            if (spec.getQ() > 0 && this.maStabilize(this.xl, p, spec.getP() + spec.getBP(), spec.getQ())) {
                rslt = true;
            }
            if (spec.getBQ() > 0 && this.maStabilize(this.xl, p, spec.getP() + spec.getBP() + spec.getQ(), spec.getBQ())) {
                rslt = true;
            }
            if (rslt) {
                this.newModel.setParameters(p);
                return ModelStatus.Changed;
            }
            return ModelStatus.Valid;
        }
        if (this.fixMaUnitRoots(this.newModel)) {
            return ModelStatus.Changed;
        }
        return ModelStatus.Valid;
    }

    protected ModelStatus simplifyModel(InformationSet info) {
        if (this.newModel.adjustSpecification()) {
            return ModelStatus.Changed;
        }
        return ModelStatus.Valid;
    }
}

