/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.polynomials;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.polynomials.IRootsSolver;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.PolynomialException;
import ec.tstoolkit.utilities.Arrays2;

public class Laguerre2
implements IRootsSolver {
    private final double m_AbsoluteAccuracy = 1.0E-6;
    private final double m_RelativeAccuracy = 1.0E-14;
    private final double m_FunctionValueAccuracy = 1.0E-15;
    private Complex[] m_roots;
    private Polynomial m_remainder;
    private int m_niterations;
    private final int m_maximalIterationCount = 100;

    @Override
    public void clear() {
        this.m_roots = null;
        this.m_remainder = null;
    }

    @Override
    public boolean factorize(Polynomial p) {
        try {
            this.m_niterations = 0;
            int d = p.getDegree();
            this.m_roots = new Complex[d];
            Complex[] a = new Complex[d + 1];
            for (int u = 0; u <= d; ++u) {
                a[u] = Complex.cart(p.get(u), 0.0);
            }
            this.zroots(a, this.m_roots);
            this.m_remainder = Polynomial.valueOf(p.get(p.getDegree()), new double[0]);
            return true;
        }
        catch (PolynomialException e) {
            this.m_remainder = p;
            this.m_roots = null;
            return false;
        }
    }

    @Override
    public Polynomial remainder() {
        return this.m_remainder;
    }

    @Override
    public Complex[] roots() {
        return this.m_roots;
    }

    @Override
    public Laguerre2 exemplar() {
        Laguerre2 solver = new Laguerre2();
        return solver;
    }

    public Complex solve(Complex[] coefficients, Complex initial) throws PolynomialException {
        int n = coefficients.length - 1;
        Complex N = Complex.cart(n, 0.0);
        Complex N1 = Complex.cart(n - 1, 0.0);
        Complex pv = null;
        Complex dv = null;
        Complex d2v = null;
        Complex G = null;
        Complex G2 = null;
        Complex H = null;
        Complex delta = null;
        Complex denominator = null;
        Complex z = initial;
        Complex oldz = Complex.cart(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        for (int i = 1; i <= 100; ++i) {
            pv = coefficients[n];
            dv = Complex.ZERO;
            d2v = Complex.ZERO;
            for (int j = n - 1; j >= 0; --j) {
                d2v = dv.plus(z.times(d2v));
                dv = pv.plus(z.times(dv));
                pv = coefficients[j].plus(z.times(pv));
            }
            d2v = d2v.times(Complex.TWO);
            double tolerance = Math.max(this.m_RelativeAccuracy * z.abs(), this.m_AbsoluteAccuracy);
            if (z.minus(oldz).abs() <= tolerance) {
                this.m_niterations = i;
                return z;
            }
            if (pv.abs() <= this.m_FunctionValueAccuracy) {
                this.m_niterations = i;
                return z;
            }
            G = dv.div(pv);
            G2 = G.times(G);
            H = G2.minus(d2v.div(pv));
            delta = N1.times(N.times(H).minus(G2));
            Complex deltaSqrt = delta.sqrt();
            Complex dplus = G.plus(deltaSqrt);
            Complex dminus = G.minus(deltaSqrt);
            Complex complex = denominator = dplus.abs() > dminus.abs() ? dplus : dminus;
            if (denominator.equals((Object)Complex.ZERO)) {
                z = z.plus(Complex.cart(this.m_AbsoluteAccuracy, this.m_AbsoluteAccuracy));
                oldz = Complex.cart(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                continue;
            }
            oldz = z;
            z = z.minus(N.div(denominator));
        }
        throw new PolynomialException("Laguerre failed");
    }

    void zroots(Complex[] coefficients, Complex[] roots) {
        int n = coefficients.length - 1;
        int literationCount = 0;
        if (n < 1) {
            return;
        }
        Complex[] c = Arrays2.copyOf(coefficients);
        Complex[] root = new Complex[n];
        for (int i = 0; i < n; ++i) {
            Complex[] subarray = new Complex[n - i + 1];
            System.arraycopy(c, 0, subarray, 0, subarray.length);
            root[i] = this.solve(subarray, Complex.ZERO);
            Complex newc = c[n - i];
            Complex oldc = null;
            for (int j = n - i - 1; j >= 0; --j) {
                oldc = c[j];
                c[j] = newc;
                newc = oldc.plus(newc.times(root[i]));
            }
            literationCount += this.m_niterations;
        }
        this.m_roots = root;
        this.m_niterations = literationCount;
    }
}

