/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.polynomials;

import ec.tstoolkit.design.VisibleForTesting;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.polynomials.Function;
import ec.tstoolkit.maths.polynomials.IRootsSolver;
import ec.tstoolkit.maths.polynomials.LeastSquaresDivision;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.realfunctions.GridSearch;
import ec.tstoolkit.utilities.Ref;

public class SymmetricMullerNewtonSolver
implements IRootsSolver {
    private double[] m_p;
    private double[] m_pred;
    private Complex[] m_roots;
    private Polynomial m_remainder;
    private int m_idx;
    private int m_degree;
    private double m_maxerr;
    private static final int MITERMAX = 150;
    private static final int MCONVERGENCE = 100;
    private static final double MMAXDIST = 1000.0;
    private static final double MFACTOR = 100000.0;
    private static final double MKITERMAX = 1000.0;
    private static final double MFVALUE = 1.0E36;
    private static final double MBOUND1 = 1.01;
    private static final double MBOUND2 = 0.99;
    private static final double MBOUND3 = 0.01;
    private final double MBOUND4 = Math.sqrt(Double.MAX_VALUE) / 10000.0;
    private final double MBOUND6 = Math.log10(this.MBOUND4) - 4.0;
    private static final double MBOUND7 = 1.0E-5;
    private final double MNOISESTART;
    private static final double MNOISEMAX = 5.0;
    private static final int NITERMAX = 20;
    private static final double NFACTOR = 5.0;
    private static final double NFVALUE = 1.0E36;
    private static final double ISQRT2 = 1.0 / Math.sqrt(2.0);
    private final double NBOUND = Math.sqrt(2.220446049250313E-16);
    private static final int NNOISEMAX = 5;
    private static final double DBL_EPSILON = 2.220446049250313E-16;
    Complex x0 = Complex.ZERO;
    Complex x1 = Complex.ZERO;
    Complex x2 = Complex.ZERO;
    Complex h1 = Complex.ZERO;
    Complex h2 = Complex.ZERO;
    Complex q2 = Complex.ZERO;
    final Ref<Complex> f0 = new Ref<Complex>(Complex.ZERO);
    final Ref<Complex> f1 = new Ref<Complex>(Complex.ZERO);
    final Ref<Complex> f2 = new Ref<Complex>(Complex.ZERO);
    int iter;
    private boolean lqdiv = true;
    private static final Complex[] COMPLEX_FOR_ITER = SymmetricMullerNewtonSolver.initComplexForIter(150);
    private static double B_EPS = 0.1;
    static final double OPT_MIN = 1.0E-5;

    private static void fdvalue(double[] p, int i0, Ref<Complex> f, Complex x) {
        int n = p.length - 1;
        double re = p[n];
        double im = 0.0;
        double xr = x.getRe();
        double xi = x.getIm();
        for (int i = n - 1; i >= i0; --i) {
            double rtmp = xr * re - xi * im + p[i];
            double itmp = xr * im + re * xi;
            re = rtmp;
            im = itmp;
        }
        f.val = Complex.cart(re, im);
    }

    private static void fdvalue(double[] p, int i0, Ref<Complex> f, Ref<Complex> df, Complex x) {
        int n = p.length - 1;
        double xr = x.getRe();
        double xi = x.getIm();
        double fr = p[n];
        double fi = 0.0;
        double dfr2 = 0.0;
        double dfi = 0.0;
        for (int i = n - 1; i >= i0; --i) {
            double tr = xr * dfr2 - xi * dfi + fr;
            double ti = xr * dfi + dfr2 * xi + fi;
            dfr2 = tr;
            dfi = ti;
            tr = xr * fr - xi * fi + p[i];
            ti = xr * fi + fr * xi;
            fr = tr;
            fi = ti;
        }
        df.val = Complex.cart(dfr2, dfi);
        f.val = Complex.cart(fr, fi);
    }

    public SymmetricMullerNewtonSolver() {
        this.MNOISESTART = 2.220446049250313E-14;
    }

    private void check_x_value(Ref<Complex> xb, Ref.DoubleRef f2absqb, Ref.BooleanRef rootd, double f1absq, double f2absq, double epsilon, Ref.IntRef noise) {
        if (f2absq <= 1.01 * f1absq && f2absq >= 0.99 * f1absq) {
            if (this.h2.abs() < 0.01) {
                this.q2 = this.q2.times(2.0);
                this.h2 = this.h2.times(2.0);
            } else {
                this.q2 = SymmetricMullerNewtonSolver.getComplexForIterationCounter(this.iter);
                this.h2 = this.h2.times(this.q2);
            }
        } else if (f2absq < f2absqb.val) {
            f2absqb.val = f2absq;
            xb.val = this.x2;
            noise.val = 0;
            if (Math.sqrt(f2absq) < epsilon && this.x2.minus(this.x1).div(this.x2).abs() < epsilon) {
                rootd.val = true;
            }
        }
    }

    @Override
    public void clear() {
        this.m_roots = null;
        this.m_remainder = null;
    }

    @Override
    public SymmetricMullerNewtonSolver exemplar() {
        SymmetricMullerNewtonSolver solver = new SymmetricMullerNewtonSolver();
        return solver;
    }

    private void compute_function(double f1absq, Ref.DoubleRef f2absq, double epsilon) {
        Ref.IntRef overflow = new Ref.IntRef(0);
        do {
            overflow.val = 0;
            this.suppress_overflow();
            SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f2, this.x2);
            this.too_big_functionvalues(f2absq);
            ++this.iter;
            this.convergence_check(overflow, f1absq, f2absq.val, epsilon);
        } while (overflow.val != 0);
    }

    private void convergence_check(Ref.IntRef overflow, double f1absq, double f2absq, double epsilon) {
        if (f2absq > 100.0 * f1absq && this.q2.abs() > epsilon && this.iter < 150) {
            this.q2 = this.q2.times(0.5);
            this.h2 = this.h2.times(0.5);
            this.x2 = this.x2.minus(this.h2);
            overflow.val = 1;
        }
    }

    @Override
    public boolean factorize(Polynomial p) {
        try {
            if (!p.isSymmetric()) {
                return false;
            }
            this.m_degree = p.getDegree();
            this.m_roots = new Complex[this.m_degree / 2];
            this.m_p = new double[this.m_degree + 1];
            p.copyTo(this.m_p, 0);
            this.m_pred = (double[])this.m_p.clone();
            if (!this.newtonnull()) {
                return false;
            }
            this.m_remainder = Polynomial.valueOf(p.get(this.m_degree), new double[0]);
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    private void initialize(Ref<Complex> xb, Ref.DoubleRef epsilon) {
        this.x0 = Complex.ZERO;
        this.x1 = Complex.cart(-ISQRT2, -ISQRT2);
        this.x2 = Complex.cart(ISQRT2, ISQRT2);
        this.h1 = this.x1.minus(this.x0);
        this.h2 = this.x2.minus(this.x1);
        this.q2 = this.h2.div(this.h1);
        xb.val = this.x2;
        epsilon.val = 2.220446049250313E-11;
        this.iter = 0;
    }

    private void iteration_equation(Ref.DoubleRef h2abs) {
        this.h2 = this.h2.times(this.q2);
        double h2absnew = this.h2.abs();
        if (h2absnew > h2abs.val * 1000.0) {
            double help = 1000.0 / h2absnew;
            this.h2 = this.h2.times(help);
            this.q2 = this.q2.times(help);
        }
        h2abs.val = h2absnew;
        this.x2 = this.x2.plus(this.h2);
    }

    private void monic() {
        int n = this.m_p.length - 1;
        double factor = Math.abs(1.0 / this.m_p[n]);
        if (factor != 1.0) {
            int i = 0;
            while (i <= n) {
                int n2 = i++;
                this.m_p[n2] = this.m_p[n2] * factor;
            }
        }
    }

    private Complex muller() {
        double f1absq = 1.0E36;
        Ref.DoubleRef f2absq = new Ref.DoubleRef(1.0E36);
        Ref.DoubleRef f2absqb = new Ref.DoubleRef(1.0E36);
        Ref.DoubleRef h2abs = new Ref.DoubleRef(0.0);
        Ref.DoubleRef epsilon = new Ref.DoubleRef(0.0);
        Ref.IntRef seconditer = new Ref.IntRef(0);
        Ref.IntRef noise = new Ref.IntRef(0);
        Ref.BooleanRef rootd = new Ref.BooleanRef(false);
        Ref<Complex> xb = new Ref<Complex>(Complex.ZERO);
        this.initialize(xb, epsilon);
        SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f0, this.x0);
        SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f1, this.x1);
        SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f2, this.x2);
        while (true) {
            this.root_of_parabola();
            this.x0 = this.x1;
            this.x1 = this.x2;
            h2abs.val = this.h2.abs();
            this.iteration_equation(h2abs);
            this.f0.val = this.f1.val;
            this.f1.val = this.f2.val;
            f1absq = f2absq.val;
            this.compute_function(f1absq, f2absq, epsilon.val);
            this.check_x_value(xb, f2absqb, rootd, f1absq, f2absq.val, epsilon.val, noise);
            double xb_abs = ((Complex)xb.val).abs();
            if (Math.abs(xb_abs - this.x2.abs()) / xb_abs < this.MNOISESTART) {
                ++noise.val;
            }
            if (this.iter <= 150 && !rootd.val && (double)noise.val <= 5.0) continue;
            ++seconditer.val;
            this.root_check(f2absqb.val, seconditer, rootd, noise, (Complex)xb.val);
            if (seconditer.val != 2) break;
        }
        return (Complex)xb.val;
    }

    private Complex newton(Complex ns, Ref.DoubleRef dxabs) {
        double axmin2;
        Complex xcur;
        double fabsmin = 1.0E36;
        double eps = 2.220446049250313E-16;
        int noise = 0;
        Complex xmin = xcur = ns;
        Complex dx = Complex.ONE;
        dxabs.val = dx.abs();
        for (int i = 0; i < 20; ++i) {
            double axmin;
            Complex dxh;
            Ref<Complex> f = new Ref<Complex>(Complex.ZERO);
            Ref<Complex> df = new Ref<Complex>(Complex.ZERO);
            SymmetricMullerNewtonSolver.fdvalue(this.m_p, 0, f, df, xcur);
            if (((Complex)f.val).abs() < fabsmin) {
                xmin = xcur;
                fabsmin = ((Complex)f.val).abs();
                noise = 0;
            }
            if (((Complex)df.val).abs() > eps && (dxh = ((Complex)f.val).div((Complex)df.val)).abs() < dxabs.val * 5.0) {
                dx = dxh;
                dxabs.val = dx.abs();
            }
            if ((axmin = xmin.abs()) != 0.0 && (dxabs.val / axmin < eps || noise == 5)) {
                if (Math.abs(xmin.getIm()) < this.NBOUND) {
                    xmin = Complex.cart(xmin.getRe(), 0.0);
                }
                dxabs.val /= axmin;
                return xmin;
            }
            xcur = xcur.minus(dx);
            ++noise;
        }
        if (Math.abs(xmin.getIm()) < this.NBOUND) {
            xmin = Complex.cart(xmin.getRe(), 0.0);
        }
        if ((axmin2 = xmin.abs()) != 0.0) {
            dxabs.val /= axmin2;
        }
        return xmin;
    }

    private boolean newtonnull() {
        Ref.DoubleRef newerr = new Ref.DoubleRef(0.0);
        this.m_maxerr = 0.0;
        this.roots_at_zero();
        if (this.m_idx == this.m_p.length - 1) {
            return true;
        }
        if (this.quadratic()) {
            this.m_maxerr = 2.220446049250313E-16;
            return true;
        }
        this.monic();
        do {
            Complex ns = this.muller();
            Complex nroot = this.newton(ns, newerr);
            if (newerr.val > this.m_maxerr) {
                this.m_maxerr = newerr.val;
            }
            if (!(nroot.getIm() == 0.0 ? !this.update(nroot.getRe()) : !this.update(nroot))) continue;
            return false;
        } while (this.m_p.length - this.m_idx > 3);
        return this.m_idx == this.m_degree || this.quadratic();
    }

    private boolean quadratic() {
        if (this.m_idx != this.m_degree - 2) {
            return false;
        }
        double a = this.m_pred[this.m_idx + 2];
        double b = this.m_pred[this.m_idx + 1] / a;
        double c = this.m_pred[this.m_idx] / a;
        double rdiscr = b * b - 4.0 * c;
        if (rdiscr >= 0.0) {
            double z = Math.sqrt(rdiscr);
            this.m_roots[this.m_idx / 2] = b < 0.0 ? Complex.cart((-b + z) / 2.0) : Complex.cart((-b - z) / 2.0);
            return true;
        }
        if (rdiscr < -1.0E-5) {
            return false;
        }
        this.m_roots[this.m_idx / 2] = Complex.cart(-b / 2.0);
        return true;
    }

    @Override
    public Polynomial remainder() {
        return this.m_remainder;
    }

    private void root_check(double f2absqb, Ref.IntRef seconditer, Ref.BooleanRef rootd, Ref.IntRef noise, Complex xb) {
        Ref<Complex> df = new Ref<Complex>(Complex.ZERO);
        if (seconditer.val == 1 && f2absqb > 0.0) {
            SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f2, df, xb);
            if (((Complex)this.f2.val).abs() / (((Complex)df.val).abs() * xb.abs()) > 1.0E-5) {
                this.x0 = Complex.ONE;
                this.x1 = Complex.NEG_ONE;
                this.x2 = Complex.ZERO;
                SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f0, this.x0);
                SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f1, this.x1);
                SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f2, this.x2);
                this.iter = 0;
                ++seconditer.val;
                rootd.val = false;
                noise.val = 0;
            }
        }
    }

    private void root_of_parabola() {
        double N2_abs;
        Complex A2 = SymmetricMullerNewtonSolver.computeA2(this.q2, (Complex)this.f2.val, (Complex)this.f0.val, (Complex)this.f1.val);
        Complex B2 = SymmetricMullerNewtonSolver.computeB2((Complex)this.f2.val, (Complex)this.f1.val, this.q2, (Complex)this.f0.val);
        Complex C2 = SymmetricMullerNewtonSolver.computeC2(this.q2, (Complex)this.f2.val);
        Complex rdiscr = SymmetricMullerNewtonSolver.computeDiscr(B2, A2, C2).sqrt();
        Complex N1 = B2.minus(rdiscr);
        Complex N2 = B2.plus(rdiscr);
        double N1_abs = N1.abs();
        this.q2 = N1_abs > (N2_abs = N2.abs()) && N1_abs > 2.220446049250313E-16 ? C2.times(-2.0).div(N1) : (N2_abs > 2.220446049250313E-16 ? C2.times(-2.0).div(N2) : SymmetricMullerNewtonSolver.getComplexForIterationCounter(this.iter));
    }

    @VisibleForTesting
    static Complex computeA2(Complex q2, Complex f2, Complex f0, Complex f1) {
        double re0 = q2.getRe();
        double im0 = q2.getIm();
        double re1 = f2.getRe();
        double im1 = f2.getIm();
        double re2 = q2.getRe() * f0.getRe() - q2.getIm() * f0.getIm();
        double im2 = q2.getRe() * f0.getIm() + q2.getIm() * f0.getRe();
        re1 += re2;
        im1 += im2;
        re2 = 1.0 + q2.getRe();
        im2 = q2.getIm();
        double tmp = re2 * f1.getRe() - im2 * f1.getIm();
        im2 = re2 * f1.getIm() + im2 * f1.getRe();
        re2 = tmp;
        tmp = re0 * (re1 -= re2) - im0 * (im1 -= im2);
        im0 = re0 * im1 + im0 * re1;
        re0 = tmp;
        return Complex.cart(re0, im0);
    }

    @VisibleForTesting
    static Complex computeB2(Complex f2, Complex f1, Complex q2, Complex f0) {
        double re0 = f2.getRe() - f1.getRe();
        double im0 = f2.getIm() - f1.getIm();
        double re1 = q2.getRe();
        double im1 = q2.getIm();
        double re2 = q2.getRe();
        double im2 = q2.getIm();
        double re3 = f0.getRe() - f1.getRe();
        double im3 = f0.getIm() - f1.getIm();
        double tmp = re2 * re3 - im2 * im3;
        im2 = re2 * im3 + im2 * re3;
        re2 = tmp;
        re3 = f2.getRe() - f1.getRe();
        im3 = f2.getIm() - f1.getIm();
        tmp = re1 * (re2 += (re3 *= 2.0)) - im1 * (im2 += (im3 *= 2.0));
        im1 = re1 * im2 + im1 * re2;
        re1 = tmp;
        return Complex.cart(re0 += re1, im0 += im1);
    }

    @VisibleForTesting
    static Complex computeC2(Complex q2, Complex f2) {
        double re0 = 1.0 + q2.getRe();
        double im0 = q2.getIm();
        double tmp = re0 * f2.getRe() - im0 * f2.getIm();
        im0 = re0 * f2.getIm() + im0 * f2.getRe();
        re0 = tmp;
        return Complex.cart(re0, im0);
    }

    @VisibleForTesting
    static Complex computeDiscr(Complex B2, Complex A2, Complex C2) {
        double re0 = B2.getRe() * B2.getRe() - B2.getIm() * B2.getIm();
        double im0 = B2.getRe() * B2.getIm() + B2.getIm() * B2.getRe();
        double re1 = A2.getRe() * C2.getRe() - A2.getIm() * C2.getIm();
        double im1 = A2.getRe() * C2.getIm() + A2.getIm() * C2.getRe();
        return Complex.cart(re0 -= (re1 *= 4.0), im0 -= (im1 *= 4.0));
    }

    @Override
    public Complex[] roots() {
        Complex[] r = new Complex[this.m_roots.length * 2];
        for (int i = 0; i < this.m_roots.length; ++i) {
            r[2 * i] = this.m_roots[i];
            r[2 * i + 1] = this.m_roots[i].inv();
        }
        return r;
    }

    public Complex[] getStableRoots() {
        return this.m_roots;
    }

    private void roots_at_zero() {
        this.m_idx = 0;
        while (this.m_idx < this.m_p.length && this.m_p[this.m_idx] == 0.0) {
            this.m_roots[this.m_idx++] = Complex.ZERO;
        }
    }

    private void suppress_overflow() {
        int nred = this.m_pred.length - 1 - this.m_idx;
        boolean loop = false;
        int kiter = 0;
        do {
            loop = false;
            double help = this.x2.abs();
            if (!(help > 1.0) || !(Math.abs((double)nred * Math.log10(help)) > this.MBOUND6)) continue;
            if ((double)(++kiter) < 1000.0) {
                this.h2 = this.h2.times(0.5);
                this.q2 = this.q2.times(0.5);
                this.x2 = this.x2.minus(this.h2);
                loop = true;
                continue;
            }
            kiter = 0;
        } while (loop);
    }

    private void too_big_functionvalues(Ref.DoubleRef f2absq) {
        f2absq.val = Math.abs(((Complex)this.f2.val).getRe()) + Math.abs(((Complex)this.f2.val).getIm()) > this.MBOUND4 ? Math.abs(((Complex)this.f2.val).getRe()) + Math.abs(((Complex)this.f2.val).getIm()) : ((Complex)this.f2.val).absSquare();
    }

    public boolean isLeastSquaresDivision() {
        return this.lqdiv;
    }

    public void setLeastSquaresDivision(boolean lq) {
        this.lqdiv = lq;
    }

    private boolean update(Complex r0) {
        Complex r;
        double nrm = r0.absSquare();
        Complex complex = r = nrm >= 1.0 ? r0 : r0.inv();
        if (!this.lqdiv) {
            this.m_roots[this.m_idx / 2] = r;
            this.m_roots[this.m_idx / 2 + 1] = r.conj();
            this.m_idx += 2;
            double a = -2.0 * r.getRe();
            double b = r.absSquare();
            int n = this.m_degree - 1;
            this.m_pred[n] = this.m_pred[n] - this.m_pred[this.m_degree] * a;
            for (int i = this.m_degree; i > this.m_idx; --i) {
                int n2 = i - 2;
                this.m_pred[n2] = this.m_pred[n2] - (a * this.m_pred[i - 1] + b * this.m_pred[i]);
            }
            this.m_idx += 2;
            Complex ir = r.inv();
            a = -2.0 * ir.getRe();
            b = ir.absSquare();
            int n3 = this.m_degree - 1;
            this.m_pred[n3] = this.m_pred[n3] - this.m_pred[this.m_degree] * a;
            for (int i = this.m_degree; i > this.m_idx; --i) {
                int n4 = i - 2;
                this.m_pred[n4] = this.m_pred[n4] - (a * this.m_pred[i - 1] + b * this.m_pred[i]);
            }
        } else if (Math.abs(nrm - 1.0) > 1.0E-8) {
            double a = -2.0 * r.getRe();
            double b = r.absSquare();
            Polynomial num = Polynomial.copyOf(this.m_pred, this.m_idx, this.m_degree + 1);
            Polynomial div1 = Polynomial.of(new double[]{b, a, 1.0});
            Polynomial div2 = Polynomial.of(new double[]{1.0 / b, a / b, 1.0});
            LeastSquaresDivision lq = new LeastSquaresDivision();
            lq.divide(num, div1.times(div2));
            this.m_roots[this.m_idx / 2] = r;
            this.m_roots[this.m_idx / 2 + 1] = r.conj();
            this.m_idx += 4;
            lq.getQuotient().copyTo(this.m_pred, this.m_idx);
        } else if (!this.optimize(r0)) {
            return false;
        }
        this.reinforceSymmetry();
        return true;
    }

    private boolean update(double r0) {
        double r = Math.abs(r0) >= 1.0 ? r0 : 1.0 / r0;
        double a = -(r0 + 1.0 / r0);
        if (!this.lqdiv) {
            this.m_roots[this.m_idx / 2] = Complex.cart(r);
            this.m_idx += 2;
            int n = this.m_degree - 1;
            this.m_pred[n] = this.m_pred[n] - this.m_pred[this.m_degree] * a;
            for (int i = this.m_degree; i > this.m_idx; --i) {
                int n2 = i - 2;
                this.m_pred[n2] = this.m_pred[n2] - (a * this.m_pred[i - 1] + this.m_pred[i]);
            }
        } else {
            Polynomial num = Polynomial.copyOf(this.m_pred, this.m_idx, this.m_degree + 1);
            Polynomial div = Polynomial.of(new double[]{1.0, a, 1.0});
            LeastSquaresDivision lq = new LeastSquaresDivision();
            lq.divide(num, div);
            this.m_roots[this.m_idx / 2] = Complex.cart(r);
            this.m_idx += 2;
            lq.getQuotient().copyTo(this.m_pred, this.m_idx);
        }
        this.reinforceSymmetry();
        return true;
    }

    private void reinforceSymmetry() {
        int n = this.m_degree - this.m_idx;
        for (int i = 0; i < n / 2; ++i) {
            double q;
            this.m_pred[this.m_idx + i] = q = (this.m_pred[this.m_idx + i] + this.m_pred[this.m_degree - i]) / 2.0;
            this.m_pred[this.m_degree - i] = q;
        }
    }

    private static Complex getComplexForIterationCounter(int iter) {
        return COMPLEX_FOR_ITER[iter];
    }

    private static Complex newComplexForIterationCounter(int iter) {
        return Complex.cart(Math.cos(iter), Math.sin(iter));
    }

    private static Complex[] initComplexForIter(int maxIter) {
        Complex[] result = new Complex[maxIter + 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = SymmetricMullerNewtonSolver.newComplexForIterationCounter(i);
        }
        return result;
    }

    private boolean optimize(Complex r0) {
        Complex nr;
        GridSearch gs = new GridSearch();
        gs.setPrecision(1.0E-12);
        gs.setBounds(Math.max(-1.0, r0.getRe() - B_EPS), Math.min(1.0, r0.getRe() + B_EPS));
        Function fn = new Function(this.m_pred, this.m_idx);
        gs.minimize(fn, fn.evaluate(r0.getRe()));
        Function.FunctionInstance rslt = (Function.FunctionInstance)gs.getResult();
        this.m_roots[this.m_idx / 2] = nr = Complex.cart(rslt.getX(), Math.sqrt(1.0 - rslt.getX() * rslt.getX()));
        this.m_roots[this.m_idx / 2 + 1] = nr.conj();
        this.m_idx += 4;
        double val = rslt.getValue();
        rslt.lq.getQuotient().copyTo(this.m_pred, this.m_idx);
        return val < 1.0E-5;
    }
}

