/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.ssf.FastArrayState;
import ec.tstoolkit.ssf.FastInitializer;
import ec.tstoolkit.ssf.IFastArrayFilteringResults;
import ec.tstoolkit.ssf.IFastArrayInitializer;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.UMatrix;

public class FastArrayFilter<F extends ISsf> {
    private int m_pos;
    private int m_end;
    private int m_dim;
    private int m_ndiffuse;
    private boolean m_steady;
    private final UMatrix m_matrix = new UMatrix();
    private FastArrayState m_state;
    private IFastArrayInitializer<F> m_initializer;
    private F m_ssf;
    private ISsfData m_data;

    public IFastArrayInitializer<F> getInitializer() {
        return this.m_initializer;
    }

    public F getSsf() {
        return this.m_ssf;
    }

    public FastArrayState getState() {
        return this.m_state;
    }

    private boolean initialize(IFastArrayFilteringResults rslts) {
        this.m_state = new FastArrayState(this.m_dim, this.m_data.hasData());
        if (this.m_initializer != null) {
            this.m_ndiffuse = this.m_initializer.initialize(this.m_ssf, this.m_data, this.m_state, rslts);
        } else {
            FastInitializer initializer = new FastInitializer();
            this.m_ndiffuse = initializer.initialize(this.m_ssf, this.m_data, this.m_state, rslts);
        }
        if (this.m_ndiffuse < 0) {
            return false;
        }
        this.m_matrix.K = this.m_state.K.getData();
        this.m_matrix.L = this.m_state.L.getData();
        this.m_pos = this.m_ndiffuse;
        this.m_matrix.R = this.m_state.r;
        return true;
    }

    private void preArray() {
        DataBlock l = new DataBlock(this.m_matrix.L);
        this.m_matrix.Z = this.m_ssf.ZX(this.m_pos, l);
        this.m_ssf.TX(this.m_pos, l);
    }

    public boolean process(ISsfData data, IFastArrayFilteringResults rslts) {
        if (this.m_ssf == null) {
            return false;
        }
        this.m_data = data;
        this.m_dim = this.m_ssf.getStateDim();
        this.m_pos = 0;
        this.m_end = this.m_data.getCount();
        if (!this.initialize(rslts)) {
            return false;
        }
        if (rslts != null) {
            rslts.prepare((ISsf)this.m_ssf, data);
        }
        if (this.m_pos < this.m_end) {
            do {
                this.updateE();
                if (rslts != null) {
                    rslts.save(this.m_pos, this.m_state);
                }
                this.updateA();
                if (this.m_steady) continue;
                this.preArray();
                if (this.m_matrix.triangularize()) continue;
                return false;
            } while (++this.m_pos < this.m_end);
        }
        if (rslts != null) {
            rslts.close();
        }
        return true;
    }

    public void setInitializer(IFastArrayInitializer<F> value) {
        this.m_initializer = value;
    }

    public void setSsf(F value) {
        this.m_ssf = value;
    }

    private void updateA() {
        this.m_ssf.TX(this.m_pos, this.m_state.A);
        double es = this.m_state.e / this.m_state.r;
        this.m_state.A.addAY(es, this.m_state.K);
    }

    private void updateE() {
        double y = this.m_data.get(this.m_pos);
        this.m_state.e = y - this.m_ssf.ZX(this.m_pos, this.m_state.A);
        this.m_state.r = this.m_matrix.R;
    }
}

