/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;

public class ConstDataBlock
implements IReadDataBlock {
    private final int n;
    private final double val;

    public ConstDataBlock(int n) {
        this.n = n;
        this.val = 0.0;
    }

    public ConstDataBlock(double val) {
        this.n = 1;
        this.val = val;
    }

    public ConstDataBlock(int n, double val) {
        this.n = n;
        this.val = val;
    }

    @Override
    public void copyTo(double[] buffer, int start) {
        for (int i = 0; i < this.n; ++i) {
            buffer[start + i] = this.val;
        }
    }

    @Override
    public double get(int idx) {
        return this.val;
    }

    @Override
    public int getLength() {
        return this.n;
    }

    @Override
    public IReadDataBlock rextract(int start, int length) {
        if (start + length > this.n) {
            return DataBlock.EMPTY;
        }
        return new ConstDataBlock(length, this.val);
    }
}

