/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.IRegressionTest;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.SeparateRegressionTest;
import ec.tstoolkit.modelling.arima.tramo.AbstractTramoModule;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;

public class RegressionVariablesController
extends AbstractTramoModule
implements IPreprocessingModule {
    private IRegressionTest tdTest_;
    private IRegressionTest lpTest_;
    private IRegressionTest mhTest_;
    private IRegressionTest meanlTest_;
    private IRegressionTest meanuTest_;
    private static final double DEF_CVAL = 2.0;
    private static final double DEF_LVAL = 0.5;
    private static final double DEF_UVAL = 1.96;
    private static final double DEF_FPROB = 0.01;
    private static final double DEF_ECVAL = 2.2;

    public RegressionVariablesController(double pftd, boolean join) {
        this.tdTest_ = join ? new JointRegressionTest(pftd) : new SeparateRegressionTest(2.0);
        this.lpTest_ = new SeparateRegressionTest(2.0);
        this.mhTest_ = new SeparateRegressionTest(2.2);
        this.meanlTest_ = new SeparateRegressionTest(0.5);
        this.meanuTest_ = new SeparateRegressionTest(1.96);
    }

    public void reset() {
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        Variable search;
        int i;
        boolean hasmean = context.description.isEstimatedMean();
        ModelEstimation oldestimation = context.estimation;
        int nhp = context.description.getArimaComponent().getFreeParametersCount();
        if (!context.description.isEstimatedMean()) {
            context.description.setMean(true);
            ModelEstimation estimation = new ModelEstimation(context.description.buildRegArima());
            estimation.compute(this.getMonitor(), nhp);
            context.estimation = estimation;
        }
        ConcentratedLikelihood ll = context.estimation.getLikelihood();
        boolean changed = false;
        int start = context.description.getRegressionVariablesStartingPosition();
        InformationSet tdsubset = context.information.subSet("calendar");
        InformationSet esubset = context.information.subSet("easter");
        TsVariableList x = context.description.buildRegressionVariables();
        TsVariableSelection<ITsVariable> sel = x.selectCompatible(ITradingDaysVariable.class);
        TsVariableSelection.Item<ITsVariable>[] items = sel.elements();
        boolean usetd = false;
        for (i = 0; i < items.length; ++i) {
            search = context.description.searchVariable((ITsVariable)items[i].variable);
            if (!search.status.needTesting()) continue;
            if (!this.tdTest_.accept(ll, nhp, start + items[i].position, items[i].variable.getDim(), tdsubset)) {
                search.status = RegStatus.Rejected;
                changed = true;
                continue;
            }
            usetd = true;
        }
        sel = x.selectCompatible(ILengthOfPeriodVariable.class);
        items = sel.elements();
        for (i = 0; i < items.length; ++i) {
            search = context.description.searchVariable((ITsVariable)items[i].variable);
            if (!search.status.needTesting() || usetd && this.lpTest_.accept(ll, nhp, start + items[i].position, items[i].variable.getDim(), tdsubset)) continue;
            search.status = RegStatus.Rejected;
            changed = true;
        }
        sel = x.selectCompatible(IMovingHolidayVariable.class);
        items = sel.elements();
        for (i = 0; i < items.length; ++i) {
            search = context.description.searchVariable((ITsVariable)items[i].variable);
            if (!search.status.needTesting() || this.mhTest_.accept(ll, nhp, start + items[i].position, items[i].variable.getDim(), esubset)) continue;
            search.status = RegStatus.Rejected;
            changed = true;
        }
        boolean mean = hasmean;
        if (context.automodelling) {
            if (!this.meanlTest_.accept(ll, nhp, 0, 1, null)) {
                mean = false;
            } else if (this.meanuTest_.accept(ll, nhp, 0, 1, null)) {
                mean = true;
            }
        }
        boolean mchanged = false;
        context.description.setMean(mean);
        if (mean != hasmean) {
            mchanged = true;
            if (!changed && !mean) {
                context.estimation = oldestimation;
            }
        } else if (!changed) {
            context.estimation = oldestimation;
        }
        if (changed) {
            RegArimaModel<SarimaModel> nregarima = context.description.buildRegArima();
            nregarima.setArima(context.estimation.getArima());
            context.estimation = new ModelEstimation(nregarima, context.description.getLikelihoodCorrection());
            context.estimation.computeLikelihood(nhp);
            return ProcessingResult.Changed;
        }
        return mchanged ? ProcessingResult.Changed : ProcessingResult.Unchanged;
    }
}

