/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.IDocumented;
import ec.tstoolkit.MetaData;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.stats.NiidTests;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

public class Residuals
implements IDocumented {
    private double[] m_values;
    private TsDomain m_domain;
    private Type m_type;
    private NiidTests tests_;
    private MetaData m_metadata = new MetaData();

    public NiidTests getTests() {
        return this.tests_;
    }

    public Type getType() {
        return this.m_type;
    }

    public void setType(Type value) {
        this.m_type = value;
    }

    public double[] getValues() {
        return this.m_values;
    }

    public void setValues(double[] value) {
        this.m_values = (double[])value.clone();
    }

    public TsDomain getDomain() {
        return this.m_domain;
    }

    public void setDomain(TsDomain value) {
        this.m_domain = value;
    }

    public boolean calc(int nhp, int nx) {
        if (this.m_values == null) {
            return false;
        }
        try {
            this.tests_ = new NiidTests(new ReadDataBlock(this.m_values), this.m_domain != null ? this.m_domain.getFrequency().intValue() : 0, nhp, this.m_domain != null && this.m_domain.getFrequency() != TsFrequency.Yearly);
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public TsData getTsValues() {
        if (this.m_domain == null || this.m_values == null) {
            return null;
        }
        return new TsData(this.m_domain.getStart(), this.m_values, true);
    }

    @Override
    public MetaData getMetaData() {
        return this.m_metadata;
    }

    public static enum Type {
        Undefined,
        OneStepAHead,
        MLEstimate,
        QR_Transformed,
        FullResiduals;

    }
}

