/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.timeseries.simplets.ITsDataInterpolator;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.utilities.IntList;

public class ConstInterpolator
implements ITsDataInterpolator {
    public static final double BIGVALUE = 1.0E10;
    public final double value;

    public ConstInterpolator() {
        this.value = Double.NaN;
    }

    public ConstInterpolator(double val) {
        this.value = val;
    }

    @Override
    public boolean interpolate(TsData data, IntList missingpos) {
        if (!data.hasMissingValues()) {
            return true;
        }
        double nval = this.value;
        if (Double.isNaN(nval)) {
            DescriptiveStatistics stats = new DescriptiveStatistics(data);
            nval = stats.getAverage();
        }
        double[] val = data.internalStorage();
        for (int i = 0; i < val.length; ++i) {
            if (Double.isFinite(val[i])) continue;
            missingpos.add(i);
            val[i] = nval;
        }
        return true;
    }
}

