/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.analysis;

import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.timeseries.analysis.ITsProcessing;
import ec.tstoolkit.timeseries.analysis.MovingProcessingFacade;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.DoubleList;
import java.util.LinkedHashMap;
import java.util.Map;

public class MovingProcessing<T extends IProcResults> {
    private MovingProcessingFacade m_processing;

    public MovingProcessing(ITsProcessing<T> processing, TsDomain domain) {
        this.m_processing = new MovingProcessingFacade<T>(processing, domain);
    }

    public ITsProcessing<T> getProcessing() {
        return this.m_processing.getProcessing();
    }

    public TsDomain getReferenceDomain() {
        return this.m_processing.getDomain();
    }

    public T getReferenceInfo() {
        return this.m_processing.tsInfo(this.m_processing.getDomain());
    }

    public TsPeriod getStart() {
        return this.m_processing.getStart();
    }

    public int getWindowIncrement() {
        return this.m_processing.getIncrement();
    }

    public int getWindowLength() {
        return this.m_processing.getLength();
    }

    public Map<TsDomain, Double> movingInfo(String key) {
        return this.movingInfo(key, this.m_processing.getStart(), this.m_processing.getLength(), this.m_processing.getIncrement());
    }

    public Map<TsDomain, Double> movingInfo(String key, TsPeriod start, int length, int increment) {
        LinkedHashMap<TsDomain, Double> map = new LinkedHashMap<TsDomain, Double>();
        DoubleList rslt = new DoubleList();
        TsDomain domain = new TsDomain(start, length);
        while (domain.getEnd().isNotAfter(this.m_processing.getDomain().getEnd())) {
            Double data = this.m_processing.getData(key, domain);
            if (data != null) {
                map.put(domain, data);
            } else {
                map.put(domain, Double.NaN);
            }
            domain = domain.move(increment);
        }
        return map;
    }

    public void setStart(TsPeriod value) {
        value.clone();
    }

    public void setWindowIncrement(int value) {
        this.m_processing.setIncrement(value);
    }

    public void setWindowLength(int value) {
        this.m_processing.setLength(value);
    }
}

